/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.file.types.gzip;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.baja.file.BIFile;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public interface BIGzipFile
extends BIFile {
    public static final Type TYPE = Sys.loadType(BIGzipFile.class);
    public static final Pattern fileNamePattern = Pattern.compile("(.+)\\.(\\w+)\\.gz$", 2);
    public static final String gzipMimeType = "application/gzip";

    default public String getGzippedMimeType() {
        return this.getMimeType();
    }

    public static String getGzippedMimeType(String fileName) {
        String innerMimeType = "application/octet-stream";
        String innerExt = BIGzipFile.getInnerGzippedFileExtension(fileName);
        if (!innerExt.isEmpty()) {
            BIFile file = (BIFile)Sys.getRegistry().getFileTypeForExtension(innerExt).getInstance();
            innerMimeType = file.getMimeType();
        }
        return innerMimeType;
    }

    public static String getInnerGzippedFileExtension(String fileName) {
        Matcher matcher = fileNamePattern.matcher(fileName);
        return matcher.find() ? matcher.group(2).toLowerCase(Locale.ENGLISH) : "";
    }
}

