/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.file.exporters;

import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.file.BExporter;
import javax.baja.file.ExportOp;
import javax.baja.file.types.text.BTextFile;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

public class BITableToText
extends BExporter {
    public static final Property columnSeparator = BITableToText.newProperty((int)0, (String)"", null);
    public static final Type TYPE = Sys.loadType(BITableToText.class);
    static final int pad = 2;

    public String getColumnSeparator() {
        return this.getString(columnSeparator);
    }

    public void setColumnSeparator(String v) {
        this.setString(columnSeparator, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public TypeInfo getFileType() {
        return BTextFile.TYPE.getTypeInfo();
    }

    public String getFileExtension() {
        return "txt";
    }

    public void export(ExportOp op) throws Exception {
        this.export((BITable)op.get(), op);
    }

    public void export(BITable<?> table, ExportOp op) throws Exception {
        ArrayList<Row> rows = new ArrayList<Row>();
        Column[] cols = table.getColumns().list();
        int colCount = cols.length;
        int[] maxWidth = new int[colCount];
        Row header = new Row(colCount);
        for (int i = 0; i < colCount; ++i) {
            Cell cell;
            BFacets colFacets = cols[i].getFacets();
            BUnit units = null;
            BObject sName = null;
            if (null != colFacets) {
                units = (BUnit)colFacets.get("units");
                sName = colFacets.get("SERIES_NAME");
            }
            String name = cols[i].getDisplayName((Context)op);
            if (null != sName) {
                name = sName.toString((Context)op);
            }
            if (null != units && units != BUnit.NULL) {
                name = name + " (" + units.toString((Context)op) + ")";
            }
            header.cells[i] = cell = new Cell(name);
            maxWidth[i] = cell.width;
        }
        rows.add(header);
        Context[] colCx = new Context[colCount];
        for (int i = 0; i < colCx.length; ++i) {
            colCx[i] = new BasicContext((Context)op, cols[i].getFacets());
        }
        TableCursor cursor = table.cursor();
        while (cursor.next()) {
            Row row = new Row(colCount);
            for (int i = 0; i < colCount; ++i) {
                Cell cell;
                BObject object = (BObject)cursor.cell(cols[i]).as(BObject.class);
                String s = object.toString(colCx[i]);
                row.cells[i] = cell = new Cell(s);
                maxWidth[i] = Math.max(maxWidth[i], cell.width);
            }
            rows.add(row);
        }
        PrintWriter out = new PrintWriter(new OutputStreamWriter(op.getOutputStream(), "UTF-8"));
        String spacer = " " + this.getColumnSeparator() + " ";
        for (int i = 0; i < rows.size(); ++i) {
            Row row = (Row)rows.get(i);
            row.print(out, maxWidth, i == 0, spacer);
        }
        out.flush();
    }

    static String spaces(int n) {
        return TextUtil.getSpaces((int)n);
    }

    static class Cell {
        String[] lines;
        int width;

        Cell(String s) {
            this.lines = TextUtil.split((String)s, (char)'\n');
            for (int i = 0; i < this.lines.length; ++i) {
                this.width = Math.max(this.width, this.lines[i].length());
            }
        }
    }

    static class Row {
        Cell[] cells;

        Row(int colCount) {
            this.cells = new Cell[colCount];
        }

        public void print(PrintWriter out, int[] maxWidth, boolean header, String spacer) {
            int i;
            int colCount = maxWidth.length;
            int lineCount = 0;
            for (i = 0; i < colCount; ++i) {
                lineCount = Math.max(this.cells[i].lines.length, lineCount);
            }
            for (int line = 0; line < lineCount; ++line) {
                for (int i2 = 0; i2 < colCount; ++i2) {
                    Cell cell = this.cells[i2];
                    if (line >= cell.lines.length) {
                        out.print(BITableToText.spaces(maxWidth[i2]));
                    } else {
                        String s = cell.lines[line];
                        out.print(s);
                        out.print(BITableToText.spaces(maxWidth[i2] - s.length()));
                    }
                    if (i2 >= colCount - 1) continue;
                    out.print(spacer);
                }
                out.println();
            }
            if (header) {
                for (i = 0; i < colCount; ++i) {
                    for (int x = 0; x < maxWidth[i]; ++x) {
                        out.print('-');
                    }
                    if (i >= colCount - 1) continue;
                    out.print(spacer);
                }
                out.println();
            }
        }
    }
}

