/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.file.exporters;

import java.io.PrintWriter;
import java.io.Writer;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.file.BExporter;
import javax.baja.file.ExportOp;
import javax.baja.file.types.text.BHtmlFile;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.xml.XWriter;

public class BITableToHtml
extends BExporter {
    public static final Type TYPE = Sys.loadType(BITableToHtml.class);

    public Type getType() {
        return TYPE;
    }

    public TypeInfo getFileType() {
        return BHtmlFile.TYPE.getTypeInfo();
    }

    public String getFileExtension() {
        return "html";
    }

    public void export(ExportOp op) throws Exception {
        this.export((BITable)op.get(), op);
    }

    public String getTitle(ExportOp op) {
        return "Table";
    }

    public void export(BITable<?> table, ExportOp op) throws Exception {
        PrintWriter out = new PrintWriter(op.getOutputStream());
        out.println("<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Strict//EN' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd'>");
        out.println("<html>");
        out.println("<head>");
        out.println("<title>" + this.getTitle(op) + "</title>");
        out.println("<style type='text/css'>");
        out.println("body {font: 10pt verdana;}");
        out.println("table {border: 0px; border-spacing: 0px;}");
        out.println("th {white-space: nowrap; text-align:left; padding: 1px 8px; background: #BFBFBF;}");
        out.println("td {white-space: nowrap; padding: 1px 8px; margin: 0px;}");
        out.println(".odd {background:#F7F7F7}");
        out.println(".fill {width:100%;}");
        out.println("</style>");
        out.println("</head>");
        out.println("<body>");
        out.println("<table class='fill'>");
        out.println("<tr>");
        Column[] cols = table.getColumns().list();
        int colCount = cols.length;
        for (int i = 0; i < colCount; ++i) {
            BFacets colFacets = cols[i].getFacets();
            BUnit units = null;
            BObject sName = null;
            if (null != colFacets) {
                units = (BUnit)colFacets.get("units");
                sName = colFacets.get("SERIES_NAME");
            }
            String name = cols[i].getDisplayName((Context)op);
            if (null != sName) {
                name = sName.toString((Context)op);
            }
            if (null != units && units != BUnit.NULL) {
                name = name + " (" + units.toString((Context)op) + ")";
            }
            out.print("<th>");
            XWriter.safe((Writer)out, (String)name, (boolean)true);
            out.println("</th>");
        }
        out.println("<th class='fill'></td>");
        out.println("</tr>");
        Context[] columnContext = new Context[colCount];
        for (int i = 0; i < columnContext.length; ++i) {
            columnContext[i] = new BasicContext((Context)op, cols[i].getFacets());
        }
        TableCursor cursor = table.cursor();
        int row = 0;
        while (cursor.next()) {
            if (row++ % 2 == 0) {
                out.println("<tr class='odd'>");
            } else {
                out.println("<tr class='even'>");
            }
            for (int i = 0; i < colCount; ++i) {
                BObject cell = (BObject)cursor.cell(cols[i]).as(BObject.class);
                String text = cell.toString(columnContext[i]);
                out.print("<td>");
                XWriter.safe((Writer)out, (String)text, (boolean)true);
                out.println("</td>");
            }
            out.println("<td class='fill'></td>");
            out.println("</tr>");
        }
        out.println("</table>");
        out.println("</body>");
        out.println("</html>");
        out.flush();
    }
}

