/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecMigrator;

import com.tridium.util.CustomThemeModuleManager;
import com.tridiumx.entsec.orionTools.MappingSupport;
import com.tridiumx.entsec.roles.BEntsecRole;
import com.tridiumx.entsecMigrator.util.EntsecMigratorRole;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.baja.io.ValueDocDecoder;
import javax.baja.migration.BIBogElementConverter;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.role.BRoleService;
import javax.baja.security.BPermissionsMap;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.BServiceContainer;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.web.BWebProfileConfig;
import javax.baja.xml.XElem;

@NiagaraType
public class BEntsecRolesConverter
extends BComponent
implements BIBogElementConverter {
    public static final Type TYPE = Sys.loadType(BEntsecRolesConverter.class);
    private static final List<String> convertTypes = new ArrayList<String>();
    List<EntsecMigratorRole> rolesList = new ArrayList<EntsecMigratorRole>();
    private static final String ENTSEC_ROLE_COMPONENT = "entsecRoles";
    private static final String ENTSEC_MIGRATOR_ROLE_COMPONENT = "entsecMigratorRoles";
    private static final String ENTSEC_USER_CONFIG = "entsec_EntsecUserConfig";
    private static final String WEB_PROFILE_CONFIG = "web_WebProfileConfig";
    private static Lexicon lex;
    private static final String AX_ROLES_DELIMITER = ";";
    private static final String AX_N4_DELIMITER = ",";
    private HashMap<String, String> assignedRolesUserMap = new HashMap();
    private static final String ADMIN_USER = "admin";

    public Type getType() {
        return TYPE;
    }

    public List<String> getConvertTypes() {
        return convertTypes;
    }

    public XElem convertXElem(XElem entsecRolesElem, String typeSpecName, Version sourceVersion, XElem root) throws IOException {
        entsecRolesElem.setAttr("n", ENTSEC_MIGRATOR_ROLE_COMPONENT);
        entsecRolesElem.setAttr("t", "esm:EntsecMigratorRoles");
        entsecRolesElem.addAttr("m", "esm=entsecMigrator");
        EntsecMigratorRole role = null;
        for (XElem roles : entsecRolesElem.elems()) {
            String entsecRoleName = roles.get("n");
            String roleType = roles.get("t");
            for (XElem permission : roles.elems()) {
                if (!permission.get("n").equalsIgnoreCase("permissionsMap")) continue;
                String value = permission.get("v");
                role = new EntsecMigratorRole(entsecRoleName, roleType, value);
                this.rolesList.add(role);
            }
        }
        this.parseRootElemForUserRolesMap(root);
        return entsecRolesElem;
    }

    public void convertComplex(BComponent root, ValueDocDecoder.ITypeResolver resolver, BComplex toConvert, Version sourceVersion) throws Exception {
        log.info(lex.getText("rolesMigratorMsg"));
        BRoleService[] newRoleService = null;
        BUserService[] newUserService = null;
        BServiceContainer[] services = (BServiceContainer[])root.getChildren(BServiceContainer.class);
        if (services != null && services.length > 0) {
            newRoleService = (BRoleService[])services[0].getChildren(BRoleService.class);
            newUserService = (BUserService[])services[0].getChildren(BUserService.class);
        }
        this.removeEntsecRolesWithUsersNames((BRoleService)newRoleService[0]);
        this.createEntsecRolesInRoleService((BRoleService)newRoleService[0]);
        this.removeRolesComponent((BUserService)newUserService[0]);
        this.assignRolesToEntsecUser(newUserService[0]);
        BUser user = newUserService[0].getUser(ADMIN_USER);
        if (user != null) {
            this.makeThemeAsLucidForUsers(user);
        }
    }

    public void removeEntsecRolesWithUsersNames(BRoleService roleService) {
        Set<String> hashUserKeys = this.assignedRolesUserMap.keySet();
        for (String entsecUser : hashUserKeys) {
            if (roleService.get(entsecUser) == null) continue;
            roleService.remove(entsecUser);
        }
        if (roleService.get("defaultPrototype") != null) {
            roleService.remove("defaultPrototype");
        }
    }

    public void createEntsecRolesInRoleService(BRoleService roleService) throws IOException {
        for (int i = 0; i < this.rolesList.size(); ++i) {
            EntsecMigratorRole role = this.rolesList.get(i);
            if (role.getRoleName().equalsIgnoreCase(ADMIN_USER)) continue;
            BEntsecRole newRole = new BEntsecRole();
            BPermissionsMap map = newRole.getPermissions();
            map = (BPermissionsMap)map.decodeFromString(role.getPermissionMapValue());
            newRole.setPermissions(map);
            roleService.add(role.getRoleName(), (BValue)newRole);
        }
    }

    public void removeRolesComponent(BUserService userService) {
        BComponent entsecMigratorRolesComp;
        BComponent entsecRolesComp = (BComponent)userService.get(ENTSEC_ROLE_COMPONENT);
        if (entsecRolesComp != null) {
            userService.remove((BComplex)entsecRolesComp);
        }
        if ((entsecMigratorRolesComp = (BComponent)userService.get(ENTSEC_MIGRATOR_ROLE_COMPONENT)) != null) {
            userService.remove((BComplex)entsecMigratorRolesComp);
        }
    }

    public void assignRolesToEntsecUser(BUserService userService) {
        Set<String> hashUserKeys = this.assignedRolesUserMap.keySet();
        for (String entsecUser : hashUserKeys) {
            BUser user = userService.getUser(entsecUser);
            String roles = this.assignedRolesUserMap.get(entsecUser);
            if (roles != null) {
                roles = roles.replaceAll(AX_ROLES_DELIMITER, AX_N4_DELIMITER);
                roles = roles.replaceAll("Admin", ADMIN_USER);
                user.setRoles(roles);
            }
            this.makeThemeAsLucidForUsers(user);
        }
    }

    public void makeThemeAsLucidForUsers(BUser user) {
        BWebProfileConfig webProfile = (BWebProfileConfig)user.getMixIn(BWebProfileConfig.TYPE);
        if (webProfile == null) {
            webProfile = new BWebProfileConfig();
        }
        BDynamicEnum themeEnum = CustomThemeModuleManager.getDefaultThemeEnum();
        BEnumRange themeRange = themeEnum.getRange();
        if (webProfile.get("selectedHxTheme") != null) {
            webProfile.remove("selectedHxTheme");
        }
        webProfile.add("selectedHxTheme", (BValue)BDynamicEnum.make((int)0, (BEnumRange)themeRange));
        user.set(MappingSupport.getMixInName((Type)BWebProfileConfig.TYPE), (BValue)webProfile);
    }

    public void parseRootElemForUserRolesMap(XElem root) {
        XElem rootStationXelem = root.elem("p");
        XElem serviceContainerXElem = null;
        XElem userServiceXElem = null;
        for (XElem xmlElem : rootStationXelem.elems()) {
            if (!xmlElem.get("n").equalsIgnoreCase("services")) continue;
            serviceContainerXElem = xmlElem;
            break;
        }
        for (XElem xmlElem : serviceContainerXElem.elems()) {
            if (!xmlElem.get("n").equalsIgnoreCase("userservice")) continue;
            userServiceXElem = xmlElem;
            break;
        }
        this.iterateUserServiceElements(userServiceXElem);
    }

    public void iterateUserServiceElements(XElem userServiceXElem) {
        String rolesMap = "";
        boolean hxProfileUser = false;
        for (XElem userXElem : userServiceXElem.elems()) {
            String userName = userXElem.get("n");
            for (XElem userSubElem : userXElem.elems()) {
                if (userSubElem.get("n").equalsIgnoreCase(ENTSEC_USER_CONFIG)) {
                    rolesMap = this.getRolesFromEntsecUserConfig(userSubElem);
                }
                if (!userSubElem.get("n").equalsIgnoreCase(WEB_PROFILE_CONFIG)) continue;
                hxProfileUser = this.isUserAccessHxProfile(userSubElem);
            }
            if (!hxProfileUser || rolesMap.length() <= 0) continue;
            this.assignedRolesUserMap.put(SlotPath.unescape((String)userName), rolesMap);
            hxProfileUser = false;
        }
    }

    public String getRolesFromEntsecUserConfig(XElem userSubElem) {
        String rolesMap = "";
        XElem roleElem = userSubElem.elem("p");
        if (roleElem != null && roleElem.attrIndex("v") != -1) {
            rolesMap = roleElem.get("v");
        }
        return rolesMap;
    }

    public boolean isUserAccessHxProfile(XElem userSubElem) {
        boolean hxProfileUser = false;
        XElem webElem = userSubElem.elem("p");
        if (webElem != null && webElem.get("v").indexOf("entsecHx") > -1) {
            hxProfileUser = true;
        }
        return hxProfileUser;
    }

    static {
        convertTypes.add("entsec:EntsecRoles");
        convertTypes.add("entsecMigrator:EntsecMigratorRoles");
        lex = Lexicon.make((String)"entsecMigrator");
    }
}

