/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.messages;

import com.tridium.aapup.messages.PupReceivedMessage;
import com.tridium.aapup.messages.PupResponse;

public class PupReportExceptionResponse
extends PupResponse {
    private static byte[] b = new byte[]{2, 3, 0, 29, -123, 39, 0, 4, -128, 5, -2, 90, 111, 110, 101, 32, 84, 101, 109, 112, 32, 84, 111, 111, 32, 72, 105, 103, 104, 104};
    int exceptionSource;
    int transactionNumber;
    int exceptionClass;
    int exceptionCauseCode;
    int exceptionChannel;
    String exceptionText;

    public PupReportExceptionResponse(PupReceivedMessage msg) {
        super(msg);
        this.exceptionSource = this.getIn().getCommand() == 15 ? this.getIn().readInt() : this.getIn().getUnitNumber();
        this.transactionNumber = this.getIn().readInt();
        if (this.transactionNumber != 0) {
            this.exceptionClass = this.getIn().read();
            this.exceptionCauseCode = this.getIn().read();
            this.exceptionChannel = this.getIn().readInt();
            this.exceptionText = this.getIn().readText();
        } else {
            this.exceptionChannel = 0;
            this.exceptionCauseCode = 0;
            this.exceptionClass = 0;
            this.exceptionText = "";
        }
    }

    public PupReportExceptionResponse(boolean test) {
        super(new PupReceivedMessage(b));
        this.transactionNumber = this.getIn().readInt();
        if (this.transactionNumber != 0) {
            this.exceptionClass = this.getIn().read();
            this.exceptionCauseCode = this.getIn().read();
            this.exceptionChannel = this.getIn().readInt();
            this.exceptionText = this.getIn().readText();
        } else {
            this.exceptionChannel = 0;
            this.exceptionCauseCode = 0;
            this.exceptionClass = 0;
            this.exceptionText = "";
        }
    }

    public int getExceptionSource() {
        return this.exceptionSource;
    }

    public int getTransactionNumber() {
        return this.transactionNumber;
    }

    public int getExceptionClass() {
        return this.exceptionClass;
    }

    public int getExceptionCauseCode() {
        return this.exceptionCauseCode;
    }

    public int getExceptionChannel() {
        return this.exceptionChannel;
    }

    public String getExceptionText() {
        return this.exceptionText;
    }

    public String getCause() {
        if (this.exceptionCauseCode < 128) {
            return "pre-version 7 cause:" + this.exceptionCauseCode;
        }
        int causeIndex = (this.exceptionCauseCode & 0x7E) >>> 1;
        return (String)causeTable.get(causeIndex);
    }

    public boolean isReturnToNormal() {
        return (this.exceptionCauseCode & 1) == 1;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("PupReportExceptionResponse:() from " + this.exceptionSource + "\n").append("  transaction number  :" + this.transactionNumber);
        if (this.transactionNumber != 0) {
            sb.append("  exception class     :" + this.exceptionClass).append("  exception cause code:" + this.exceptionCauseCode + "\n").append("    ").append(this.getCause()).append("  exception channel   :" + this.exceptionChannel + "\n").append("  exception text      :" + this.exceptionText);
        }
        return sb.toString();
    }
}

