/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.messages;

import com.tridium.aapup.AaPupConst;
import com.tridium.aapup.messages.PupErrorResponse;
import com.tridium.aapup.messages.PupMessage;
import com.tridium.aapup.messages.PupNumericDataResponse;
import com.tridium.aapup.messages.PupOutputStream;
import com.tridium.aapup.messages.PupReceivedMessage;
import com.tridium.aapup.messages.PupResponse;
import com.tridium.aapup.messages.PupTextDataResponse;

public class PupReadAttributeMessage
extends PupMessage
implements AaPupConst {
    private int channel;
    private String attribute;
    private boolean fetchNextFlag = false;
    private boolean fetchPreviousFlag = false;

    public PupReadAttributeMessage(int targetUnitNumber, int channel, String attribute) {
        super(targetUnitNumber);
        this.channel = channel;
        this.attribute = attribute;
    }

    public PupReadAttributeMessage(int targetUnitNumber, int channel, String attribute, boolean setMsb) {
        super(targetUnitNumber, setMsb);
        this.channel = channel;
        this.attribute = attribute;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute.substring(0, 2);
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int channel) {
        this.channel = channel;
    }

    public boolean getFetchNextFlag() {
        return this.fetchNextFlag;
    }

    public void setFetchNextFlag(boolean flag) {
        this.fetchNextFlag = flag;
    }

    public boolean getFetchPreviousFlag() {
        return this.fetchPreviousFlag;
    }

    public void setFetchPreviousFlag(boolean flag) {
        this.fetchPreviousFlag = flag;
    }

    @Override
    void writeBytes(PupOutputStream out) {
        out.write(9);
        out.write(1);
        out.writeInt(this.channel);
        out.writeAttribute(this.attribute, this.fetchNextFlag, this.fetchPreviousFlag);
    }

    @Override
    PupResponse getResponse(PupReceivedMessage rcvdMsg) {
        if (!this.getResponseExpected()) {
            return null;
        }
        if (rcvdMsg.getData()[4] == -128) {
            return new PupErrorResponse(rcvdMsg);
        }
        if (rcvdMsg.getData()[4] == -126) {
            return new PupNumericDataResponse(rcvdMsg);
        }
        if (rcvdMsg.getData()[4] == -125) {
            return new PupTextDataResponse(rcvdMsg);
        }
        return new PupErrorResponse(rcvdMsg);
    }

    @Override
    public String toString() {
        return "PupReadAttributeMessage::unit:" + this.unitNumber + " time:" + this.channel;
    }
}

