/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.messages;

import com.tridium.aapup.AaPupConst;
import com.tridium.aapup.messages.PupReceivedMessage;
import com.tridium.aapup.messages.PupResponse;
import javax.baja.alarm.BAlarmRecord;

public class PupAckResponse
extends PupResponse
implements AaPupConst {
    int numberOfRegions = this.getIn().read();
    int statusFlags = this.getIn().read();
    boolean timeSyncRequested;
    boolean tokenPassRequested;
    boolean version8Supported;
    BAlarmRecord alarmRecord;

    public PupAckResponse(PupReceivedMessage msg) {
        super(msg);
        this.decodeStatusFlags(this.statusFlags);
        this.alarmRecord = null;
    }

    public int getNumberOfRegions() {
        return this.numberOfRegions;
    }

    public int getStatusFlags() {
        return this.statusFlags;
    }

    public boolean isTimeSyncRequested() {
        return this.timeSyncRequested;
    }

    public boolean isTokenPassRequested() {
        return this.tokenPassRequested;
    }

    public boolean isVersion8Supported() {
        return this.version8Supported;
    }

    private void decodeStatusFlags(int status) {
        this.timeSyncRequested = (status & 2) == 2;
        this.tokenPassRequested = (status & 4) == 4;
        this.version8Supported = (status & 8) == 8;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("PupAckResponse:() from " + this.getIn().getUnitNumber() + "\n").append("  numberOfRegions:" + this.numberOfRegions + "\n").append("  status byte    :" + this.statusFlags + "\n").append(this.timeSyncRequested ? "      Time sync requested" : "      Time sync not requested").append(this.tokenPassRequested ? "      Token pass requested" : "      Token pass not requested").append(this.version8Supported ? "      Version 8 Supported" : "      Version 8 Not Supported");
        return sb.toString();
    }

    public void setAlarmRecord(BAlarmRecord record) {
        this.alarmRecord = record;
    }

    public BAlarmRecord getAlarmRecord() {
        return this.alarmRecord;
    }
}

