/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.job;

import com.tridium.aapup.AaPupConst;
import com.tridium.aapup.BPupDevice;
import com.tridium.aapup.BPupNetwork;
import com.tridium.aapup.datatypes.BPupRegionRecord;
import com.tridium.aapup.messages.PupAckResponse;
import com.tridium.aapup.messages.PupHelloMessage;
import com.tridium.aapup.messages.PupLookupNamedRegionMessage;
import com.tridium.aapup.messages.PupRegionNameResponse;
import com.tridium.aapup.messages.PupResponse;
import javax.baja.job.BSimpleJob;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

public class BPupLearnRegionsJob
extends BSimpleJob
implements AaPupConst {
    public static final Property learnedRegions = BPupLearnRegionsJob.newProperty((int)0, (BValue)new BFolder(), null);
    public static final Topic regionLearned = BPupLearnRegionsJob.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BPupLearnRegionsJob.class);
    private BPupNetwork network;
    private BPupDevice device;
    private int unitNumber;
    private int controllerType;
    private int numRegions;
    private int sn;
    private double version;

    public BFolder getLearnedRegions() {
        return (BFolder)this.get(learnedRegions);
    }

    public void setLearnedRegions(BFolder v) {
        this.set(learnedRegions, (BValue)v, null);
    }

    public void fireRegionLearned(BValue event) {
        this.fire(regionLearned, event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BPupLearnRegionsJob() {
    }

    public BPupLearnRegionsJob(BPupDevice device, int unitNumber) {
        this.device = device;
        this.network = device.pupNetwork();
        this.unitNumber = unitNumber;
    }

    public void run(Context cx) throws Exception {
        boolean problem = true;
        if (this.network == null) {
            throw new IllegalStateException("Must submit thru PupNetwork.submitDeviceDiscoveryJob()");
        }
        if (!this.isAlive()) {
            return;
        }
        this.logMessage("Scanning address " + this.unitNumber + "...");
        PupResponse rsp = (PupResponse)this.network.sendSync(new PupHelloMessage(this.unitNumber));
        if (rsp != null && rsp.getIn().verifyChecksum() && rsp instanceof PupAckResponse) {
            PupAckResponse ackRsp = (PupAckResponse)rsp;
            this.numRegions = ackRsp.getNumberOfRegions();
            problem = false;
        }
        if (problem) {
            this.failed(new Throwable("error reading number of regions"));
            return;
        }
        this.logMessage("device " + this.unitNumber + " has " + this.numRegions + " regions");
        this.progress(10);
        this.device.getRegions().removeAll();
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int progress = 0;
        String name = "";
        for (int i = 0; i < this.numRegions; ++i) {
            progress = 90 * i / this.numRegions + 10;
            this.progress(progress);
            problem = true;
            rsp = (PupResponse)this.network.sendSync(new PupLookupNamedRegionMessage(this.device.getSerialNumber() | 0x8000, i));
            if (rsp != null && rsp.getIn().verifyChecksum() && rsp instanceof PupRegionNameResponse) {
                PupRegionNameResponse nameRsp = (PupRegionNameResponse)rsp;
                problem = false;
                BPupRegionRecord rec = new BPupRegionRecord();
                rec.setUnitNumber(this.unitNumber);
                rec.setSerialNumber(this.sn);
                rec.setControllerType(this.controllerType);
                rec.setFirmwareVersion(this.version);
                rec.setRegionNumber(nameRsp.getRegionNumber());
                rec.setRegionType(nameRsp.getRegionType());
                name = nameRsp.getRegionName();
                rec.setRegionName(name);
                rec.setRegionSize(nameRsp.getRegionSize());
                rec.setRegionLock(nameRsp.isLocked());
                rec.setAvailableBufferSize(nameRsp.getRegionAvailableBufferSize());
                this.getLearnedRegions().add(null, (BValue)rec);
                this.fireRegionLearned((BValue)rec);
            }
            if (problem) {
                this.failed(new Throwable("error reading region name"));
                return;
            }
            this.logMessage("region:" + i + " device:" + this.unitNumber + " firmware:" + this.version + " name:" + name);
        }
        this.progress(100);
    }

    private void logMessage(String message) {
        this.log().message(message);
        if (this.network != null) {
            int severity = this.network.getLog().getSeverity();
            this.network.getLog().setSeverity(1);
            this.network.getLog().message("Learn Regions Job:" + message);
            this.network.getLog().setSeverity(severity);
        }
    }
}

