/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.job;

import com.tridium.aapup.AaPupConst;
import com.tridium.aapup.BPupNetwork;
import com.tridium.aapup.datatypes.BPupDeviceDiscoveryConfig;
import com.tridium.aapup.enums.BPupPeerTypeEnum;
import com.tridium.aapup.job.BPupDiscoveryDevice;
import com.tridium.aapup.messages.PupAckResponse;
import com.tridium.aapup.messages.PupErrorResponse;
import com.tridium.aapup.messages.PupHelloMessage;
import com.tridium.aapup.messages.PupNumericDataResponse;
import com.tridium.aapup.messages.PupReadAttributeMessage;
import com.tridium.aapup.messages.PupResponse;
import javax.baja.job.BSimpleJob;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

public class BPupDiscoverDevicesJob
extends BSimpleJob
implements AaPupConst {
    public static final Property learnedDevices = BPupDiscoverDevicesJob.newProperty((int)0, (BValue)new BFolder(), null);
    public static final Topic deviceLearned = BPupDiscoverDevicesJob.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BPupDiscoverDevicesJob.class);
    private BPupNetwork network;
    private int startAddress;
    private int stopAddress;
    private BPupPeerTypeEnum peerType;
    private int controllerType;
    private int manufacturer;
    private boolean isVersion8 = false;
    boolean useSerialNumber = false;

    public BFolder getLearnedDevices() {
        return (BFolder)this.get(learnedDevices);
    }

    public void setLearnedDevices(BFolder v) {
        this.set(learnedDevices, (BValue)v, null);
    }

    public void fireDeviceLearned(BValue event) {
        this.fire(deviceLearned, event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BPupDiscoverDevicesJob() {
    }

    public BPupDiscoverDevicesJob(BPupNetwork net, BPupDeviceDiscoveryConfig params) {
        this.network = net;
        this.startAddress = params.getStartAddress();
        this.stopAddress = params.getStopAddress();
        this.useSerialNumber = params.getSearchBy();
    }

    public void run(Context cx) throws Exception {
        if (this.network == null) {
            throw new IllegalStateException("Must submit thru PupNetwork.submitDeviceDiscoveryJob()");
        }
        if (this.network.isFatalFault()) {
            throw new IllegalStateException(this.network.getFaultCause());
        }
        int retryCount = 0;
        BRelTime timeout = BRelTime.make((long)100L);
        if (this.startAddress > this.stopAddress) {
            return;
        }
        if (this.useSerialNumber) {
            this.logMessage("Beginning s/n scan of serial numbers " + this.startAddress + " thru " + this.stopAddress);
        } else {
            this.logMessage("Beginning unit number scan of unit numbers " + this.startAddress + " thru " + this.stopAddress);
        }
        for (int i = this.startAddress; i < this.stopAddress + 1; ++i) {
            if (!this.isAlive()) {
                this.logMessage("discovery ended at " + (this.useSerialNumber ? "s/n " : "unit number ") + i);
                break;
            }
            if (i % 1000 == 0) {
                this.logMessage("Scanning " + i + " and up...");
            }
            int address = this.useSerialNumber ? i | 0x8000 : i;
            this.peerType = BPupPeerTypeEnum.unknown;
            this.controllerType = 0;
            PupAckResponse ackRsp = (PupAckResponse)this.network.sendSync(new PupHelloMessage(address), timeout, retryCount);
            if (ackRsp != null) {
                if (ackRsp.getIn().verifyChecksum()) {
                    PupNumericDataResponse dataRsp;
                    this.logMessage("Found PUP device at " + (this.useSerialNumber ? "s/n " : "unit ") + i);
                    this.isVersion8 = ackRsp.isVersion8Supported();
                    int unit = ackRsp.getIn().getUnitNumber();
                    this.manufacturer = -1;
                    PupResponse rsp = (PupResponse)this.network.sendSync(new PupReadAttributeMessage(unit, 65280, "CM"), timeout, retryCount);
                    if (rsp != null && rsp.getIn().verifyChecksum() && rsp instanceof PupNumericDataResponse) {
                        dataRsp = (PupNumericDataResponse)rsp;
                        this.manufacturer = dataRsp.getDouble().getInt();
                    }
                    this.controllerType = 0;
                    rsp = (PupResponse)this.network.sendSync(new PupReadAttributeMessage(unit, 65280, "CT"), timeout, retryCount);
                    if (rsp != null && rsp.getIn().verifyChecksum() && rsp instanceof PupNumericDataResponse) {
                        dataRsp = (PupNumericDataResponse)rsp;
                        this.controllerType = dataRsp.getDouble().getInt();
                    }
                    this.peerType = BPupPeerTypeEnum.unknown;
                    rsp = (PupResponse)this.network.sendSync(new PupReadAttributeMessage(unit, 65280, "TP"), timeout, retryCount);
                    if (rsp != null && rsp.getIn().verifyChecksum()) {
                        PupErrorResponse errRsp;
                        if (rsp instanceof PupNumericDataResponse) {
                            dataRsp = (PupNumericDataResponse)rsp;
                            this.peerType = BPupPeerTypeEnum.make(dataRsp.getDouble().getInt());
                        } else if (rsp instanceof PupErrorResponse && (errRsp = (PupErrorResponse)rsp).getErrorNumber() == 65532) {
                            this.peerType = BPupPeerTypeEnum.slave;
                        }
                    }
                    String description = this.network.getControllerDescription(this.manufacturer, this.controllerType);
                    BPupDiscoveryDevice newDevice = new BPupDiscoveryDevice(unit, this.manufacturer, this.controllerType, description, this.peerType, this.isVersion8);
                    this.getLearnedDevices().add(null, (BValue)newDevice);
                    this.fireDeviceLearned((BValue)newDevice);
                } else {
                    this.logMessage("bad checksum at " + (this.useSerialNumber ? "s/n " : "unit ") + i + "...");
                }
            }
            int progress = (int)((double)(i - this.startAddress + 1) * 100.0 / (double)(this.stopAddress - this.startAddress + 1));
            this.progress(progress);
        }
    }

    private void logMessage(String message) {
        this.log().message(message);
        if (this.network != null) {
            int severity = this.network.getLog().getSeverity();
            this.network.getLog().setSeverity(1);
            this.network.getLog().message("Discover Devices Job:" + message);
            this.network.getLog().setSeverity(severity);
        }
    }
}

