/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.datatypes;

import com.tridium.aapup.BPupNetwork;
import com.tridium.aapup.enums.BPupPeerTypeEnum;
import javax.baja.data.BIDataValue;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BPupTokenPassConfig
extends BComponent {
    public static final Property tokenPassingEnabled = BPupTokenPassConfig.newProperty((int)0, (boolean)false, (BFacets)BFacets.makeBoolean((String)"enabled", (String)"disabled"));
    public static final Property passToDownDevices = BPupTokenPassConfig.newProperty((int)0, (boolean)false, null);
    public static final Property peerType = BPupTokenPassConfig.newProperty((int)1, (BValue)BPupPeerTypeEnum.fullAdminRoundRobin, null);
    public static final Property tokenRecovery = BPupTokenPassConfig.newProperty((int)0, (boolean)false, (BFacets)BFacets.makeBoolean((String)"enabled", (String)"disabled"));
    public static final Property tokenRecoveryType = BPupTokenPassConfig.newProperty((int)0, (boolean)true, (BFacets)BFacets.makeBoolean((String)"No Token Passes Detected", (String)"No Bus Activity Detected"));
    public static final Property tokenRecoveryTimeout = BPupTokenPassConfig.newProperty((int)0, (BValue)BRelTime.make((long)1000L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)500L), (String)"max", (BIDataValue)BRelTime.make((long)Long.MAX_VALUE)));
    public static final Property tokenRecoveryCount = BPupTokenPassConfig.newProperty((int)3, (int)0, null);
    public static final Property passTokenOnTransactionCount = BPupTokenPassConfig.newProperty((int)0, (boolean)true, (BFacets)BFacets.makeBoolean((String)"enabled", (String)"disabled"));
    public static final Property transactionsPerToken = BPupTokenPassConfig.newProperty((int)0, (int)10, null);
    public static final Property passTokenOnTimeout = BPupTokenPassConfig.newProperty((int)0, (boolean)false, (BFacets)BFacets.makeBoolean((String)"enabled", (String)"disabled"));
    public static final Property timePerToken = BPupTokenPassConfig.newProperty((int)0, (BValue)BRelTime.make((long)1000L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)200L), (String)"max", (BIDataValue)BRelTime.make((long)Long.MAX_VALUE)));
    public static final Property tokenSnoop = BPupTokenPassConfig.newProperty((int)3, (String)"", (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE, (String)"fieldWidth", (BIDataValue)BInteger.make((int)64)));
    public static final Property logTokenSnoopOnTokenRecovery = BPupTokenPassConfig.newProperty((int)0, (boolean)false, null);
    public static final Action resetTokenRecoveryCount = BPupTokenPassConfig.newAction((int)0, null);
    public static final Action logTokenSnoop = BPupTokenPassConfig.newAction((int)0, null);
    public static final Action clearTokenSnoop = BPupTokenPassConfig.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BPupTokenPassConfig.class);
    private static int TOKEN_SNOOP_SIZE = 8;
    private String[] snoops;

    public boolean getTokenPassingEnabled() {
        return this.getBoolean(tokenPassingEnabled);
    }

    public void setTokenPassingEnabled(boolean v) {
        this.setBoolean(tokenPassingEnabled, v, null);
    }

    public boolean getPassToDownDevices() {
        return this.getBoolean(passToDownDevices);
    }

    public void setPassToDownDevices(boolean v) {
        this.setBoolean(passToDownDevices, v, null);
    }

    public BPupPeerTypeEnum getPeerType() {
        return (BPupPeerTypeEnum)this.get(peerType);
    }

    public void setPeerType(BPupPeerTypeEnum v) {
        this.set(peerType, (BValue)v, null);
    }

    public boolean getTokenRecovery() {
        return this.getBoolean(tokenRecovery);
    }

    public void setTokenRecovery(boolean v) {
        this.setBoolean(tokenRecovery, v, null);
    }

    public boolean getTokenRecoveryType() {
        return this.getBoolean(tokenRecoveryType);
    }

    public void setTokenRecoveryType(boolean v) {
        this.setBoolean(tokenRecoveryType, v, null);
    }

    public BRelTime getTokenRecoveryTimeout() {
        return (BRelTime)this.get(tokenRecoveryTimeout);
    }

    public void setTokenRecoveryTimeout(BRelTime v) {
        this.set(tokenRecoveryTimeout, (BValue)v, null);
    }

    public int getTokenRecoveryCount() {
        return this.getInt(tokenRecoveryCount);
    }

    public void setTokenRecoveryCount(int v) {
        this.setInt(tokenRecoveryCount, v, null);
    }

    public boolean getPassTokenOnTransactionCount() {
        return this.getBoolean(passTokenOnTransactionCount);
    }

    public void setPassTokenOnTransactionCount(boolean v) {
        this.setBoolean(passTokenOnTransactionCount, v, null);
    }

    public int getTransactionsPerToken() {
        return this.getInt(transactionsPerToken);
    }

    public void setTransactionsPerToken(int v) {
        this.setInt(transactionsPerToken, v, null);
    }

    public boolean getPassTokenOnTimeout() {
        return this.getBoolean(passTokenOnTimeout);
    }

    public void setPassTokenOnTimeout(boolean v) {
        this.setBoolean(passTokenOnTimeout, v, null);
    }

    public BRelTime getTimePerToken() {
        return (BRelTime)this.get(timePerToken);
    }

    public void setTimePerToken(BRelTime v) {
        this.set(timePerToken, (BValue)v, null);
    }

    public String getTokenSnoop() {
        return this.getString(tokenSnoop);
    }

    public void setTokenSnoop(String v) {
        this.setString(tokenSnoop, v, null);
    }

    public boolean getLogTokenSnoopOnTokenRecovery() {
        return this.getBoolean(logTokenSnoopOnTokenRecovery);
    }

    public void setLogTokenSnoopOnTokenRecovery(boolean v) {
        this.setBoolean(logTokenSnoopOnTokenRecovery, v, null);
    }

    public void resetTokenRecoveryCount() {
        this.invoke(resetTokenRecoveryCount, null, null);
    }

    public void logTokenSnoop() {
        this.invoke(logTokenSnoop, null, null);
    }

    public void clearTokenSnoop() {
        this.invoke(clearTokenSnoop, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.snoops = new String[TOKEN_SNOOP_SIZE];
        for (int i = 0; i < this.snoops.length; ++i) {
            this.snoops[i] = "";
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        BPupNetwork parent = (BPupNetwork)this.getParent();
        if (parent != null) {
            if (property == tokenPassingEnabled) {
                if (this.getTokenPassingEnabled()) {
                    if (this.getPassTokenOnTimeout()) {
                        if (this.getTokenPassingEnabled()) {
                            parent.initializeTokenTimer();
                        } else {
                            parent.cancelTokenTimer();
                        }
                    }
                } else {
                    parent.cancelTokenTimer();
                    parent.cancelTokenRecoveryTimer();
                }
            }
            if (property == passTokenOnTimeout) {
                if (this.getPassTokenOnTimeout()) {
                    parent.initializeTokenTimer();
                } else {
                    parent.cancelTokenTimer();
                }
            } else if (property == timePerToken) {
                parent.initializeTokenTimer();
            } else if (property == tokenRecovery || property == tokenRecoveryTimeout) {
                if (this.getTokenRecovery()) {
                    parent.initializeTokenRecoveryTimer();
                } else {
                    parent.cancelTokenRecoveryTimer();
                }
            }
        }
    }

    public void doResetTokenRecoveryCount() {
        this.setTokenRecoveryCount(0);
    }

    public void incrementTokenRecoveryCount() {
        this.setTokenRecoveryCount(this.getTokenRecoveryCount() + 1);
    }

    public void appendTokenSnoop(String txt) {
        this.snoops[0] = this.snoops[0] + txt;
        if (txt.endsWith("\n") || txt.endsWith("*recover*") || this.snoops[0].length() > 60) {
            System.arraycopy(this.snoops, 0, this.snoops, 1, this.snoops.length - 1);
            this.snoops[0] = "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = TOKEN_SNOOP_SIZE; i > 0; --i) {
            sb.append(this.snoops[i - 1]);
        }
        this.setTokenSnoop(sb.toString());
    }

    public void doLogTokenSnoop() {
        BPupNetwork parent = (BPupNetwork)this.getParent();
        if (parent != null) {
            parent.getPupLog().info("TokenSnoop:\n" + this.getTokenSnoop());
        }
    }

    public void doClearTokenSnoop() {
        for (int i = 0; i < TOKEN_SNOOP_SIZE; ++i) {
            this.snoops[i] = "";
        }
        this.setTokenSnoop("");
    }
}

