/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.addons.bacnet;

import com.tridiumemea.addons.bacnet.BBacnetAlarmClassReassigner;
import com.tridiumemea.addons.bacnet.IAlarmReassigner;
import com.tridiumemea.addons.bacnet.util.Log;
import com.tridiumemea.addons.bacnet.util.ParentLegal;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.IllegalChildException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="NCAlarmClass", type="int", defaultValue="0", flags=8), @NiagaraProperty(name="alarmClass", type="String", defaultValue="defaultAlarmClass", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"alarm:AlarmClassFE\"))")})})
public class BNCAlarmClassReassign
extends BComponent
implements IAlarmReassigner {
    public static final Property NCAlarmClass = BNCAlarmClassReassign.newProperty((int)8, (int)0, null);
    public static final Property alarmClass = BNCAlarmClassReassign.newProperty((int)0, (String)"defaultAlarmClass", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassFE")));
    public static final Type TYPE = Sys.loadType(BNCAlarmClassReassign.class);
    private static final Logger log = Log.child("NCAlarmClassReassign");
    private static final Object[] THIS_TYPE_NAME = new Object[]{TYPE.getTypeName()};

    public int getNCAlarmClass() {
        return this.getInt(NCAlarmClass);
    }

    public void setNCAlarmClass(int v) {
        this.setInt(NCAlarmClass, v, null);
    }

    public String getAlarmClass() {
        return this.getString(alarmClass);
    }

    public void setAlarmClass(String v) {
        this.setString(alarmClass, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    @Override
    public boolean routeAlarm(BAlarmRecord record) {
        block8: {
            BObject ncFacet = record.getAlarmFacet("NC");
            if (ncFacet instanceof BValue) {
                try {
                    int ncValue = Integer.parseInt(ncFacet.toString());
                    if (ncValue == this.getNCAlarmClass()) {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Match! NC" + ncValue + " routes to " + this.getNCAlarmClass());
                        }
                        this.getParentReassigner().submitToAlarmService(record, this.getAlarmClass());
                        return true;
                    }
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Not routing: " + this.getName() + " Alarm NC value " + ncValue + " != " + this.getNCAlarmClass());
                    }
                    break block8;
                }
                catch (NumberFormatException e) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Could not parse ncfield number \"" + ncFacet + '\"' + record.getUuid());
                    }
                    break block8;
                }
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Non BValue type \"" + ncFacet + "\" - check alarm data against UUID " + record.getUuid());
            }
        }
        return false;
    }

    public boolean isParentLegal(BComponent parent) {
        return ParentLegal.is((BComplex)this, (BComplex)parent, BBacnetAlarmClassReassigner.TYPE);
    }

    public boolean isChildLegal(BComponent child) {
        throw new IllegalChildException(TYPE.getModule().getModuleName(), "noChild", THIS_TYPE_NAME);
    }

    public BIcon getIcon() {
        return BIcon.std((String)"filter.png");
    }

    public BBacnetAlarmClassReassigner getParentReassigner() {
        return (BBacnetAlarmClassReassigner)this.getParent();
    }
}

