/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.addons.bacnet;

import com.tridiumemea.addons.bacnet.BCustomBacnetEventProcessor;
import com.tridiumemea.addons.bacnet.BNCAlarmClassReassign;
import com.tridiumemea.addons.bacnet.FilterUtil;
import com.tridiumemea.addons.bacnet.IAlarmReassigner;
import com.tridiumemea.addons.bacnet.RevisionUtil;
import com.tridiumemea.addons.bacnet.util.Log;
import com.tridiumemea.addons.bacnet.util.ParentLegal;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.alarm.BBacnetAlarmDeviceExt;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.point.BBacnetPointDeviceExt;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.IllegalChildException;
import javax.baja.sys.IllegalParentException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true", flags=4), @NiagaraProperty(name="fallbackAlarmClass", type="String", defaultValue="defaultAlarmClass", flags=8, facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"alarm:AlarmClassFE\"))")}), @NiagaraProperty(name="useBacnetAlarmPriority", type="boolean", defaultValue="false", flags=261), @NiagaraProperty(name="setAlarmHyperlink", type="boolean", defaultValue="false", flags=256), @NiagaraProperty(name="replaceSourcenameWithDisplayname", type="boolean", defaultValue="false", flags=256), @NiagaraProperty(name="filterAlarmsFromUnknownObjects", type="boolean", defaultValue="false", flags=256), @NiagaraProperty(name="numberDiscarded", type="int", defaultValue="0", flags=65603), @NiagaraProperty(name="filterAlarmsOnError", type="boolean", defaultValue="false", flags=260), @NiagaraProperty(name="disableStrictObjectIdCheck", type="boolean", defaultValue="false", flags=260)})
public class BBacnetAlarmClassReassigner
extends BComponent {
    public static final Property enabled = BBacnetAlarmClassReassigner.newProperty((int)4, (boolean)true, null);
    public static final Property fallbackAlarmClass = BBacnetAlarmClassReassigner.newProperty((int)8, (String)"defaultAlarmClass", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassFE")));
    public static final Property useBacnetAlarmPriority = BBacnetAlarmClassReassigner.newProperty((int)261, (boolean)false, null);
    public static final Property setAlarmHyperlink = BBacnetAlarmClassReassigner.newProperty((int)256, (boolean)false, null);
    public static final Property replaceSourcenameWithDisplayname = BBacnetAlarmClassReassigner.newProperty((int)256, (boolean)false, null);
    public static final Property filterAlarmsFromUnknownObjects = BBacnetAlarmClassReassigner.newProperty((int)256, (boolean)false, null);
    public static final Property numberDiscarded = BBacnetAlarmClassReassigner.newProperty((int)65603, (int)0, null);
    public static final Property filterAlarmsOnError = BBacnetAlarmClassReassigner.newProperty((int)260, (boolean)false, null);
    public static final Property disableStrictObjectIdCheck = BBacnetAlarmClassReassigner.newProperty((int)260, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BBacnetAlarmClassReassigner.class);
    protected String processorName;
    private BBacnetPointDeviceExt points;
    private BBacnetAlarmDeviceExt alarms;
    private static final Logger log = Log.log;
    private static final Object[] THIS_TYPE_NAME = new Object[]{TYPE.getTypeName()};

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public String getFallbackAlarmClass() {
        return this.getString(fallbackAlarmClass);
    }

    public void setFallbackAlarmClass(String v) {
        this.setString(fallbackAlarmClass, v, null);
    }

    public boolean getUseBacnetAlarmPriority() {
        return this.getBoolean(useBacnetAlarmPriority);
    }

    public void setUseBacnetAlarmPriority(boolean v) {
        this.setBoolean(useBacnetAlarmPriority, v, null);
    }

    public boolean getSetAlarmHyperlink() {
        return this.getBoolean(setAlarmHyperlink);
    }

    public void setSetAlarmHyperlink(boolean v) {
        this.setBoolean(setAlarmHyperlink, v, null);
    }

    public boolean getReplaceSourcenameWithDisplayname() {
        return this.getBoolean(replaceSourcenameWithDisplayname);
    }

    public void setReplaceSourcenameWithDisplayname(boolean v) {
        this.setBoolean(replaceSourcenameWithDisplayname, v, null);
    }

    public boolean getFilterAlarmsFromUnknownObjects() {
        return this.getBoolean(filterAlarmsFromUnknownObjects);
    }

    public void setFilterAlarmsFromUnknownObjects(boolean v) {
        this.setBoolean(filterAlarmsFromUnknownObjects, v, null);
    }

    public int getNumberDiscarded() {
        return this.getInt(numberDiscarded);
    }

    public void setNumberDiscarded(int v) {
        this.setInt(numberDiscarded, v, null);
    }

    public boolean getFilterAlarmsOnError() {
        return this.getBoolean(filterAlarmsOnError);
    }

    public void setFilterAlarmsOnError(boolean v) {
        this.setBoolean(filterAlarmsOnError, v, null);
    }

    public boolean getDisableStrictObjectIdCheck() {
        return this.getBoolean(disableStrictObjectIdCheck);
    }

    public void setDisableStrictObjectIdCheck(boolean v) {
        this.setBoolean(disableStrictObjectIdCheck, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    void routeAlarm(BAlarmRecord record) {
        IAlarmReassigner[] children;
        if (!this.isRunning()) {
            return;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this.getName() + " routeAlarm: " + record);
        }
        if (!this.getEnabled()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Router disabled, forwarding record to fallback alarm class: " + this.getFallbackAlarmClass());
            }
            this.submitToAlarmService(record, this.getFallbackAlarmClass());
            return;
        }
        if (this.getFilterAlarmsFromUnknownObjects() || this.getReplaceSourcenameWithDisplayname() || this.getSetAlarmHyperlink()) {
            this.makePreRouteRevisions(record);
        }
        boolean published = false;
        for (IAlarmReassigner child : children = (IAlarmReassigner[])this.getChildren(IAlarmReassigner.class)) {
            if (!child.routeAlarm(record)) continue;
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getName() + " routeAlarm succeeded : " + record);
            }
            published = true;
            break;
        }
        if (!published) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getName() + " routeAlarm failed : " + record);
            }
            this.submitToAlarmService(record, this.getFallbackAlarmClass());
        } else {
            this.makePostRouteRevisions(record);
        }
    }

    void submitToAlarmService(BAlarmRecord record, String alarmClass) {
        record.setAlarmClass(alarmClass);
        BAlarmService as = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        as.routeAlarm(record);
    }

    private void makePreRouteRevisions(BAlarmRecord record) {
        BBacnetObjectIdentifier boi = FilterUtil.resolveBacnetObjectId(record);
        try {
            if (this.getFilterAlarmsFromUnknownObjects() && FilterUtil.isAlarmSourceUnknown(this.points, boi, this.getFilterAlarmsOnError(), this.getDisableStrictObjectIdCheck())) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Discarding alarm as source object not found in station " + record);
                }
                this.setNumberDiscarded(this.getNumberDiscarded() + 1);
                return;
            }
            if ((this.getReplaceSourcenameWithDisplayname() || this.getSetAlarmHyperlink()) && boi != null && !FilterUtil.isAlarmingObjectFilteredType(boi)) {
                BControlPoint point = FilterUtil.findPoint(this.points, boi, this.getDisableStrictObjectIdCheck());
                if (this.getReplaceSourcenameWithDisplayname()) {
                    RevisionUtil.replaceSourceName(record, point);
                }
                if (this.getSetAlarmHyperlink()) {
                    RevisionUtil.setHyperlink(record, point);
                }
            }
        }
        catch (UnresolvedException ur) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Error replacing source and/or hyperlink on record " + record.getUuid(), ur);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error performing pre-routing tasks on record " + record.getUuid(), e);
        }
    }

    private void makePostRouteRevisions(BAlarmRecord record) {
        if (this.getUseBacnetAlarmPriority()) {
            log.warning("Alarm Priority setting is deprecated, changing to false");
            this.setUseBacnetAlarmPriority(false);
        }
    }

    public void started() throws Exception {
        this.points = this.getPoints();
        this.alarms = this.getAlarmDeviceExt();
        this.processorName = SlotPath.escape((String)(this.getName() + '-' + this.getHandle().toString()));
        if (this.alarms.get(this.processorName) == null) {
            BCustomBacnetEventProcessor processor = new BCustomBacnetEventProcessor();
            processor.setReassignerOrd(this.getHandleOrd());
            this.alarms.add(this.processorName, (BValue)processor, 256);
        }
    }

    public void stopped() throws Exception {
        if (this.processorName != null && Sys.getStation().isRunning() && this.alarms.get(this.processorName) != null) {
            this.alarms.remove(this.processorName);
        }
    }

    public boolean isChildLegal(BComponent child) {
        if (child instanceof BNCAlarmClassReassign) {
            return true;
        }
        throw new IllegalChildException(TYPE.getModule().getModuleName(), "noChild", THIS_TYPE_NAME);
    }

    public boolean isParentLegal(BComponent parent) {
        if (((BBacnetAlarmClassReassigner[])parent.getChildren(BBacnetAlarmClassReassigner.class)).length > 0) {
            throw new IllegalParentException(TYPE.getModule().getModuleName(), "parent.single", null);
        }
        return ParentLegal.is((BComplex)this, (BComplex)parent, BBacnetDevice.TYPE);
    }

    public BIcon getIcon() {
        return BIcon.std((String)"alarm.png");
    }

    public BBacnetDevice getDevice() {
        return (BBacnetDevice)this.getParent();
    }

    public BBacnetAlarmDeviceExt getAlarmDeviceExt() {
        return this.getDevice().getAlarms();
    }

    public BBacnetPointDeviceExt getPoints() {
        return this.getDevice().getPoints();
    }
}

