/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui.audio;

import com.tridium.alarm.ui.audio.SoundPlayer;
import java.io.BufferedInputStream;
import java.io.InputStream;
import javax.baja.file.BAbstractFile;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class MediaPlayer
extends SoundPlayer {
    public MediaPlayer() {
    }

    public MediaPlayer(BValue source, BAbstractFile mediaFile) {
        this.addMediaObject(source, mediaFile);
    }

    public MediaPlayer(BValue source, BAbstractFile mediaFile, BRelTime delay) {
        this.addMediaObject(source, mediaFile);
        this.delay = delay;
    }

    @Override
    protected void processMediaObject(Object obj) throws Exception {
        BAbstractFile file = (BAbstractFile)obj;
        InputStream in = file.getInputStream();
        BufferedInputStream bufferedIn = new BufferedInputStream(in);
        AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(bufferedIn);
        AudioFormat audioFormat = audioInputStream.getFormat();
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        if (!AudioSystem.isLineSupported(info)) {
            logger.warning("BAlarmConsole: audio system does not handle this type of audio: " + audioFormat);
            return;
        }
        SourceDataLine dataLine = (SourceDataLine)AudioSystem.getLine(info);
        dataLine.open(audioFormat);
        dataLine.start();
        int bufferSize = (int)file.getSize();
        if (bufferSize > 4096) {
            bufferSize = 4096;
        }
        byte[] buffer = new byte[bufferSize];
        int bytesRead = 0;
        int c = 0;
        while (!this.stopRequest) {
            ++c;
            bytesRead = audioInputStream.read(buffer, 0, buffer.length);
            if (bytesRead < 0) break;
            dataLine.write(buffer, 0, bytesRead);
        }
        dataLine.drain();
        dataLine.close();
    }
}

