/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.ext.BLimitEnable;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BLimitEnableFE
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BLimitEnableFE.class);
    private static Logger log = Logger.getLogger("control");
    private static Lexicon lex = Lexicon.make((String)"alarm");
    private boolean init = false;
    private BCheckBox low;
    private BCheckBox high;

    public Type getType() {
        return TYPE;
    }

    protected void doSetReadonly(boolean readonly) {
        this.init = false;
    }

    protected void doLoadValue(BObject value, Context cx) {
        BLimitEnable le = (BLimitEnable)value;
        if (!this.init) {
            this.initUi(le);
        }
        this.low.setSelected(le.getLowLimitEnable());
        this.high.setSelected(le.getHighLimitEnable());
        this.low.setEnabled(!this.isReadonly());
        this.high.setEnabled(!this.isReadonly());
        this.linkTo((BComponent)this.low, (Slot)BWbPlugin.actionPerformed, (Slot)actionPerformed);
        this.linkTo((BComponent)this.high, (Slot)BWbPlugin.actionPerformed, (Slot)actionPerformed);
    }

    protected BObject doSaveValue(BObject value, Context cx) {
        BLimitEnable le = (BLimitEnable)value;
        try {
            boolean l = this.low.getSelected();
            le.set(BLimitEnable.lowLimitEnable, (BValue)BBoolean.make((boolean)l), cx);
            boolean h = this.high.getSelected();
            le.set(BLimitEnable.highLimitEnable, (BValue)BBoolean.make((boolean)h), cx);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "BLimitEnable SaveValue Failed: ", e);
        }
        return le;
    }

    private void initUi(BLimitEnable le) {
        this.init = true;
        BGridPane pane = new BGridPane(2);
        pane.setColumnGap(6.0);
        this.low = new BCheckBox(lex.getText("lowLimit.enable"));
        pane.add("low", (BValue)this.low);
        this.high = new BCheckBox(lex.getText("highLimit.enable"));
        pane.add("high", (BValue)this.high);
        this.setContent((BWidget)pane);
        this.linkTo("lk0", (BComponent)this.low, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
        this.linkTo("lk1", (BComponent)this.high, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
    }
}

