/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui;

import com.tridium.workbench.fieldeditors.BDialogFE;
import javax.baja.alarm.BAlarmInstructions;
import javax.baja.alarm.BAlarmService;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DefaultTableModel;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BFormat;
import javax.baja.workbench.BWbShell;

public class BInstructionsFE
extends BDialogFE {
    public static final Action setEnabledStates = BInstructionsFE.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BInstructionsFE.class);
    BLabel label = new BLabel();
    BList list;
    BTable table;
    BAlarmInstructions instructions;
    Context ctx;
    BEdgePane mainPane = null;
    MoveDownCommand moveDownCommand = null;
    MoveUpCommand moveUpCommand = null;
    RemoveCommand removeCommand = null;
    EditCommand editCommand = null;
    AddCommand addCommand = null;
    public static final UiLexicon lexicon = UiLexicon.makeUiLexicon(BInstructionsFE.class);

    public void setEnabledStates() {
        this.invoke(setEnabledStates, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BInstructionsFE() {
        BFlowPane pane = new BFlowPane();
        pane.add(null, (BValue)this.label);
        pane.add(null, (BValue)this.getEditButton());
        this.setContent((BWidget)pane);
        this.addCommand = new AddCommand();
        this.editCommand = new EditCommand();
        this.removeCommand = new RemoveCommand();
        this.moveUpCommand = new MoveUpCommand();
        this.moveDownCommand = new MoveDownCommand();
        this.table = new BTable((TableModel)new NumberedTableModel());
        this.table.setHeaderVisible(false);
        this.table.setVgridVisible(false);
        BConstrainedPane listPane = new BConstrainedPane((BWidget)this.table);
        listPane.setMinSize(400.0, 200.0);
        this.mainPane = new BEdgePane();
        BGridPane cmdPane = new BGridPane(1);
        cmdPane.setColumnAlign(BHalign.fill);
        cmdPane.add(null, (BValue)new BButton((Command)this.addCommand));
        cmdPane.add(null, (BValue)new BButton((Command)this.editCommand));
        cmdPane.add(null, (BValue)new BButton((Command)this.removeCommand));
        cmdPane.add(null, (BValue)new BLabel(""));
        cmdPane.add(null, (BValue)new BButton((Command)this.moveUpCommand));
        cmdPane.add(null, (BValue)new BButton((Command)this.moveDownCommand));
        this.linkTo(null, (BComponent)this.table, (Slot)BTable.tableModified, (Slot)setEnabledStates);
        this.linkTo(null, (BComponent)this.table, (Slot)BTable.actionPerformed, (Slot)setEnabledStates);
        this.linkTo(null, (BComponent)this.table, (Slot)BTable.selectionModified, (Slot)setEnabledStates);
        this.doSetEnabledStates();
        this.mainPane.setCenter((BWidget)new BBorderPane((BWidget)listPane));
        this.mainPane.setRight((BWidget)new BBorderPane((BWidget)cmdPane));
    }

    public void doLoadValue(BObject value, Context cx) {
        this.instructions = (BAlarmInstructions)value;
        this.ctx = cx;
        this.label.setText(this.instructions.size() + " " + lexicon.getText("alarm.instructions"));
    }

    public BObject doSaveValue(BObject value, Context cx) {
        return this.instructions;
    }

    public void doSetReadonly(boolean readonly) {
        if (readonly) {
            this.moveDownCommand.setEnabled(!readonly);
            this.moveUpCommand.setEnabled(!readonly);
            this.removeCommand.setEnabled(!readonly);
            this.editCommand.setEnabled(!readonly);
            this.addCommand.setEnabled(!readonly);
        } else {
            this.addCommand.setEnabled(true);
        }
        this.table.setEnabled(!readonly);
        this.mainPane.setEnabled(!readonly);
    }

    public void setEnabled(boolean enabled) {
        this.setReadonly(!enabled);
    }

    public void doEditPressed() {
        ((NumberedTableModel)this.table.getModel()).removeAllRows();
        for (int i = 0; i < this.instructions.size(); ++i) {
            ((NumberedTableModel)this.table.getModel()).addRow(this.instructions.get(i));
        }
        int retVal = BDialog.open((BWidget)this, (String)"Edit", (Object)this.mainPane, (int)3);
        if (retVal == 2) {
            return;
        }
        BAlarmInstructions previousInstructions = this.instructions;
        BFormat[] inst = new BFormat[this.table.getModel().getRowCount()];
        for (int i = 0; i < this.table.getModel().getRowCount(); ++i) {
            inst[i] = ((NumberedTableModel)this.table.getModel()).getFormat(i);
        }
        this.instructions = BAlarmInstructions.make((BFormat[])inst);
        if (!this.instructions.equivalent((Object)previousInstructions)) {
            this.label.setText(this.instructions.size() + " " + lexicon.getText("alarm.instructions"));
            this.setModified();
        }
    }

    public void doSetEnabledStates() {
        boolean readonly = this.isReadonly();
        if (readonly) {
            this.moveDownCommand.setEnabled(false);
            this.moveUpCommand.setEnabled(false);
            this.removeCommand.setEnabled(false);
            this.editCommand.setEnabled(false);
            this.addCommand.setEnabled(false);
        } else {
            this.addCommand.setEnabled(true);
            boolean selectionPresent = !this.table.getSelection().isEmpty();
            this.removeCommand.setEnabled(selectionPresent);
            boolean singleSelectionPresent = this.table.getSelection().getRows().length == 1;
            this.moveDownCommand.setEnabled(singleSelectionPresent);
            this.moveUpCommand.setEnabled(singleSelectionPresent);
            this.editCommand.setEnabled(singleSelectionPresent);
        }
    }

    public final BComponent loadService(Type serviceType) {
        BWbShell shell = this.getWbShell();
        BOrd ord = BOrd.make((BOrd)shell.getActiveOrd(), (String)("service:" + serviceType.toString()));
        return (BComponent)ord.get();
    }

    public class NumberedTableModel
    extends DefaultTableModel {
        public NumberedTableModel() {
            super(new String[]{"", ""});
        }

        public void addRow(BFormat row) {
            super.addRow(new Object[]{null, row});
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int col) {
            return "";
        }

        public BFormat getFormat(int row) {
            return BFormat.make((String)super.getValueAt(row, 1).toString());
        }

        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return new String(row + 1 + ".");
            }
            return this.getFormat(row);
        }
    }

    private class MoveDownCommand
    extends Command {
        public MoveDownCommand() {
            super((BWidget)BInstructionsFE.this, TYPE.getModule(), "commands.moveDown");
        }

        public CommandArtifact doInvoke() {
            int row = BInstructionsFE.this.table.getSelection().getRow();
            if (row < BInstructionsFE.this.table.getModel().getRowCount() - 1) {
                Object val = BInstructionsFE.this.table.getModel().getValueAt(row, 1);
                Object swapVal = BInstructionsFE.this.table.getModel().getValueAt(row + 1, 1);
                ((NumberedTableModel)BInstructionsFE.this.table.getModel()).set(row, 1, swapVal);
                ((NumberedTableModel)BInstructionsFE.this.table.getModel()).set(row + 1, 1, val);
                BInstructionsFE.this.table.getSelection().deselectAll();
                BInstructionsFE.this.table.getSelection().select(row + 1);
            }
            return null;
        }
    }

    private class MoveUpCommand
    extends Command {
        public MoveUpCommand() {
            super((BWidget)BInstructionsFE.this, TYPE.getModule(), "commands.moveUp");
        }

        public CommandArtifact doInvoke() {
            int row = BInstructionsFE.this.table.getSelection().getRow();
            if (row > 0) {
                Object val = BInstructionsFE.this.table.getModel().getValueAt(row, 1);
                Object swapVal = BInstructionsFE.this.table.getModel().getValueAt(row - 1, 1);
                ((NumberedTableModel)BInstructionsFE.this.table.getModel()).set(row, 1, swapVal);
                ((NumberedTableModel)BInstructionsFE.this.table.getModel()).set(row - 1, 1, val);
                BInstructionsFE.this.table.getSelection().deselectAll();
                BInstructionsFE.this.table.getSelection().select(row - 1);
            }
            return null;
        }
    }

    private class RemoveCommand
    extends Command {
        public RemoveCommand() {
            super((BWidget)BInstructionsFE.this, TYPE.getModule(), "commands.removeMsg");
        }

        public CommandArtifact doInvoke() {
            int[] rows = BInstructionsFE.this.table.getSelection().getRows();
            for (int i = rows.length - 1; i >= 0; --i) {
                ((NumberedTableModel)BInstructionsFE.this.table.getModel()).removeRow(rows[i]);
            }
            return null;
        }
    }

    private class EditCommand
    extends Command {
        public EditCommand() {
            super((BWidget)BInstructionsFE.this, TYPE.getModule(), "commands.editMsg");
        }

        public CommandArtifact doInvoke() {
            int row = BInstructionsFE.this.table.getSelection().getRow();
            String value = BDialog.prompt((BWidget)BInstructionsFE.this, (String)"Edit", (String)BInstructionsFE.this.table.getModel().getValueAt(row, 1).toString(), (int)40);
            if (value != null) {
                if ((value = value.trim()).equals("")) {
                    ((NumberedTableModel)BInstructionsFE.this.table.getModel()).removeRow(row);
                } else {
                    ((NumberedTableModel)BInstructionsFE.this.table.getModel()).set(row, 1, value);
                    BInstructionsFE.this.table.sizeColumnsToFit();
                }
            }
            return null;
        }
    }

    private class AddCommand
    extends Command {
        public AddCommand() {
            super((BWidget)BInstructionsFE.this, TYPE.getModule(), "commands.addMsg");
        }

        public CommandArtifact doInvoke() {
            int retVal;
            BTextDropDown text = new BTextDropDown();
            BAlarmService service = (BAlarmService)BInstructionsFE.this.loadService(BAlarmService.TYPE);
            service.lease();
            BAlarmInstructions inst = service.getMasterAlarmInstructions();
            if (!BInstructionsFE.this.instructions.equals((Object)inst)) {
                for (int i = 0; i < inst.size(); ++i) {
                    text.getList().addItem((Object)inst.get(i));
                }
            }
            if ((retVal = BDialog.open((BWidget)BInstructionsFE.this, (String)"Add", (Object)new BBorderPane((BWidget)text), (int)3)) == 1) {
                String newText = text.getText().trim();
                if (newText == null || newText.equals("")) {
                    return null;
                }
                ((NumberedTableModel)BInstructionsFE.this.table.getModel()).addRow(BFormat.make((String)newText));
                BInstructionsFE.this.table.sizeColumnsToFit();
            }
            return null;
        }
    }
}

