/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui;

import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BAlarmTransitionBitsFE
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BAlarmTransitionBitsFE.class);
    static final String offnormalText = BAlarmTransitionBits.ALL.getTag(1);
    static final String faultText = BAlarmTransitionBits.ALL.getTag(2);
    static final String normalText = BAlarmTransitionBits.ALL.getTag(4);
    static final String alertText = BAlarmTransitionBits.ALL.getTag(8);
    public static final String SHOW_OFF_NORMAL = "showOffNormal";
    public static final String SHOW_NORMAL = "showNormal";
    public static final String SHOW_FAULT = "showFault";
    public static final String SHOW_ALERT = "showAlert";
    public static final String OFF_NORMAL_LABEL = "offNormalLabel";
    public static final String NORMAL_LABEL = "normalLabel";
    public static final String FAULT_LABEL = "faultLabel";
    public static final String ALERT_LABEL = "alertLabel";
    private boolean init = false;
    private BCheckBox offnormal;
    private BCheckBox fault;
    private BCheckBox normal;
    private BCheckBox alert;

    public Type getType() {
        return TYPE;
    }

    protected void doSetReadonly(boolean readonly) {
        this.init = false;
        if (readonly) {
            this.setContent((BWidget)new BTextField("", 45, false));
        }
    }

    protected void doLoadValue(BObject value, Context cx) {
        BAlarmTransitionBits b = (BAlarmTransitionBits)value;
        if (this.isReadonly()) {
            ((BTextField)this.getContent()).setText(value.toString(cx));
        } else {
            if (!this.init) {
                this.initCheckBoxes(cx);
            }
            this.offnormal.setSelected(b.isToOffnormal());
            this.fault.setSelected(b.isToFault());
            this.normal.setSelected(b.isToNormal());
            this.alert.setSelected(b.isToAlert());
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) {
        int bits = 0;
        if (this.offnormal.isSelected()) {
            bits |= 1;
        }
        if (this.fault.isSelected()) {
            bits |= 2;
        }
        if (this.normal.isSelected()) {
            bits |= 4;
        }
        if (this.alert.isSelected()) {
            bits |= 8;
        }
        return BAlarmTransitionBits.make((int)bits);
    }

    private void initCheckBoxes(Context cx) {
        this.init = true;
        int gridCols = 4;
        if (this.getBooleanFacetValue(cx, "multiLine", false)) {
            gridCols = 1;
        }
        BGridPane pane = new BGridPane(gridCols);
        this.offnormal = new BCheckBox(this.getStringFacetValue(cx, OFF_NORMAL_LABEL, offnormalText));
        this.fault = new BCheckBox(this.getStringFacetValue(cx, FAULT_LABEL, faultText));
        this.normal = new BCheckBox(this.getStringFacetValue(cx, NORMAL_LABEL, normalText));
        this.alert = new BCheckBox(this.getStringFacetValue(cx, ALERT_LABEL, alertText));
        if (this.getBooleanFacetValue(cx, SHOW_OFF_NORMAL, true)) {
            pane.add("offNormal", (BValue)this.offnormal, null);
        }
        if (this.getBooleanFacetValue(cx, SHOW_FAULT, true)) {
            pane.add("fault", (BValue)this.fault, null);
        }
        if (this.getBooleanFacetValue(cx, SHOW_NORMAL, true)) {
            pane.add("normal", (BValue)this.normal, null);
        }
        if (this.getBooleanFacetValue(cx, SHOW_ALERT, true)) {
            pane.add("alert", (BValue)this.alert, null);
        }
        this.setContent((BWidget)pane);
        this.linkTo("l0", (BComponent)this.offnormal, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
        this.linkTo("l1", (BComponent)this.fault, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
        this.linkTo("l2", (BComponent)this.normal, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
        this.linkTo("l3", (BComponent)this.alert, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
    }

    private boolean getBooleanFacetValue(Context cx, String facetName, boolean def) {
        if (cx == null) {
            return def;
        }
        BBoolean value = (BBoolean)cx.getFacet(facetName);
        return value == null ? def : value.getBoolean();
    }

    private String getStringFacetValue(Context cx, String facetName, String def) {
        if (cx == null) {
            return def;
        }
        BString value = (BString)cx.getFacet(facetName);
        return value == null ? def : value.toString();
    }
}

