/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui;

import com.tridium.alarm.ui.BAlarmConsole;
import com.tridium.alarm.ui.ConsoleTableModel;
import com.tridium.ui.theme.Theme;
import javax.baja.gx.BColor;
import javax.baja.gx.BInsets;
import javax.baja.gx.BSize;
import javax.baja.gx.Graphics;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.util.BAuxWidget;
import javax.baja.ui.util.UiLexicon;

public class BAlarmTitlePane
extends BEdgePane {
    public static final Action tableModified = BAlarmTitlePane.newAction((int)0, null, null);
    public static final Type TYPE = Sys.loadType(BAlarmTitlePane.class);
    public static final UiLexicon lexicon = UiLexicon.makeUiLexicon(BAlarmConsole.class);
    static String sourceText = lexicon.getText("alarm.sources");
    static String alarmText = lexicon.getText("alarm.alarms");
    static BInsets withIcon = BInsets.make((double)1.0, (double)4.0, (double)1.0, (double)2.0);
    static BInsets withoutIcon = BInsets.make((double)2.0, (double)4.0, (double)2.0, (double)4.0);
    BWidget content;
    BLabel label;
    BLabel info;
    BEdgePane top;
    BTable table;

    public void tableModified() {
        this.invoke(tableModified, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BAlarmTitlePane makePane(String title, BTable table) {
        BAlarmTitlePane pane = new BAlarmTitlePane(title, (BWidget)table);
        pane.setTable(table);
        return pane;
    }

    public BAlarmTitlePane(String title, BWidget content) {
        this.content = content;
        this.setStyleId("alarm-title-pane");
        this.label = new BLabel(title);
        this.label.setFont(Theme.widget().getBoldText());
        this.label.setForeground(BColor.white.toBrush());
        this.top = new BEdgePane();
        this.top.setLeft((BWidget)this.label);
        BBorderPane topBorder = new BBorderPane((BWidget)this.top, BBorder.make((String)"top(1) left(1) right(1)"), withoutIcon);
        topBorder.setFill(Theme.pane().getControlBackground((IStylable)this));
        BEdgePane edge = new BEdgePane();
        edge.setTop((BWidget)topBorder);
        edge.setCenter(content);
        this.setCenter((BWidget)new BBorderPane((BWidget)edge, BBorder.none, BInsets.DEFAULT));
    }

    public BAlarmTitlePane() {
    }

    public void setTitleVisible(boolean visible) {
        this.top.getParentWidget().setVisible(visible);
    }

    public void setTitle(String title) {
        this.label.setText(title);
    }

    public void setTable(BTable table) {
        this.table = table;
        if (this.info == null) {
            this.info = new BLabel("");
            this.info.setFont(Theme.widget().getBoldText());
            this.info.setForeground(BColor.white.toBrush());
            this.top.setRight((BWidget)this.info);
        }
        if (this.get("tableLink") != null) {
            this.remove("tableLink");
        }
        this.linkTo("tableLink", (BComponent)table, (Slot)BTable.tableModified, (Slot)tableModified);
        this.doTableModified();
    }

    public void doTableModified() {
        int sourceCount = 0;
        int alarmCount = 0;
        try {
            DynamicTableModel dtm = (DynamicTableModel)this.table.getModel();
            ConsoleTableModel ctm = (ConsoleTableModel)dtm.getRootModel();
            sourceCount = ctm.getSourceCount();
            alarmCount = ctm.getAlarmCount();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.info.setText(sourceCount + " " + sourceText + " / " + alarmCount + " " + alarmText);
        this.relayout();
    }

    class AuxSupport
    extends BAuxWidget.Support {
        final BSize size = BSize.make((double)10.0, (double)16.0);

        AuxSupport() {
        }

        public BSize getPreferredSize() {
            return this.size;
        }

        public void paint(Graphics g, double w, double h) {
            g.setBrush(BColor.white);
            double x = 2.0;
            double y = 5.0;
            if (BAlarmTitlePane.this.content.isVisible()) {
                g.strokeLine(x, y + 2.0, x + 2.0, y);
                g.strokeLine(x + 2.0, y, x + 4.0, y + 2.0);
                g.strokeLine(x + 1.0, y + 2.0, x + 2.0, y + 1.0);
                g.strokeLine(x + 2.0, y + 1.0, x + 3.0, y + 2.0);
                g.strokeLine(x, y + 6.0, x + 2.0, y + 4.0);
                g.strokeLine(x + 2.0, y + 4.0, x + 4.0, y + 6.0);
                g.strokeLine(x + 1.0, y + 6.0, x + 2.0, y + 5.0);
                g.strokeLine(x + 2.0, y + 5.0, x + 3.0, y + 6.0);
            } else {
                g.strokeLine(x, y, x + 2.0, y + 2.0);
                g.strokeLine(x + 2.0, y + 2.0, x + 4.0, y);
                g.strokeLine(x + 1.0, y, x + 2.0, y + 1.0);
                g.strokeLine(x + 2.0, y + 1.0, x + 3.0, y);
                g.strokeLine(x, y + 4.0, x + 2.0, y + 6.0);
                g.strokeLine(x + 2.0, y + 6.0, x + 4.0, y + 4.0);
                g.strokeLine(x + 1.0, y + 4.0, x + 2.0, y + 5.0);
                g.strokeLine(x + 2.0, y + 5.0, x + 3.0, y + 4.0);
            }
        }

        public void mousePressed(BMouseEvent event) {
            BAlarmTitlePane.this.content.setVisible(!BAlarmTitlePane.this.content.getVisible());
            BAlarmTitlePane.this.relayout();
        }
    }
}

