/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui;

import com.tridium.alarm.AlarmActionEnum;
import com.tridium.alarm.BAlarmConsoleChannel;
import com.tridium.alarm.BConsoleRecipient;
import com.tridium.alarm.fox.FoxAlarmCodec;
import com.tridium.alarm.ui.BAlarmConsole;
import com.tridium.alarm.ui.portal.BAlarmPortalTool;
import com.tridium.alarm.ui.portal.BPortalAlarmConsole;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import java.io.IOException;
import java.util.HashMap;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.util.Array;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BAlarmConsoleUIChannel
extends BAlarmConsoleChannel {
    public static final Type TYPE = Sys.loadType(BAlarmConsoleUIChannel.class);
    private Array<String> recips = new Array(String.class);
    private Array<BAlarmConsole> consoles = new Array(BAlarmConsole.class);
    private HashMap<String, BOrd> recipOrdMap = new HashMap();
    private BAlarmPortalTool tool;

    public Type getType() {
        return TYPE;
    }

    public BAlarmConsoleUIChannel() {
        super("alarmui");
    }

    public FoxResponse process(FoxRequest request) throws Exception {
        String command = request.command;
        if (this.isTraceOn()) {
            this.trace("AlarmConsoleChannel: command = " + command);
        }
        if (command == "new") {
            return this.newAlarms(request);
        }
        if (command == "error") {
            return this.error(request);
        }
        throw new InvalidCommandException(command);
    }

    private FoxResponse newAlarms(FoxRequest request) {
        if (this.isTraceOn()) {
            this.trace("received: new");
            request.dump();
        }
        FoxTuple[] msgs = request.list("alarmRec");
        for (int m = 0; m < msgs.length; ++m) {
            try {
                BAlarmRecord alarm = FoxAlarmCodec.decodeAlarm((FoxMessage)((FoxMessage)msgs[m]).getMessage("alarm"));
                String recipOrd = ((FoxMessage)msgs[m]).getString("ord");
                BAlarmConsole[] consoles = this.getConsolesRegisteredOn(recipOrd);
                for (int i = 0; i < consoles.length; ++i) {
                    BOrd ord;
                    BAlarmRecord rec;
                    BOrdList src;
                    if (consoles[i] == null) {
                        src = alarm.getSource();
                        rec = (BAlarmRecord)alarm.newCopy();
                        ord = this.recipOrdMap.get(recipOrd);
                        if (ord == null) continue;
                        src = BOrdList.add((BOrdList)src, (BOrd)ord);
                        rec.setSource(src);
                        this.tool.processAlarm(rec);
                        continue;
                    }
                    if (consoles[i] instanceof BPortalAlarmConsole) {
                        src = alarm.getSource();
                        rec = (BAlarmRecord)alarm.newCopy();
                        ord = this.recipOrdMap.get(recipOrd);
                        if (ord == null) continue;
                        src = BOrdList.add((BOrdList)src, (BOrd)ord);
                        rec.setSource(src);
                        consoles[i].processAlarm(rec);
                        continue;
                    }
                    consoles[i].processAlarm(alarm);
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void ackAlarms(BConsoleRecipient recip, BAlarmRecord[] alarms) throws Exception {
        int stop;
        int BATCH_SIZE = 100;
        int start = 0;
        int n = stop = BATCH_SIZE < alarms.length ? BATCH_SIZE : alarms.length;
        while (start < alarms.length) {
            FoxRequest msg = this.makeRequest("ack");
            msg.add("ord", recip.getOrdInSession().encodeToString());
            for (int i = start; i < stop; ++i) {
                msg.add("alarm", FoxAlarmCodec.encodeAlarm((BAlarmRecord)alarms[i]));
            }
            if (this.isTraceOn()) {
                this.trace("sending: ack");
            }
            int msgSize = msg.list("alarm").length;
            this.sendAsync(msg);
            start = stop;
            stop = (stop += BATCH_SIZE) < alarms.length ? stop : alarms.length;
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
    }

    public String getInitialAlarmQuery(BAlarmConsole console, BConsoleRecipient recip) throws Exception {
        return this.getInitialAlarmQuery(console, recip, BOrd.NULL);
    }

    public String getInitialAlarmQuery(BAlarmPortalTool tool, BConsoleRecipient recip) throws Exception {
        this.tool = tool;
        return this.getInitialAlarmQuery(null, recip, BOrd.NULL);
    }

    public String getInitialAlarmQuery(BAlarmConsole console, BConsoleRecipient recip, BOrd consoleOrd) throws Exception {
        FoxRequest msg = this.makeRequest("getInitialAlarmQuery");
        String recipOrd = recip.getOrdInSession().encodeToString();
        msg.add("ord", recipOrd);
        if (consoleOrd != null && !consoleOrd.isNull()) {
            this.recipOrdMap.put(recipOrd, consoleOrd);
        }
        try {
            FoxResponse resp = this.sendSync(msg);
            String error = resp.getString("error", null);
            if (error != null) {
                throw new Exception(error);
            }
            this.register(console, recipOrd);
            return resp.getString("query");
        }
        catch (IOException iOException) {
            return "";
        }
    }

    private FoxResponse error(FoxRequest request) {
        try {
            String message = request.getString("msg");
            Exception error = new Exception(request.getString("error"));
            String recipOrd = request.getString("ord");
            BAlarmConsole[] consoles = this.getConsolesRegisteredOn(recipOrd);
            for (int i = 0; i < consoles.length; ++i) {
                if (consoles[i] == null) continue;
                consoles[i].showError(message, error);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void unregister(BConsoleRecipient recip) throws Exception {
        FoxRequest msg = this.makeRequest("unregister");
        String recipOrd = recip.getOrdInSession().encodeToString();
        msg.add("ord", recipOrd);
        try {
            FoxResponse resp = this.sendSync(msg);
            String error = resp.getString("error", null);
            if (error != null) {
                throw new Exception(error);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void updateAlarm(BAlarmRecord alarm, AlarmActionEnum alarmAction) throws Exception {
        FoxRequest msg = this.makeRequest("updateAlarm");
        msg.add("alarm", FoxAlarmCodec.encodeAlarm((BAlarmRecord)alarm));
        msg.add("action", alarmAction.name());
        if (this.isTraceOn()) {
            this.trace("sending: update : timestamp: " + alarm.getTimestamp());
            this.trace("              source: " + alarm.getSource().encodeToString());
        }
        try {
            FoxResponse resp = this.sendSync(msg);
            String error = resp.getString("error", null);
            if (error != null) {
                throw new Exception(error);
            }
        }
        catch (IOException resp) {
        }
        catch (Exception e) {
            throw e;
        }
    }

    private void register(BAlarmConsole console, String recipOrd) {
        this.recips.add((Object)recipOrd);
        this.consoles.add((Object)console);
    }

    public void unregister(BAlarmConsole console) {
        int index = this.consoles.indexOf((Object)console);
        if (index < 0) {
            return;
        }
        if (this.consoles.size() > index) {
            this.consoles.remove(index);
        }
        if (this.recips.size() > index) {
            this.recips.remove(index);
        }
    }

    private BAlarmConsole[] getConsolesRegisteredOn(String recipOrd) {
        Array retVal = new Array(BAlarmConsole.class);
        for (int i = 0; i < this.recips.size(); ++i) {
            if (!((String)this.recips.get(i)).equals(recipOrd)) continue;
            retVal.add(this.consoles.get(i));
        }
        return (BAlarmConsole[])retVal.trim();
    }
}

