/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.smartTableHx.filter;

import com.tridium.bql.filter.BEnumFilter;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.filter.BHxEnumPickerView;
import com.tridium.smartTableHx.filter.BHxFilterFE;
import com.tridium.smartTableHx.tab.HxTabUtil;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.BComplex;
import javax.baja.sys.BEnum;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconModule;

public class BHxEnumFilterFE
extends BHxFilterFE {
    private static final LexiconModule lex = LexiconModule.make(BHxEnumFilterFE.class);
    public static final BHxEnumFilterFE INSTANCE = new BHxEnumFilterFE();
    public static final Type TYPE = Sys.loadType(BHxEnumFilterFE.class);
    private static BImage editIcon = BImage.make((String)"module://icons/x16/doubleArrowRight.png");
    private Command pickerCommand = new PickerCommand((BHxView)this);

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BHxEnumFilterFE() {
        this.registerEvent((Event)this.pickerCommand);
    }

    @Override
    public String getReadonlyInvokeCode(HxOp op) throws Exception {
        return super.getReadonlyInvokeCode(op) + "if(this.checked)" + SmartCommand.getShowCode(op.scope("picker"), "&quot;", op) + " else " + SmartCommand.getHideCode(op.scope("picker"), "&quot;", op);
    }

    public void write(HxOp op) throws Exception {
        BEnumFilter filter = (BEnumFilter)op.get();
        BEnum enumType = filter.getEnumType();
        BVector enumValues = filter.getEnumValues();
        HtmlWriter out = op.getHtmlWriter();
        boolean showPreview = op.getFacets().getb("showPreview", true);
        if (showPreview) {
            out.w((Object)"<input ");
            out.attr("type", "text");
            out.attr("size", "30");
            out.attr("name", op.scope("preview"));
            out.attr("id", op.scope("preview"));
            out.attr("value", this.updateField(enumValues, op));
            out.attr("readonly", "readonly");
            out.attr("locked", "locked");
            out.w((Object)"/>");
        }
        out.w((Object)"<span ");
        boolean readonly = Flags.isReadonly((BComplex)filter.getParent().getParent(), (Slot)filter.getParent().getPropertyInParent());
        if (!op.canWrite() || readonly) {
            out.attr("style", "display:none;");
        }
        out.attr("onclick", this.pickerCommand.getInvokeCode(op));
        out.attr("id", op.scope("picker"));
        out.attr("class", "dialogOpenButton");
        out.w((Object)">");
        out.w((Object)"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        out.w((Object)"</span>");
    }

    public String updateField(BVector enumValues, HxOp op) {
        StringBuffer s = new StringBuffer();
        BEnum[] enumArr = (BEnum[])enumValues.getChildren(BEnum.class);
        for (int i = 0; i < enumArr.length; ++i) {
            if (i > 0) {
                s.append(" | ");
            }
            s.append(enumArr[i]);
        }
        return s.toString();
    }

    public BObject save(HxOp op) throws Exception {
        BEnumFilter filter = (BEnumFilter)op.get();
        BEnum enumType = filter.getEnumType();
        if (SmartCommand.getSelectionListForm(op) == null) {
            return filter;
        }
        String[] enumTags = SmartCommand.getSelectionList(op);
        BVector enumValues = new BVector();
        for (int i = 0; i < enumTags.length; ++i) {
            BEnum e = (BEnum)enumType.getRange().get(0).decodeFromString(enumTags[i]);
            enumValues.add("e?", (BValue)e);
        }
        filter.setEnumValues(enumValues);
        return filter;
    }

    public boolean process(HxOp op) throws Exception {
        if (super.process(op)) {
            return true;
        }
        return BHxEnumPickerView.INSTANCE.process(op.make("picker", (OrdTarget)op));
    }

    public class PickerCommand
    extends Command {
        private PickerDialog dlg;

        public PickerCommand(BHxView view) {
            super(view);
            this.dlg = new PickerDialog(this, this.getDisplayName(null));
        }

        public String getInvokeCode(HxOp op) {
            StringBuffer b = new StringBuffer();
            b.append("hx.fireEvent('").append(op.getPath());
            b.append("','");
            b.append(this.getId());
            b.append("');");
            return b.toString();
        }

        public String getDisplayName(HxOp op) {
            return lex.getText("enums", (Context)op);
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(op);
                return;
            }
            BEnumFilter filter = (BEnumFilter)op.get();
            BEnum enumType = filter.getEnumType();
            HxOp fieldOp = op.make("picker", (OrdTarget)op);
            String[] enumTags = SmartCommand.getSelectionList(fieldOp);
            BVector enumValues = new BVector();
            for (int i = 0; i < enumTags.length; ++i) {
                BEnum e = (BEnum)enumType.getRange().get(0).decodeFromString(enumTags[i]);
                enumValues.add("e?", (BValue)e);
            }
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"hx.setFormValue('").w((Object)op.scope("preview")).w((Object)"','").w((Object)BHxEnumFilterFE.this.updateField(enumValues, op)).w((Object)"');");
            out.w((Object)"hx.setFormValue('").w((Object)op.scope("selectionList")).w((Object)"',\"").w((Object)fieldOp.getUnsafeFormValue("selectionList")).w((Object)"\");");
            out.w((Object)"hx.setFormValue('").w((Object)fieldOp.scope("backupSelectionList"));
            out.w((Object)"',\"").w((Object)fieldOp.getUnsafeFormValue("selectionList")).w((Object)"\");");
            HxTabUtil.fireSaveEventInFacets(op);
        }

        private class PickerDialog
        extends Dialog {
            PickerDialog(Command handler, String title) {
                super(title, handler);
            }

            protected void writeContent(HxOp op) throws Exception {
                BEnumFilter filter = (BEnumFilter)op.get();
                boolean readonly = Flags.isReadonly((BComplex)filter.getParent().getParent(), (Slot)filter.getParent().getPropertyInParent());
                HxOp pickerOp = op.make("picker", (OrdTarget)op);
                if (!op.canWrite() || readonly) {
                    pickerOp.setReadonly(true);
                }
                HtmlWriter out = op.getHtmlWriter();
                BHxEnumPickerView.INSTANCE.write(pickerOp);
            }
        }
    }
}

