/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.smartTableHx.export;

import com.tridium.file.exporters.BITableToCsv;
import com.tridium.smartTableHx.TableContents;
import com.tridium.smartTableHx.export.BExportData;
import java.io.PrintWriter;
import javax.baja.file.ExportOp;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"report:IGrid"}, requiredPermissions="r")})
@NiagaraProperties(value={@NiagaraProperty(name="facets", type="baja:Facets", defaultValue="BFacets.DEFAULT", flags=4, override=true), @NiagaraProperty(name="encodeToString", type="boolean", defaultValue="BBoolean.FALSE", flags=4, override=true)})
public class BSmartTableToCsv
extends BITableToCsv {
    public static final Property facets = BSmartTableToCsv.newProperty((int)4, (BValue)BFacets.DEFAULT, null);
    public static final Property encodeToString = BSmartTableToCsv.newProperty((int)4, (BValue)BBoolean.FALSE, null);
    public static final Type TYPE = Sys.loadType(BSmartTableToCsv.class);

    public Type getType() {
        return TYPE;
    }

    public void export(ExportOp op) {
        if (this.delimiterContainsFunctionCharacter(this.getDelimiter())) {
            throw new IllegalArgumentException("+, -, =, @ cannot be part of delimiter");
        }
        BExportData data = (BExportData)op.get();
        TableContents contents = data.getTableContents();
        PrintWriter out = new PrintWriter(op.getOutputStream());
        if (this.getIncludeBOM()) {
            out.print("\ufeff");
            out.flush();
        }
        boolean writtenOnce = false;
        if (this.getIncludeHeaders()) {
            TableContents.Tr cols = contents.columns;
            for (int i = 0; i < cols.td.size(); ++i) {
                TableContents.Td td = cols.td.get(i);
                String name = td.text;
                if (writtenOnce) {
                    out.print(this.getDelimiter());
                }
                name = this.escapeFormulas(name);
                if (LEGACY_CSV_ENCODING) {
                    name = name.replace(',', '_');
                    name = name.replace('\"', '\'');
                    out.print(name);
                } else {
                    this.printValue(name, out);
                }
                writtenOnce = true;
            }
            if (writtenOnce) {
                out.print(this.getLineEnding());
            }
        }
        for (int i = 0; i < contents.tr.size(); ++i) {
            TableContents.Tr tr = contents.tr.get(i);
            if (tr.hidden) continue;
            writtenOnce = false;
            for (int j = 0; j < tr.td.size(); ++j) {
                TableContents.Td td = tr.td.get(j);
                String text = td.text;
                if (writtenOnce) {
                    out.print(this.getDelimiter());
                }
                text = this.escapeFormulas(text);
                if (LEGACY_CSV_ENCODING) {
                    if (text.contains(this.getDelimiter()) || text.contains("'")) {
                        out.print('\"');
                        out.print(TextUtil.replace((String)text, (String)"\"", (String)"\"\""));
                        out.print('\"');
                    } else {
                        out.print(text);
                    }
                } else {
                    this.printValue(text, out);
                }
                writtenOnce = true;
            }
            out.print(this.getLineEnding());
        }
        out.flush();
    }
}

