/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.smartTableHx.export;

import com.tridium.smartTableHx.BHxSmartTableView;
import java.util.ArrayList;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconModule;

public class BHxImageFE
extends BHxFieldEditor {
    private static final LexiconModule lex = LexiconModule.make(BHxImageFE.class);
    public static final BHxImageFE INSTANCE = new BHxImageFE();
    public static final Type TYPE = Sys.loadType(BHxImageFE.class);
    public BOrd imageLocation = BOrd.make((String)"file:^images");
    static BImage blank = BImage.make((String)"module://icons/x16/blank.png");
    static BImage browseIcon = BImage.make((String)"module://icons/x16/open.png");
    private static Browse browse;

    public Type getType() {
        return TYPE;
    }

    protected BHxImageFE() {
        browse = new Browse((BHxView)this);
        this.registerEvent((Event)browse);
    }

    public String preview(HxOp op) throws Exception {
        BImage value = (BImage)op.get();
        StringBuffer out = new StringBuffer();
        out.append("<img height='16'");
        if (value != null) {
            out.append("src='").append(value.toString()).append("' ");
        }
        out.append(" />");
        return out.toString();
    }

    public void write(HxOp op) throws Exception {
        op.addJavaScript(BOrd.make((String)"module://smartTableHx/rc/smartTable.js"));
        op.addJavaScript(BOrd.make((String)"module://smartTableHx/rc/save.js"));
        BImage value = (BImage)op.get();
        HtmlWriter out = op.getHtmlWriter();
        BHxSmartTableView.writeFormValue("image", value.toString(), op);
        BHxSmartTableView.writeFormValue("imageLocation", "" + op.getFacets().get("imageLocation"), op);
        out.w((Object)"<img");
        this.scope("pdfImage", out, op);
        if (value != null) {
            out.w((Object)"src='").w((Object)value.toString()).w((Object)"' ");
        }
        out.w((Object)"/>&nbsp;&nbsp;");
        if (op.canWrite()) {
            out.w((Object)"<span style=' cursor: pointer; vertical-align: bottom;'>");
            out.w((Object)"<img src='").w((Object)browseIcon.toString()).w((Object)"' ");
            out.w((Object)"onclick='").w((Object)browse.getInvokeCode(op));
            out.w((Object)"' />");
            out.w((Object)"</span>");
        }
    }

    public BObject save(HxOp op) throws Exception {
        String image = op.getUnsafeFormValue("image");
        return BImage.make((String)image);
    }

    public HtmlWriter scope(String name, HtmlWriter out, HxOp op) {
        out.w((Object)" name='").w((Object)op.scope(name)).w((Object)"'");
        out.w((Object)" id='").w((Object)op.scope(name)).w((Object)"' ");
        return out;
    }

    class BrowseDialog
    extends Dialog {
        public BrowseDialog(LexiconModule lex, String key, Command handler) {
            super(lex, key, handler);
        }

        public BImage[] getImages(HxOp op) {
            ArrayList<BImage> images = new ArrayList<BImage>();
            BOrd imageOrd = BHxImageFE.this.imageLocation;
            try {
                BDirectory dir = (BDirectory)imageOrd.resolve().get();
                BIFile[] oldFiles = dir.listFiles();
                for (int i = 0; i < oldFiles.length; ++i) {
                    images.add(BImage.make((String)(BHxImageFE.this.imageLocation + "/" + oldFiles[i].getFileName())));
                }
                return images.toArray(new BImage[images.size()]);
            }
            catch (UnresolvedException e) {
                return new BImage[0];
            }
        }

        protected void writeContent(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            String oldImage = op.getUnsafeFormValue("image");
            if (oldImage.equals("null")) {
                oldImage = blank.toString();
            }
            double maxWidth = 350.0;
            double maxHeight = 128.0;
            BImage[] images = this.getImages(op);
            out.w((Object)"<div style='width: ").w(maxWidth + 4.0).w((Object)"px; ");
            out.w((Object)" width: ").w(maxWidth + 4.0).w((Object)"px;");
            out.w((Object)" height: ").w(maxHeight + 4.0).w((Object)"px;'>");
            out.w((Object)"<img style='");
            if (oldImage.equals(blank.toString())) {
                out.w((Object)" visibility: hidden; ");
            }
            out.w((Object)"max-height: ").w(maxHeight).w((Object)"px; ");
            out.w((Object)"max-width: ").w(maxWidth).w((Object)"px; '");
            BHxImageFE.this.scope("preview", out, op);
            out.w((Object)"src='");
            out.w((Object)oldImage).w((Object)"' ");
            out.w((Object)"/></div><br/>");
            out.w((Object)"<select style='width: 300px' ");
            BHxImageFE.this.scope("picture", out, op).w((Object)"' size='5' ");
            out.w((Object)"onchange='");
            out.w((Object)"if(this.value == &quot;").w((Object)blank.toString()).w((Object)"&quot;)");
            out.w((Object)"document.getElementById(&quot;").w((Object)op.scope("preview"));
            out.w((Object)"&quot;).style.visibility=&quot;hidden&quot; ; ");
            out.w((Object)"else ");
            out.w((Object)"document.getElementById(&quot;").w((Object)op.scope("preview"));
            out.w((Object)"&quot;).style.visibility=&quot;visible&quot; ; ");
            out.w((Object)"document.getElementById(&quot;").w((Object)op.scope("preview"));
            out.w((Object)"&quot;).setAttribute(");
            out.w((Object)"&quot;src&quot;,&quot;ord?&quot; + this.value);");
            out.w((Object)"'>");
            for (int i = 0; i < images.length; ++i) {
                BImage image = images[i];
                out.w((Object)"<option value='").w((Object)image.toString()).w((Object)"' ");
                if (oldImage.equals(image.toString())) {
                    out.w((Object)"selected");
                }
                out.w((Object)">");
                String[] split = TextUtil.split((String)image.toString(), (char)'/');
                out.safe((Object)split[split.length - 1]).w((Object)"</option>");
            }
            out.w((Object)"<option value='").w((Object)blank.toString()).w((Object)"' ");
            if (oldImage.equals(blank.toString())) {
                out.w((Object)"selected");
            }
            out.w((Object)">").safe((Object)lex.getText("noImage", (Context)op)).w((Object)"</option>");
            out.w((Object)"</select>");
        }
    }

    public class Browse
    extends Command {
        private BrowseDialog dialog;

        public Browse(BHxView view) {
            super(view);
            this.dialog = new BrowseDialog(lex, "browse", this);
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dialog.isSubmit(op)) {
                this.dialog.open(op);
                return;
            }
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"save.modified();");
            out.w((Object)"if('").w((Object)op.getUnsafeFormValue("picture")).w((Object)"'");
            out.w((Object)" == '").w((Object)blank.toString()).w((Object)"')");
            out.w((Object)"document.getElementById('").w((Object)op.scope("pdfImage"));
            out.w((Object)"').style.visibility='hidden' ; ");
            out.w((Object)"else ");
            out.w((Object)"document.getElementById('").w((Object)op.scope("pdfImage"));
            out.w((Object)"').style.visibility='visible' ; ");
            out.w((Object)"document.getElementById('").w((Object)op.scope("pdfImage")).w((Object)"').setAttribute(");
            out.w((Object)"'src','ord?").w((Object)op.getUnsafeFormValue("picture")).w((Object)"');");
            out.w((Object)"hx.setFormValue('").w((Object)op.scope("image")).w((Object)"','");
            out.w((Object)op.getUnsafeFormValue("picture")).w((Object)"');");
        }
    }
}

