/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.smartTableHx.export;

import com.tridium.hx.fieldeditors.BHxDefaultFE;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.export.BColoredFont;
import java.util.HashSet;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconModule;

public class BHxColoredFontFE
extends BHxFieldEditor {
    private static final LexiconModule lex = LexiconModule.make(BHxColoredFontFE.class);
    public static final BHxColoredFontFE INSTANCE = new BHxColoredFontFE();
    public static final Type TYPE = Sys.loadType(BHxColoredFontFE.class);
    public String fontsLocation = "module://fonts/microFont";
    private static int[] fontSizes = new int[]{8, 9, 10, 11, 12, 14, 16, 18, 20, 22, 24, 26, 28, 36, 48, 72};

    public Type getType() {
        return TYPE;
    }

    protected BHxColoredFontFE() {
    }

    public String preview(HxOp op) throws Exception {
        BColoredFont coloredFont = (BColoredFont)op.get();
        BFont value = coloredFont.getFont();
        BColor foreground = coloredFont.getForegroundColor();
        BColor background = coloredFont.getBackgroundColor();
        StringBuffer out = new StringBuffer();
        out.append("<span ");
        out.append("style='");
        out.append("cursor: default;");
        if (foreground != BColor.NULL) {
            out.append("color: ").append(foreground.toHtmlString()).append(";");
        }
        if (background != BColor.NULL) {
            out.append("background-color: ").append(background.toHtmlString()).append(";");
        }
        if (value.isUnderline()) {
            out.append("text-decoration: underline ;");
        }
        out.append("font: ");
        if (value.isBold()) {
            out.append("bold ");
        }
        if (value.isItalic()) {
            out.append("italic ");
        }
        out.append(value.getSize()).append("px ").append(value.getName()).append(" '>");
        out.append(lex.getHtmlSafe("aaBbYyZz", (Context)op));
        out.append("</span>");
        return out.toString();
    }

    public void write(HxOp op) throws Exception {
        int i;
        BColoredFont coloredFont = (BColoredFont)op.get();
        BFont value = coloredFont.getFont();
        BColor foreground = coloredFont.getForegroundColor();
        BColor background = coloredFont.getBackgroundColor();
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<table style='border: 1px solid black'><tr><td colspan='2' >");
        out.w((Object)"<select ");
        this.scope("name", out, op);
        if (op.canWrite()) {
            out.w((Object)"onmouseover='document.getElementById(&quot;");
            out.w((Object)op.scope("preview")).w((Object)"&quot;).style.fontFamily=this.value;'");
            out.w((Object)"onkeypress='document.getElementById(&quot;");
            out.w((Object)op.scope("preview")).w((Object)"&quot;).style.fontFamily=this.value;'");
            out.w((Object)"onchange='document.getElementById(&quot;");
            out.w((Object)op.scope("preview")).w((Object)"&quot;).style.fontFamily=this.value;'");
        } else {
            out.attr("disabled", "disabled");
        }
        out.w((Object)">");
        String[] fontNames = this.getFontNames();
        for (i = 0; i < fontNames.length; ++i) {
            out.w((Object)"<option style='font-family: ").safe((Object)fontNames[i]).w((Object)"'");
            if (fontNames[i].equals(value.getName())) {
                out.w((Object)" selected='selected'");
            }
            out.w((Object)"value='").safe((Object)fontNames[i]).w((Object)"'");
            out.w((Object)">").safe((Object)fontNames[i]).w((Object)"</option>");
        }
        out.w((Object)"</select>");
        out.w((Object)"<select ");
        this.scope("size", out, op);
        if (op.canWrite()) {
            out.w((Object)"onmouseover='document.getElementById(&quot;");
            out.w((Object)op.scope("preview")).w((Object)"&quot;).style.fontSize=this.value+&quot;px&quot;;'");
            out.w((Object)"onkeypress='document.getElementById(&quot;");
            out.w((Object)op.scope("preview")).w((Object)"&quot;).style.fontSize=this.value+&quot;px&quot;;'");
            out.w((Object)"onchange='document.getElementById(&quot;");
            out.w((Object)op.scope("preview")).w((Object)"&quot;).style.fontSize=this.value+&quot;px&quot;;'");
        } else {
            out.attr("disabled", "disabled");
        }
        out.w((Object)">");
        for (i = 0; i < fontSizes.length; ++i) {
            out.w((Object)"<option ");
            if ((double)fontSizes[i] == value.getSize()) {
                out.w((Object)" selected='selected'");
            }
            out.w((Object)"value='").safe((Object)String.valueOf(fontSizes[i])).w((Object)"'");
            out.w((Object)">").safe((Object)String.valueOf(fontSizes[i])).w((Object)"</option>");
        }
        out.w((Object)"</select>");
        out.w((Object)"</td><td ");
        this.scope("preview", out, op);
        out.w((Object)"rowspan='5'style='");
        if (foreground != BColor.NULL) {
            out.w((Object)"color: ").w((Object)foreground.toHtmlString()).w((Object)";");
        }
        if (background != BColor.NULL) {
            out.w((Object)"background-color: ").w((Object)background.toHtmlString()).w((Object)";");
        }
        if (value.isUnderline()) {
            out.w((Object)"text-decoration: underline ;");
        }
        out.w((Object)"font: ");
        if (value.isBold()) {
            out.w((Object)"bold ");
        }
        if (value.isItalic()) {
            out.w((Object)"italic ");
        }
        out.w(value.getSize()).w((Object)"px ").w((Object)value.getName()).w((Object)" '>");
        out.w((Object)lex.getHtmlSafe("aaBbYyZz", (Context)op));
        out.w((Object)"</td></tr>");
        out.w((Object)"<tr><td valign='top' colspan='2'>");
        out.w((Object)"&nbsp;<b>B</b>");
        out.w((Object)"<input type='checkbox' ");
        this.scope("bold", out, op);
        if (value.isBold()) {
            out.w((Object)"checked ");
        }
        if (!op.canWrite()) {
            out.attr("disabled", "disabled");
        } else {
            out.w((Object)" onclick='var x=&quot;&quot;;if (this.checked) x=&quot;bold&quot;;");
            out.w((Object)"document.getElementById(&quot;");
            out.w((Object)op.scope("preview")).w((Object)"&quot;).style.fontWeight=x;'");
        }
        out.w((Object)"/>");
        out.w((Object)"&nbsp;<i>I</i>");
        out.w((Object)"<input type='checkbox' ");
        this.scope("italic", out, op);
        if (value.isItalic()) {
            out.w((Object)"checked ");
        }
        if (!op.canWrite()) {
            out.attr("disabled", "disabled");
        } else {
            out.w((Object)" onclick='var x=&quot;&quot;; if (this.checked) x=&quot;italic&quot;;");
            out.w((Object)"document.getElementById(&quot;");
            out.w((Object)op.scope("preview")).w((Object)"&quot;).style.fontStyle=x;'");
        }
        out.w((Object)"/>");
        out.w((Object)"&nbsp;<u>U</u>");
        out.w((Object)"<input type='checkbox' ");
        this.scope("underline", out, op);
        if (value.isUnderline()) {
            out.w((Object)"checked ");
        }
        if (!op.canWrite()) {
            out.attr("disabled", "disabled");
        } else {
            out.w((Object)" onclick='var x=&quot;&quot;;if (this.checked) x=&quot;underline&quot;;");
            out.w((Object)"document.getElementById(&quot;");
            out.w((Object)op.scope("preview")).w((Object)"&quot;).style.textDecoration=x;'");
        }
        out.w((Object)"/>");
        out.w((Object)"</td></tr>");
        out.w((Object)"<tr><td colspan='2'>&nbsp;</td></tr>");
        out.w((Object)"<tr><td>").w((Object)lex.getHtmlSafe("foreground", (Context)op)).w((Object)"</td><td align='left'>");
        BHxFieldEditor editor = BHxFieldEditor.makeFor((BObject)coloredFont.getForegroundColor(), (Context)op);
        OrdTarget target = new OrdTarget(op.getBaseOrdTarget(), (BObject)coloredFont.getForegroundColor());
        HxOp fieldOp = op.make("foregroundColor", target);
        SmartCommand.matchReadonly(fieldOp, op);
        editor.write(fieldOp);
        out.w((Object)"</td></tr>");
        out.w((Object)"<tr><td>").w((Object)lex.getHtmlSafe("background", (Context)op)).w((Object)"</td><td align='left'>");
        editor = BHxFieldEditor.makeFor((BObject)coloredFont.getForegroundColor(), (Context)op);
        target = new OrdTarget(op.getBaseOrdTarget(), (BObject)coloredFont.getBackgroundColor());
        fieldOp = op.make("backgroundColor", target);
        SmartCommand.matchReadonly(fieldOp, op);
        editor.write(fieldOp);
        out.w((Object)"</td></tr></table>");
    }

    public BObject save(HxOp op) throws Exception {
        String underline;
        String italic;
        BColoredFont coloredFont = (BColoredFont)op.get();
        String name = op.getFormValue("name");
        int size = Integer.parseInt(op.getFormValue("size"));
        int style = 0;
        String bold = op.getFormValue("bold");
        if (bold != null) {
            style |= 1;
        }
        if ((italic = op.getFormValue("italic")) != null) {
            style |= 2;
        }
        if ((underline = op.getFormValue("underline")) != null) {
            style |= 4;
        }
        coloredFont.setFont(BFont.make((String)name, (double)size, (int)style));
        BHxFieldEditor editor = BHxFieldEditor.makeFor((BObject)coloredFont.getBackgroundColor(), (Context)op);
        OrdTarget target = new OrdTarget(op.getBaseOrdTarget(), (BObject)coloredFont.getBackgroundColor());
        coloredFont.setBackgroundColor((BColor)editor.save(op.make("backgroundColor", target)));
        editor = BHxFieldEditor.makeFor((BObject)coloredFont.getForegroundColor(), (Context)op);
        target = new OrdTarget(op.getBaseOrdTarget(), (BObject)coloredFont.getForegroundColor());
        coloredFont.setForegroundColor((BColor)editor.save(op.make("foregroundColor", target)));
        return coloredFont;
    }

    public boolean process(HxOp op) throws Exception {
        BComplex style = (BComplex)op.get();
        Property[] values = style.getPropertiesArray();
        for (int i = 0; i < values.length; ++i) {
            String displayName = values[i].getName();
            BHxDefaultFE editor = null;
            try {
                editor = BHxFieldEditor.makeFor((BObject)style.get(displayName), (Context)op);
            }
            catch (RuntimeException e) {
                editor = BHxDefaultFE.INSTANCE;
            }
            OrdTarget target = new OrdTarget(op.getBaseOrdTarget(), (BObject)style.get(displayName));
            if (!editor.process(op.make(displayName, target))) continue;
            return true;
        }
        return false;
    }

    public HtmlWriter scope(String name, HtmlWriter out, HxOp op) {
        out.w((Object)" name='").w((Object)op.scope(name)).w((Object)"'");
        out.w((Object)" id='").w((Object)op.scope(name)).w((Object)"' ");
        return out;
    }

    private String[] getFontNames() {
        HashSet<String> fonts = new HashSet<String>();
        BOrd fontsOrd = BOrd.make((String)this.fontsLocation);
        BIDirectory dir = (BIDirectory)fontsOrd.resolve().get();
        BIFile[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            String name = files[i].getFileName();
            int index = name.indexOf("pt ");
            name = name.substring(index + 3);
            index = name.indexOf(".");
            name = name.substring(0, index);
            fonts.add(name);
        }
        return fonts.toArray(new String[fonts.size()]);
    }
}

