/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.smartTableHx.export;

import com.tridium.gx.util.ColorUtil;
import com.tridium.smartTableHx.BHxSmartTableView;
import java.util.Arrays;
import java.util.Comparator;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconModule;

public class BHxColorFE
extends BHxFieldEditor {
    private static final LexiconModule lex = LexiconModule.make(BHxColorFE.class);
    public static final BHxColorFE INSTANCE = new BHxColorFE();
    public static final Type TYPE = Sys.loadType(BHxColorFE.class);
    static BImage blank = BImage.make((String)"module://icons/x16/blank.png");
    static BImage browseIcon = BImage.make((String)"module://icons/x16/open.png");
    private static Browse browse;
    private BColor[] defaultColorList = new BColor[]{BColor.make((int)-65536), BColor.make((int)-12582912), BColor.make((int)-8388608), BColor.make((int)-4194304), BColor.make((int)-49088), BColor.make((int)-32640), BColor.make((int)-16192), BColor.make((int)-16777216), BColor.make((int)Short.MIN_VALUE), BColor.make((int)-12574720), BColor.make((int)-8372224), BColor.make((int)-4235264), BColor.make((int)-24512), BColor.make((int)-16256), BColor.make((int)-8257), BColor.make((int)-14671840), BColor.make((int)-256), BColor.make((int)-12566528), BColor.make((int)-8355840), BColor.make((int)-4145152), BColor.make((int)-192), BColor.make((int)-128), BColor.make((int)-64), BColor.make((int)-12566464), BColor.make((int)-16711936), BColor.make((int)-16760832), BColor.make((int)-16744448), BColor.make((int)-16728064), BColor.make((int)-12517568), BColor.make((int)-8323200), BColor.make((int)-4128832), BColor.make((int)-10461088), BColor.make((int)-16711681), BColor.make((int)-16760768), BColor.make((int)-16744320), BColor.make((int)-16727872), BColor.make((int)-12517377), BColor.make((int)-8323073), BColor.make((int)-4128769), BColor.make((int)-8355712), BColor.make((int)-16776961), BColor.make((int)-16777152), BColor.make((int)-16777088), BColor.make((int)-16777024), BColor.make((int)-12566273), BColor.make((int)-8355585), BColor.make((int)-4144897), BColor.make((int)-4144960), BColor.make((int)-8388353), BColor.make((int)-14811072), BColor.make((int)-12844928), BColor.make((int)-10878784), BColor.make((int)-6667777), BColor.make((int)-4488961), BColor.make((int)-2244609), BColor.make((int)-2039584), BColor.make((int)-65281), BColor.make((int)-12582848), BColor.make((int)-8388480), BColor.make((int)-4194112), BColor.make((int)-48897), BColor.make((int)-32513), BColor.make((int)-16129), BColor.make((int)-1)};

    public Type getType() {
        return TYPE;
    }

    protected BHxColorFE() {
        browse = new Browse((BHxView)this);
        this.registerEvent((Event)browse);
    }

    public BColor getColor(HxOp op) {
        BValue value = (BValue)op.get();
        if (value instanceof BString) {
            return BColor.make((String)((BString)value).getString());
        }
        return (BColor)value;
    }

    public String preview(HxOp op) throws Exception {
        BColor value = this.getColor(op);
        StringBuffer out = new StringBuffer();
        out.append("<span ");
        if (value != null) {
            out.append("style=' border: 1px solid black; ");
            out.append("cursor: default;");
            out.append("background-color: ").append(value.toHtmlString()).append("' ");
        }
        out.append(">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        out.append("</span>");
        return out.toString();
    }

    public void write(HxOp op) throws Exception {
        BColor value = this.getColor(op);
        HtmlWriter out = op.getHtmlWriter();
        op.addJavaScript(BOrd.make((String)"module://smartTableHx/rc/color.js"));
        op.addJavaScript(BOrd.make((String)"module://smartTableHx/rc/smartTable.js"));
        op.addJavaScript(BOrd.make((String)"module://smartTableHx/rc/save.js"));
        BHxSmartTableView.writeFormValue("colorToSave", value.toString(), op);
        out.w((Object)"<span");
        this.scope("colorToShow", out, op);
        if (value != null) {
            out.w((Object)"style=' border: 1px solid black; ");
            if (op.canWrite()) {
                out.w((Object)"cursor: pointer; ");
            } else {
                out.w((Object)"cursor: default; ");
            }
            out.w((Object)"background-color: ").w((Object)value.toHtmlString()).w((Object)"' ");
        }
        if (op.canWrite()) {
            out.w((Object)"onclick='").w((Object)browse.getInvokeCode(op)).w((Object)"'");
        }
        out.w((Object)">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        out.w((Object)"</span>");
    }

    public BObject save(HxOp op) throws Exception {
        String image = op.getFormValue("colorToSave");
        if (op.get() instanceof BColor) {
            return BColor.make((String)image);
        }
        return BString.make((String)image);
    }

    public HtmlWriter scope(String name, HtmlWriter out, HxOp op) {
        out.w((Object)" name='").w((Object)op.scope(name)).w((Object)"'");
        out.w((Object)" id='").w((Object)op.scope(name)).w((Object)"' ");
        return out;
    }

    class HueCompare
    implements Comparator<BColor> {
        @Override
        public int compare(BColor e1, BColor e2) {
            double[] hsb2;
            double[] hsb = ColorUtil.toHsb((BColor)e1);
            if (hsb[0] - (hsb2 = ColorUtil.toHsb((BColor)e2))[0] > 0.05) {
                return 1;
            }
            if (hsb[0] - hsb2[0] < -0.05) {
                return -1;
            }
            if (hsb[1] - hsb2[1] > 0.05) {
                return 1;
            }
            if (hsb[1] - hsb2[1] < -0.05) {
                return -1;
            }
            if (hsb[2] - hsb2[2] < 0.0) {
                return 1;
            }
            if (hsb[2] - hsb2[2] > 0.0) {
                return -1;
            }
            return 0;
        }
    }

    class BrowseDialog
    extends Dialog {
        public BrowseDialog(LexiconModule lex, String key, Command handler) {
            super(lex, key, handler);
        }

        protected void writeContent(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            BColor startingColor = BColor.make((String)op.getFormValue("colorToSave"));
            BColor[] colors = BHxColorFE.this.defaultColorList;
            BHxSmartTableView.writeFormValue("previewToSave", op.getFormValue("colorToSave"), op);
            BHxSmartTableView.writeFormValue("mouseDown", "false", op);
            out.w((Object)"<table style='width: 400px;'><tr><td rowspan='3' valign='top' align='left'>");
            for (int j = 0; j < 8; ++j) {
                for (int k = 0; k < 8; ++k) {
                    out.w((Object)"<span style='padding: 0px; margin: 0px border: 0px ;");
                    out.w((Object)"cursor: pointer; ");
                    out.w((Object)"background-color: ").w((Object)colors[k + 8 * j].toHtmlString()).w((Object)"; ");
                    out.w((Object)"padding: 0px; margin: 0px;");
                    out.w((Object)"border-top: 1px solid black; ");
                    out.w((Object)"border-left: 1px solid black; ");
                    if (k == 7) {
                        out.w((Object)"border-right: 1px solid black; ");
                    }
                    if (j == 7) {
                        out.w((Object)"border-bottom: 1px solid black; ");
                    }
                    out.w((Object)"-moz-user-select: none;");
                    out.w((Object)"-khtml-user-select: none; ");
                    out.w((Object)"user-select: none; ");
                    out.w((Object)"-ms-user-select: none;");
                    out.w((Object)"'");
                    out.w((Object)" unselectable='on' ");
                    out.w((Object)" onclick='");
                    out.w((Object)"document.getElementById(&quot;").w((Object)op.scope("preview"));
                    out.w((Object)"&quot;).style.backgroundColor=&quot;").w((Object)colors[k + 8 * j].toHtmlString()).w((Object)"&quot;;");
                    out.w((Object)"document.getElementById(&quot;").w((Object)op.scope("previewToSave"));
                    out.w((Object)"&quot;).value=&quot;").w((Object)colors[k + 8 * j].toHtmlString()).w((Object)"&quot;;");
                    out.w((Object)"'>&nbsp;&nbsp;&nbsp;");
                    out.w((Object)"</span>");
                }
                out.w((Object)"<br/>");
            }
            out.w((Object)"</td><td style='white-space: nowrap;' rowspan='3' >");
            int width = 24;
            int height = 24;
            int s = 4;
            out.w((Object)"<div align='left'");
            BHxColorFE.this.scope("gradientDiv", out, op);
            out.w((Object)"style='width: ").w(width * s).w((Object)"px; height: ").w(height * s).w((Object)"px;'");
            out.w((Object)">");
            out.w((Object)"</div>");
            out.w((Object)"</td><td align='right' valign='top'>");
            out.w((Object)"<div style='width: 40px; height: 40px;");
            out.w((Object)"background-color: ").w((Object)startingColor.toHtmlString()).w((Object)"; ");
            out.w((Object)"; border: 1px solid black; cursor: pointer' ");
            BHxColorFE.this.scope("preview", out, op);
            out.w((Object)"onclick='color.createGradient(this.style.backgroundColor,&quot;").w((Object)op.scope("")).w((Object)"&quot;);' ");
            out.w((Object)"></div>");
            out.w((Object)"</td></tr><tr><td style='white-space: nowrap;'>&nbsp;");
            out.w((Object)"</td></tr>");
            out.w((Object)"<tr><td align='right'>");
            out.w((Object)"<table style='width: 100px;'>");
            out.w((Object)"<tr><td style='white-space: nowrap;' align='right' valign='bottom'>");
            out.w((Object)"<select style='width: 100px;' onclick='");
            out.w((Object)"document.getElementById(&quot;").w((Object)op.scope("preview"));
            out.w((Object)"&quot;).style.backgroundColor=this.value;");
            out.w((Object)"document.getElementById(&quot;").w((Object)op.scope("previewToSave"));
            out.w((Object)"&quot;).value=this.value;");
            out.w((Object)"'");
            out.w((Object)"name='").w((Object)op.scope("color")).w((Object)"'>");
            BColor[] sortedColors = BColor.getConstants();
            Arrays.sort(sortedColors, new HueCompare());
            for (int i = 0; i < sortedColors.length; ++i) {
                BColor color = sortedColors[i];
                out.w((Object)"<option value='").w((Object)color.toHtmlString()).w((Object)"' ");
                out.w((Object)"style=' background-color:").w((Object)color.toHtmlString());
                out.w((Object)"; color:").w((Object)color.toHtmlString()).w((Object)"' ");
                if (startingColor.equals((Object)color)) {
                    out.w((Object)"selected");
                }
                out.w((Object)">");
                out.safe((Object)color.encodeToString());
                out.w((Object)"</option>");
            }
            out.w((Object)"</select>");
            out.w((Object)"</td></tr></table>");
            out.w((Object)"</td></tr></table>");
        }
    }

    public class Browse
    extends Command {
        private BrowseDialog dialog;

        public Browse(BHxView view) {
            super(view);
            this.dialog = new BrowseDialog(lex, "colorPicker", this);
        }

        public String getInvokeCode(HxOp op) {
            StringBuffer b = new StringBuffer(super.getInvokeCode(op));
            b.append("color.path=\"").append(op.scope("")).append("\";");
            b.append("setTimeout(\"");
            b.append("color.createInitGradient()");
            b.append("\",250);");
            return b.toString();
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dialog.isSubmit(op)) {
                this.dialog.open(op);
                return;
            }
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"save.modified();");
            out.w((Object)"hx.setFormValue('").w((Object)op.scope("colorToSave")).w((Object)"',");
            out.w((Object)"'").w((Object)op.getFormValue("previewToSave")).w((Object)"');");
            out.w((Object)"document.getElementById('").w((Object)op.scope("colorToShow")).w((Object)"').");
            out.w((Object)"style.backgroundColor=");
            out.w((Object)"'").w((Object)op.getFormValue("previewToSave")).w((Object)"';");
            int index = op.getPath().lastIndexOf(".");
            if (index > -1) {
                String parentPath = op.getPath().substring(0, index);
                boolean background = op.getPath().indexOf("backgroundColor") > -1;
                out.w((Object)"try{");
                out.w((Object)"hx.$('");
                if (background) {
                    out.w((Object)parentPath).w((Object)".preview').style.backgroundColor=");
                } else {
                    out.w((Object)parentPath).w((Object)".preview').style.color=");
                }
                out.w((Object)"'").w((Object)op.getFormValue("previewToSave")).w((Object)"';");
                out.w((Object)"}catch(err){}");
            }
        }
    }
}

