/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.smartTableHx.export;

import com.tridium.bql.cursor.BogCursor;
import com.tridium.smartTableHx.TableContents;
import com.tridium.smartTableHx.export.BPdfStyle;
import com.tridium.smartTableHx.export.BPdfStylePickerFE;
import com.tridium.smartTableHx.export.BSmartTableToCsv;
import com.tridium.smartTableHx.export.BSmartTableToPdf;
import javax.baja.data.BIDataValue;
import javax.baja.file.BExporter;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BExportData
extends BComponent {
    private static BFacets options = BFacets.make((String)"lexicon", (String)Sys.getModuleForClass(BExportData.class).getModuleName());
    public static BEnumRange alignmentRange = BEnumRange.make(null, (int[])new int[]{0, 1}, (String[])new String[]{"landscape", "portrait"}, (int)2, (BFacets)options);
    public static BEnumRange fileTypeRange = BEnumRange.make(null, (int[])new int[]{0, 1}, (String[])new String[]{"pdf", "csv"}, (int)2, (BFacets)options);
    public static BEnumRange exportRangeRange = BEnumRange.make(null, (int[])new int[]{0, 1, 2}, (String[])new String[]{"all", "currentPage", "currentSelection"}, (int)3, (BFacets)options);
    public static final Property tableTitle = BExportData.newProperty((int)8, (String)"", (BFacets)BFacets.make((String)"allowNull", (boolean)false));
    public static final Property exportRange = BExportData.newProperty((int)0, (BValue)BDynamicEnum.make((int)0, (BEnumRange)exportRangeRange), (BFacets)BFacets.make((BFacets)BFacets.make((String)"range", (BIDataValue)exportRangeRange), (BFacets)BFacets.make((String)"preferFrozenEditor", (boolean)true)));
    public static final Property fileType = BExportData.newProperty((int)0, (BValue)BDynamicEnum.make((int)0, (BEnumRange)fileTypeRange), (BFacets)BFacets.make((BFacets)BFacets.make((String)"range", (BIDataValue)fileTypeRange), (BFacets)BFacets.make((String)"preferFrozenEditor", (boolean)true)));
    public static final Property alignment = BExportData.newProperty((int)8, (BValue)BDynamicEnum.make((int)0, (BEnumRange)alignmentRange), (BFacets)BFacets.make((BFacets)BFacets.make((String)"range", (BIDataValue)alignmentRange), (BFacets)BFacets.make((String)"preferFrozenEditor", (boolean)true)));
    public static final Property style = BExportData.newProperty((int)8, (String)"", (BFacets)BFacets.make((String)"fieldEditor", (String)BPdfStylePickerFE.TYPE.toString()));
    public static final Property includeHeaders = BExportData.newProperty((int)0, (boolean)true, null);
    public static final Property includeBOM = BExportData.newProperty((int)0, (boolean)true, null);
    public static final Property useCRLF = BExportData.newProperty((int)0, (boolean)false, (BFacets)BFacets.make((BFacets)BFacets.make((String)"trueText", (String)"%lexicon(file:useCRLF.trueText)%"), (BFacets)BFacets.make((String)"falseText", (String)"%lexicon(file:useCRLF.falseText)%")));
    public static final Property delimiter = BExportData.newProperty((int)0, (String)",", null);
    public static final Type TYPE = Sys.loadType(BExportData.class);
    private TableContents tableContents;
    private int maxResultsSize;

    public String getTableTitle() {
        return this.getString(tableTitle);
    }

    public void setTableTitle(String v) {
        this.setString(tableTitle, v, null);
    }

    public BDynamicEnum getExportRange() {
        return (BDynamicEnum)this.get(exportRange);
    }

    public void setExportRange(BDynamicEnum v) {
        this.set(exportRange, (BValue)v, null);
    }

    public BDynamicEnum getFileType() {
        return (BDynamicEnum)this.get(fileType);
    }

    public void setFileType(BDynamicEnum v) {
        this.set(fileType, (BValue)v, null);
    }

    public BDynamicEnum getAlignment() {
        return (BDynamicEnum)this.get(alignment);
    }

    public void setAlignment(BDynamicEnum v) {
        this.set(alignment, (BValue)v, null);
    }

    public String getStyle() {
        return this.getString(style);
    }

    public void setStyle(String v) {
        this.setString(style, v, null);
    }

    public boolean getIncludeHeaders() {
        return this.getBoolean(includeHeaders);
    }

    public void setIncludeHeaders(boolean v) {
        this.setBoolean(includeHeaders, v, null);
    }

    public boolean getIncludeBOM() {
        return this.getBoolean(includeBOM);
    }

    public void setIncludeBOM(boolean v) {
        this.setBoolean(includeBOM, v, null);
    }

    public boolean getUseCRLF() {
        return this.getBoolean(useCRLF);
    }

    public void setUseCRLF(boolean v) {
        this.setBoolean(useCRLF, v, null);
    }

    public String getDelimiter() {
        return this.getString(delimiter);
    }

    public void setDelimiter(String v) {
        this.setString(delimiter, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BExportData() {
    }

    public BExportData(String tableTitle) {
        this.setTableTitle(tableTitle);
    }

    public BExportData(String tableTitle, String style) {
        this(tableTitle);
        this.setStyle(style);
    }

    public BPdfStyle getResolvedStyle() {
        BogCursor c = new BogCursor((BComplex)Sys.getStation(), 10, new Type[]{BPdfStyle.TYPE}, true, null);
        while (c.next()) {
            BPdfStyle style = (BPdfStyle)c.get();
            if (!style.getName().equals(this.getStyle())) continue;
            return style;
        }
        return new BPdfStyle();
    }

    public boolean getLandscape() {
        return this.getAlignment().getOrdinal() == 0;
    }

    public String getTableTitleDisplay() {
        if (this.tableContents != null && this.tableContents.tr.size() == this.maxResultsSize) {
            return this.getTableTitle() + " (Top " + this.maxResultsSize + ")";
        }
        return this.getTableTitle();
    }

    public String getFileName() {
        return TextUtil.replace((String)this.getTableTitleDisplay(), (String)" ", (String)"_") + "." + this.getExporter().getFileExtension();
    }

    public String getMimeType() {
        if (this.isPdf()) {
            return "application/pdf";
        }
        return "text/csv";
    }

    public boolean isPdf() {
        return this.getFileType().getOrdinal() == 0;
    }

    public boolean isSinglePage() {
        return this.getExportRange().getOrdinal() == 1;
    }

    public boolean isCurrentSelection() {
        return this.getExportRange().getOrdinal() == 2;
    }

    public BExporter getExporter() {
        if (this.isPdf()) {
            return new BSmartTableToPdf();
        }
        BSmartTableToCsv csv = new BSmartTableToCsv();
        csv.setIncludeHeaders(this.getIncludeHeaders());
        csv.setIncludeBOM(this.getIncludeBOM());
        csv.setUseCRLF(this.getUseCRLF());
        csv.setDelimiter(this.getDelimiter());
        return csv;
    }

    public void setTableContents(TableContents tableContents, int maxResultsSize) {
        this.tableContents = tableContents;
        this.maxResultsSize = maxResultsSize;
    }

    public TableContents getTableContents() {
        return this.tableContents;
    }

    public int getMaxResultSize() {
        return this.maxResultsSize;
    }

    public void removeTableContents() {
        this.tableContents = null;
        this.maxResultsSize = -1;
    }
}

