/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.smartTableHx;

import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.fieldeditors.BHxSmartDefaultFE;
import com.tridium.smartTableHx.filter.BHxFilterEntryFE;
import com.tridium.smartTableHx.tab.BHxTabbedView;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.smartTableHx.tab.Tab;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.BHxView;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.sync.Transaction;
import javax.baja.sys.BAction;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BTopic;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;
import javax.baja.util.BWsAnnotation;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;

public class BHxFieldSheet
extends BHxTabbedView {
    public static final BHxFieldSheet INSTANCE = new BHxFieldSheet();
    public static final Type TYPE = Sys.loadType(BHxFieldSheet.class);
    public static final String TYPES_EXCLUDED = "typesExcluded";
    public static final String FIELD_EDITORS_PROVIDED = "fieldEditorsProvided";
    public static final String FIELDS_PROVIDED = "fieldsProvided";
    public static final String FIELD_NAMES_PROVIDED = "fieldNamesProvided";
    public static final String NO_TABLE_START = "noTableStart";
    public static final String SUMMARY = "summary";
    public static final String DEEP = "deep";
    public static final String USER_DEFINED_4 = "userDefined4";
    public static final String NO_MISSING_LOG = "noMissingLog";
    public static final BFacets noTableStart = BFacets.make((String)"noTableStart", (boolean)true);
    public static final BFacets userDefined4 = BFacets.make((String)"userDefined4", (boolean)true);
    public static final BFacets summary = BFacets.make((String)"summary", (boolean)true);
    public static final BFacets deep = BFacets.make((String)"deep", (boolean)true);
    public static final BFacets noMissingLog = BFacets.make((String)"noMissingLog", (boolean)true);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void write(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        boolean noTableStart = op.getFacets().getb(NO_TABLE_START, false);
        if (!noTableStart) {
            out.w((Object)"<table ").attr("id", op.scope("container")).w((Object)">");
        }
        Tab[] tabs = this.getTabs(op);
        for (int i = 0; i < tabs.length; ++i) {
            this.writeRow(tabs[i], out, op);
        }
        if (!noTableStart) {
            out.w((Object)"</table>");
        }
    }

    public void writeRow(Tab tab, HtmlWriter out, HxOp op) throws Exception {
        out.w((Object)"<tr ");
        out.attr("id", tab.op.getPath());
        out.attr(" name", tab.op.getPath());
        out.w((Object)"><td class='smartTable-setup-label'>");
        out.safe((Object)SlotPath.unescape((String)tab.title));
        out.w((Object)"</td>");
        out.w((Object)"<td>");
        tab.write();
        out.w((Object)"</td></tr>");
    }

    public void saveRow(Tab tab, Context tx, HxOp op) throws Exception {
        if (!(tab instanceof PropertyTab)) {
            return;
        }
        Property prop = ((PropertyTab)tab).property;
        BComplex parent = ((PropertyTab)tab).parent;
        try {
            BHxView ed = tab.view;
            HxOp fieldOp = tab.op;
            BValue newValue = null;
            newValue = ed instanceof BHxFieldEditor ? (BValue)((BHxFieldEditor)ed).fwSave(fieldOp) : (BValue)ed.save(fieldOp);
            if (!newValue.equals((Object)fieldOp.get())) {
                if (parent instanceof BComponent && ((BComponent)parent).isMounted() && parent.asComponent().getHandle() instanceof String) {
                    parent.set(prop, newValue, (Context)op);
                } else {
                    parent.set(prop, newValue, null);
                }
            }
        }
        catch (Exception e) {
            HtmlWriter out = op.getHtmlWriter();
            String errorText = e.getLocalizedMessage();
            SmartCommand.exception(tab.op.getPath(), errorText, op);
            op.getRequest().getSession().setAttribute(tab.op.scope("saveError"), (Object)tab.op.getPath());
            if (e instanceof CannotSaveException) {
                throw e;
            }
            throw new CannotSaveException(e.getMessage(), (Throwable)e);
        }
        String errorPath = (String)op.getRequest().getSession().getAttribute(tab.op.scope("saveError"));
        if (errorPath != null) {
            HtmlWriter out = op.getHtmlWriter();
            SmartCommand.clearException(errorPath, op);
            op.getRequest().getSession().removeAttribute(tab.op.scope("saveError"));
        }
    }

    @Override
    public BObject save(HxOp op) throws Exception {
        HxOp tx = op;
        if (op.get() instanceof BComponent) {
            tx = Transaction.start((BComponent)((BComponent)op.get()), (Context)op);
        }
        BComplex obj = (BComplex)op.get();
        Tab[] tabs = this.getTabs(op);
        for (int i = 0; i < tabs.length; ++i) {
            this.saveRow(tabs[i], (Context)tx, op);
        }
        if (op.get() instanceof BComponent) {
            Transaction.end((BComponent)((BComponent)op.get()), (Context)tx);
        }
        return obj;
    }

    @Override
    public Tab[] getTabs(HxOp op) {
        boolean fieldsProvided;
        ArrayList<Tab> tabs = new ArrayList<Tab>();
        BComplex obj = (BComplex)op.get();
        boolean bl = fieldsProvided = op.getFacets().get(FIELDS_PROVIDED) != null;
        if (!fieldsProvided || op.getFacets().getb(SUMMARY, false) || op.getFacets().getb(USER_DEFINED_4, false)) {
            this.addTabs(obj, tabs, op);
        }
        if (fieldsProvided) {
            this.addMatchedTabs(obj, tabs, op);
            fieldsProvided = true;
        }
        return tabs.toArray(new Tab[tabs.size()]);
    }

    public void logMissingProperty(String fieldToMatch, Type type, HxOp op) {
        if (!op.getFacets().getb(NO_MISSING_LOG, false)) {
            BHxView.log.log(Level.SEVERE, "BHxFieldSheet: '" + fieldToMatch + "' is not a property in '" + type + "'");
        }
    }

    public void addMatchedTabs(BComplex obj, List<Tab> tabs, HxOp op) {
        String[] fieldsToMatch = TextUtil.split((String)op.getFacets().get(FIELDS_PROVIDED).toString(), (char)'|');
        String[] fieldNames = new String[fieldsToMatch.length];
        if (op.getFacets().get(FIELD_NAMES_PROVIDED) != null) {
            fieldNames = TextUtil.split((String)op.getFacets().get(FIELD_NAMES_PROVIDED).toString(), (char)'|');
        }
        String[] fieldEditors = new String[fieldsToMatch.length];
        if (op.getFacets().get(FIELD_EDITORS_PROVIDED) != null) {
            fieldEditors = TextUtil.split((String)op.getFacets().get(FIELD_EDITORS_PROVIDED).toString(), (char)'|');
        }
        for (int i = 0; i < fieldsToMatch.length; ++i) {
            String fieldToMatch = fieldsToMatch[i];
            if (fieldToMatch.indexOf(".") == -1) {
                Property p = obj.getProperty(fieldToMatch);
                if (p == null) {
                    this.logMissingProperty(fieldToMatch, obj.getType(), op);
                    continue;
                }
                this.addTab(obj, p, obj.get(p), tabs, fieldNames[i], fieldEditors[i], op);
                continue;
            }
            HxOp currentOp = op;
            BComplex currentParent = obj;
            Property currentProperty = null;
            String[] split = TextUtil.split((String)fieldToMatch, (char)'.');
            boolean brokenEarly = false;
            for (int j = 0; j < split.length - 1; ++j) {
                currentProperty = currentParent.getProperty(split[j]);
                BValue currentValue = currentParent.get(split[j]);
                if (currentValue == null) {
                    this.logMissingProperty(split[j], currentParent.getType(), op);
                    brokenEarly = true;
                    break;
                }
                currentParent = currentValue.asComplex();
                OrdTarget target = new OrdTarget((OrdTarget)currentOp, (BObject)currentValue);
                boolean readonly = !currentOp.canWrite();
                currentOp = currentParent instanceof BComponent && ((BComponent)currentParent).isMounted() && target.getSecurityTarget() == obj ? currentOp.make(currentProperty.getName(), target).mergeFacets(currentParent.getSlotFacets((Slot)currentProperty)) : currentOp.make(currentProperty.getName(), (BObject)currentValue, currentParent.getSlotFacets((Slot)currentProperty));
                if (!readonly) continue;
                currentOp.setReadonly(true);
            }
            if (brokenEarly) continue;
            Property p = currentParent.getProperty(split[split.length - 1]);
            if (p == null) {
                this.logMissingProperty(fieldToMatch, currentParent.getType(), op);
                continue;
            }
            this.addTab(currentParent, p, currentParent.get(p), tabs, fieldNames[i], fieldEditors[i], currentOp);
        }
    }

    public void addTabs(BComplex obj, List<Tab> tabs, HxOp op) {
        this.addTabs(obj, tabs, op, false, null);
    }

    public void addTabs(BComplex obj, List<Tab> tabs, HxOp op, boolean inDeep, HxOp parentOp) {
        Type[] typesExcluded = null;
        if (op.getFacets().get(TYPES_EXCLUDED) != null) {
            String[] ex = TextUtil.split((String)op.getFacets().get(TYPES_EXCLUDED).toString(), (char)'|');
            typesExcluded = new Type[ex.length];
            for (int i = 0; i < ex.length; ++i) {
                typesExcluded[i] = BTypeSpec.make((String)ex[i]).getResolvedType();
            }
        }
        Property[] props = obj.getPropertiesArray();
        boolean summary = op.getFacets().getb(SUMMARY, false);
        boolean userDefined4 = op.getFacets().getb(USER_DEFINED_4, false);
        boolean deep = op.getFacets().getb(DEEP, false);
        boolean deepFound = false;
        for (int i = 0; i < props.length; ++i) {
            Property prop = props[i];
            BValue propValue = obj.get(prop);
            if (propValue instanceof BLink || propValue instanceof BWsAnnotation || propValue instanceof BAction || propValue instanceof BTopic || Flags.isHidden((BComplex)obj, (Slot)prop) || prop.getDefaultValue().getType().equals(BUuid.TYPE) || userDefined4 && !Flags.isUserDefined4((BComplex)obj, (Slot)prop) || summary && !Flags.isSummary((BComplex)obj, (Slot)prop)) continue;
            boolean excluded = false;
            for (int j = 0; typesExcluded != null && j < typesExcluded.length; ++j) {
                if (!prop.getDefaultValue().getType().is(typesExcluded[j])) continue;
                excluded = true;
            }
            if (excluded) continue;
            deepFound = true;
            if (propValue instanceof BSimple || !deep) {
                this.addTab(obj, prop, propValue, tabs, op);
                continue;
            }
            if (!deep || !(propValue instanceof BComplex)) continue;
            HxOp fieldOp = op.make(prop.getName(), (BObject)propValue, op.getFacets());
            SmartCommand.matchReadonly(fieldOp, op);
            this.addTabs((BComplex)propValue, tabs, fieldOp, true, op);
        }
        if (deep && !deepFound && inDeep) {
            this.addTab(obj.getParent(), obj.getPropertyInParent(), (BValue)obj, tabs, parentOp);
        }
    }

    public void addTab(BComplex obj, Property prop, BValue propValue, List<Tab> tabs, HxOp op) {
        this.addTab(obj, prop, propValue, tabs, null, null, op);
    }

    public void addTab(BComplex obj, Property prop, BValue propValue, List<Tab> tabs, String displayName, String fieldEditor, HxOp op) {
        if (propValue instanceof BWsAnnotation) {
            return;
        }
        if (Flags.isHidden((BComplex)obj, (Slot)prop)) {
            return;
        }
        BHxFieldEditor ed = this.makeFor(obj, prop, propValue, fieldEditor, op);
        OrdTarget target = new OrdTarget((OrdTarget)op, (BObject)propValue);
        HxOp fieldOp = null;
        Lexicon lex = op.getLexicon(Sys.getModuleForClass(obj.getClass()).getModuleName());
        String propName = prop.getName();
        if (displayName == null) {
            String entryText = obj.getType().getTypeName() + "." + prop.getName();
            displayName = HxTabUtil.getDisplayName(entryText, obj.getDisplayName((Slot)prop, (Context)op), new Object[]{obj.getDisplayName((Slot)prop, (Context)op)}, lex, null, op);
        }
        if (op.get() != obj) {
            propName = obj.getName() + "." + propName;
        }
        if (ed instanceof BHxFilterEntryFE) {
            displayName = "";
        }
        fieldOp = obj instanceof BComponent && ((BComponent)obj).isMounted() && target.getSecurityTarget() == obj ? op.make(propName, target).mergeFacets(obj.getSlotFacets((Slot)prop)) : op.make(propName, (BObject)propValue, obj.getSlotFacets((Slot)prop));
        fieldOp.setReadonly(Flags.isReadonly((BComplex)obj, (Slot)prop));
        SmartCommand.matchReadonly(fieldOp, op);
        tabs.add(new PropertyTab((BHxView)ed, displayName, fieldOp, prop, obj));
    }

    public static String getLexiconText(String lexiconKey) {
        return Sys.getRegistry().getDef("manageDevices.lexicon." + lexiconKey);
    }

    public static String getLexiconText(String lexiconKey, Object[] args) {
        String value = Sys.getRegistry().getDef("manageDevices.lexicon." + lexiconKey);
        if (value == null) {
            return lexiconKey;
        }
        return MessageFormat.format(value, args);
    }

    public BHxFieldEditor makeFor(BComplex obj, Property prop, BValue propValue, String fieldEditor, HxOp op) {
        BFacets slotFacets = obj.getSlotFacets((Slot)prop);
        if (fieldEditor != null && !fieldEditor.equals("null")) {
            slotFacets = BFacets.make((BFacets)slotFacets, (String)"fieldEditor", (BIDataValue)BString.make((String)fieldEditor));
        }
        try {
            return BHxFieldEditor.makeFor((BObject)propValue, (Context)slotFacets);
        }
        catch (Exception e) {
            try {
                return BHxFieldEditor.makeFor((BObject)propValue, (Context)op);
            }
            catch (Exception ee) {
                return BHxSmartDefaultFE.INSTANCE;
            }
        }
    }

    public static BFacets getTypesExcludedFacets(String[] fieldList) {
        if (fieldList.length > 0) {
            String join = TextUtil.join((String[])fieldList, (char)'|');
            return BFacets.make((String)TYPES_EXCLUDED, (String)join);
        }
        return BFacets.DEFAULT;
    }

    public static BFacets getFieldsProvidedFacets(String[] fieldList) {
        String join = TextUtil.join((String[])fieldList, (char)'|');
        return BFacets.make((String)FIELDS_PROVIDED, (String)join);
    }

    public static BFacets getFieldNamesProvidedFacets(String[] fieldList) {
        String join = TextUtil.join((String[])fieldList, (char)'|');
        return BFacets.make((String)FIELD_NAMES_PROVIDED, (String)join);
    }

    public static BFacets getFieldEditorsProvidedFacets(String[] fieldList) {
        String join = TextUtil.join((String[])fieldList, (char)'|');
        return BFacets.make((String)FIELD_EDITORS_PROVIDED, (String)join);
    }

    public class PropertyTab
    extends Tab {
        public Property property;
        public BComplex parent;

        public PropertyTab(BHxView view, String title, HxOp op, Property property, BComplex parent) {
            super(view, title, op);
            this.property = property;
            this.parent = parent;
        }
    }
}

