/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.flexSerial.messages;

import com.tridium.flexSerial.BFlexSerialNetwork;
import com.tridium.flexSerial.messages.BFlexMessageBlock;
import com.tridium.flexSerial.messages.BFlexRequestMessage;
import com.tridium.flexSerial.messages.FlexOutputStream;
import com.tridium.flexSerial.messages.SerialMessage;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BFlexSendMessage
extends BFlexRequestMessage {
    public static final Property enable = BFlexSendMessage.newProperty((int)0, (BValue)new BStatusBoolean(true), null);
    public static final Property faultCause = BFlexSendMessage.newProperty((int)3, (String)"", null);
    public static final Property timestamp = BFlexSendMessage.newProperty((int)3, (BValue)BAbsTime.NULL, null);
    public static final Action send = BFlexSendMessage.newAction((int)16, null);
    public static final Type TYPE = Sys.loadType(BFlexSendMessage.class);

    public BStatusBoolean getEnable() {
        return (BStatusBoolean)this.get(enable);
    }

    public void setEnable(BStatusBoolean v) {
        this.set(enable, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BAbsTime getTimestamp() {
        return (BAbsTime)this.get(timestamp);
    }

    public void setTimestamp(BAbsTime v) {
        this.set(timestamp, (BValue)v, null);
    }

    public void send() {
        this.invoke(send, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void doSend() {
        if (!this.getEnable().getBoolean()) {
            return;
        }
        BFlexMessageBlock msg = (BFlexMessageBlock)this.get("instance");
        if (msg == null) {
            this.doCreateInstance();
        }
        if ((msg = (BFlexMessageBlock)this.get("instance")) == null) {
            this.setFaultCause("RequestMessage instance not found.");
            return;
        }
        BComplex parent = this.getParent();
        if (parent == null || !(parent instanceof BFlexSerialNetwork)) {
            this.setFaultCause("Parent not a flex serial network.");
            return;
        }
        BFlexSerialNetwork network = (BFlexSerialNetwork)parent;
        FlexOutputStream out = new FlexOutputStream();
        msg.writeTo((BObject)this, out);
        this.setByteArray(BBlob.make((byte[])out.toByteArray()));
        SerialMessage sendReq = new SerialMessage(out.toByteArray());
        sendReq.setResponseExpected(false);
        network.sendSync(sendReq);
        this.setFaultCause("");
        this.setTimestamp(Clock.time());
    }

    @Override
    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
    }
}

