/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.flexSerial.messages;

import com.tridium.flexSerial.enums.BDataTypeEnum;
import com.tridium.flexSerial.enums.BEncodeTypeEnum;
import com.tridium.flexSerial.messages.BFlexMessageSelect;
import com.tridium.flexSerial.messages.BIFlexMessageBlock;
import com.tridium.flexSerial.messages.BIFlexMessageElement;
import com.tridium.flexSerial.messages.FlexInputStream;
import com.tridium.flexSerial.messages.FlexOutputStream;
import com.tridium.program.BProgram;
import java.text.DecimalFormat;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.sys.BBlob;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.DuplicateSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;

public abstract class BFlexMessageElement
extends BComponent
implements BIFlexMessageElement {
    public static final Property offset = BFlexMessageElement.newProperty((int)1, (int)0, null);
    public static final Property size = BFlexMessageElement.newProperty((int)1, (int)1, null);
    public static final Property dataType = BFlexMessageElement.newProperty((int)0, (BValue)BDataTypeEnum.Byte, null);
    public static final Property source = BFlexMessageElement.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property exposeInParent = BFlexMessageElement.newProperty((int)0, (boolean)false, null);
    public static final Property value = BFlexMessageElement.newProperty((int)0, (BValue)BInteger.make((int)0), null);
    public static final Property encode = BFlexMessageElement.newProperty((int)0, (BValue)BEncodeTypeEnum.None, null);
    public static final Property facets = BFlexMessageElement.newProperty((int)0, (BValue)BFacets.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"flexSerial:FlexFacetsFE")));
    public static final Type TYPE = Sys.loadType(BFlexMessageElement.class);
    private static final BIcon icon = BIcon.make((String)"module://flexSerial/com/tridium/flexSerial/icons/flexMessageElement.png");
    public static String BIG_ENDIAN = "bigEndian";
    public static String ACTIVE_VALUE = "activeValue";
    public static String INACTIVE_VALUE = "inactiveValue";
    public static String ACTIVE_TEXT = "activeText";
    public static String INACTIVE_TEXT = "inactiveText";
    public static String PAD_WITH = "padWith";
    public static String NULL_TERMINATE = "nullTerminate";
    public static String DECIMAL_FORMAT = "decimalFormat";
    public static String FIELD_WIDTH = "fieldWidth";
    public static String MAX = "max";
    public static String MIN = "min";
    public static String SHOW_ASCII = "showAscii";
    public static String CKSUM_START_MARKER_NAME = "cksumStart";

    @Override
    public int getOffset() {
        return this.getInt(offset);
    }

    @Override
    public void setOffset(int v) {
        this.setInt(offset, v, null);
    }

    @Override
    public int getSize() {
        return this.getInt(size);
    }

    public void setSize(int v) {
        this.setInt(size, v, null);
    }

    public BDataTypeEnum getDataType() {
        return (BDataTypeEnum)this.get(dataType);
    }

    public void setDataType(BDataTypeEnum v) {
        this.set(dataType, (BValue)v, null);
    }

    public BOrd getSource() {
        return (BOrd)this.get(source);
    }

    public void setSource(BOrd v) {
        this.set(source, (BValue)v, null);
    }

    public boolean getExposeInParent() {
        return this.getBoolean(exposeInParent);
    }

    public void setExposeInParent(boolean v) {
        this.setBoolean(exposeInParent, v, null);
    }

    public BValue getValue() {
        return this.get(value);
    }

    public void setValue(BValue v) {
        this.set(value, v, null);
    }

    public BEncodeTypeEnum getEncode() {
        return (BEncodeTypeEnum)this.get(encode);
    }

    public void setEncode(BEncodeTypeEnum v) {
        this.set(encode, (BValue)v, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)value)) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    public void changed(Property property, Context context) {
        if (this.isRunning()) {
            if (property.equals(value)) {
                this.exposeInParent();
            }
            if (context != null && context.equals(Context.decoding)) {
                this.exposeInParent();
                return;
            }
        }
        if (property.equals(dataType) || property.equals(source)) {
            switch (this.getDataType().getOrdinal()) {
                case 0: {
                    this.setValue((BValue)BInteger.make((int)0));
                    this.setSize(1);
                    break;
                }
                case 1: {
                    this.setValue((BValue)BInteger.make((int)0));
                    this.setSize(2);
                    break;
                }
                case 2: {
                    this.setValue((BValue)BInteger.make((int)0));
                    this.setSize(4);
                    break;
                }
                case 3: {
                    this.setValue((BValue)BFloat.make((float)0.0f));
                    this.setSize(4);
                    break;
                }
                case 4: {
                    this.setValue((BValue)BString.make((String)""));
                    break;
                }
                case 5: {
                    this.setValue((BValue)BString.make((String)""));
                    this.setSize(0);
                }
            }
        } else if ((property.equals(value) || property.equals(facets)) && this.getDataType().equals((Object)BDataTypeEnum.String)) {
            this.setSize(this.convertInputToString((BObject)this.getValue()).length());
        }
        BIFlexMessageBlock pmc = this.getParentMessageComponent();
        if (pmc != null) {
            pmc.calculateItemOffsets();
        }
    }

    protected void exposeInParent() {
        BComplex ggParent;
        if (this.getExposeInParent() && (ggParent = this.getParent().getParent()) instanceof BFlexMessageSelect) {
            BFlexMessageSelect parentResp = (BFlexMessageSelect)ggParent;
            String valueName = this.getName();
            BStatusNumeric newValue = new BStatusNumeric();
            BValue rawValue = this.getValue().newCopy();
            switch (this.getDataType().getOrdinal()) {
                case 0: 
                case 1: 
                case 2: {
                    int rawInt = ((BInteger)rawValue).getInt();
                    int activeValue = this.getFacets().geti(ACTIVE_VALUE, -1);
                    int inactiveValue = this.getFacets().geti(INACTIVE_VALUE, -1);
                    if (activeValue != -1) {
                        newValue = new BStatusBoolean(rawInt == activeValue);
                        break;
                    }
                    if (inactiveValue != -1) {
                        newValue = new BStatusBoolean(rawInt != inactiveValue);
                        break;
                    }
                    newValue = new BStatusNumeric((double)rawInt);
                    break;
                }
                case 4: {
                    String rawString = ((BString)rawValue).getString();
                    String activeText = this.getFacets().gets(ACTIVE_TEXT, null);
                    String inactiveText = this.getFacets().gets(INACTIVE_TEXT, null);
                    if (activeText != null) {
                        newValue = new BStatusBoolean(rawString.equals(activeText));
                        break;
                    }
                    if (inactiveText != null) {
                        newValue = new BStatusBoolean(!rawString.equals(inactiveText));
                        break;
                    }
                    newValue = new BStatusString(((BString)rawValue).getString());
                    break;
                }
                case 3: {
                    if (rawValue instanceof BStatusNumeric) {
                        newValue = (BStatusNumeric)rawValue;
                        break;
                    }
                    if (rawValue instanceof BDouble) {
                        newValue = new BStatusNumeric(((BDouble)rawValue).getDouble());
                        break;
                    }
                    if (!(rawValue instanceof BFloat)) break;
                    newValue = new BStatusNumeric(((BFloat)rawValue).getDouble());
                }
            }
            try {
                parentResp.add(valueName, (BValue)newValue, 9);
            }
            catch (DuplicateSlotException e) {
                parentResp.set(valueName, (BValue)newValue);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected BIFlexMessageBlock getParentMessageComponent() {
        for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof BIFlexMessageBlock)) continue;
            return (BIFlexMessageBlock)parent;
        }
        return null;
    }

    @Override
    public void readFrom(BObject baseObj, FlexInputStream inBytes) {
        this.readFromDirect(baseObj, inBytes);
    }

    public void readFromDirect(BObject baseObj, FlexInputStream inBytes) {
        try {
            switch (this.getDataType().getOrdinal()) {
                case 0: {
                    this.set(value, (BValue)BInteger.make((int)(inBytes.read(this.getEncode(), this.getFacets()) & 0xFF)), Context.decoding);
                    break;
                }
                case 1: {
                    this.set(value, (BValue)BInteger.make((int)inBytes.readWord(this.getEncode(), this.getFacets())), Context.decoding);
                    break;
                }
                case 2: {
                    this.set(value, (BValue)BInteger.make((int)inBytes.readInt(this.getSize(), this.getEncode(), this.getFacets())), Context.decoding);
                    break;
                }
                case 4: {
                    this.set(value, (BValue)BString.make((String)inBytes.readString(this.getEncode(), this.getFacets())), Context.decoding);
                    break;
                }
                case 3: {
                    this.set(value, (BValue)BFloat.make((float)inBytes.readFloat(this.getEncode(), this.getFacets())), Context.decoding);
                    break;
                }
            }
        }
        catch (Exception e) {
            System.out.println(" ******************** invalid data type conversion *************");
            System.out.println("source object type = " + baseObj.getType());
            switch (this.getDataType().getOrdinal()) {
                default: 
            }
        }
    }

    public void readFromIndirect(BObject baseObj, FlexInputStream inBytes) {
        BOrd sourceOrd = this.getSource();
        BObject sourceObj = sourceOrd.get(baseObj);
        this.readFrom(inBytes, baseObj);
    }

    public void readFrom(FlexInputStream inBytes, BObject object) {
        try {
            switch (this.getDataType().getOrdinal()) {
                case 0: {
                    if (!(object instanceof BStatusNumeric)) break;
                    ((BStatusNumeric)object).setValue((double)(inBytes.read(this.getEncode(), this.getFacets()) & 0xFF));
                    break;
                }
            }
        }
        catch (Exception e) {
            System.out.println(" ******************** invalid data type conversion *************");
            System.out.println("source object type = " + object.getType());
            switch (this.getDataType().getOrdinal()) {
                default: 
            }
        }
    }

    @Override
    public void writeTo(BObject baseObj, FlexOutputStream out) {
        if (this.isIndirect()) {
            this.writeToIndirect(baseObj, out);
        } else {
            this.writeToDirect(baseObj, out);
        }
    }

    public void writeToDirect(BObject baseObj, FlexOutputStream out) {
        this.writeTo(out, (BObject)this.getValue());
    }

    public void writeToIndirect(BObject baseObj, FlexOutputStream out) {
        BOrd sourceOrd = this.getSource();
        BObject sourceObj = sourceOrd.get(baseObj);
        if (sourceObj instanceof BProgram) {
            BProgram program = (BProgram)sourceObj;
            program.set("byteArray", (BValue)BBlob.make((byte[])out.toByteArray()));
            program.set("offset", (BValue)BInteger.make((int)out.getCksumStart()));
            program.doExecute();
            this.writeTo(out, (BObject)program.get("cksumResults"));
            this.setValue(program.get("cksumResults"));
        } else {
            this.writeTo(out, sourceObj);
            if (sourceObj instanceof BComplex) {
                this.set(value, ((BComplex)sourceObj).newCopy(), Context.decoding);
            } else {
                this.set(value, (BValue)sourceObj, Context.decoding);
            }
        }
    }

    public void writeTo(FlexOutputStream out, BObject object) {
        try {
            switch (this.getDataType().getOrdinal()) {
                case 0: {
                    out.write(this.convertInputToInt(object), this.getEncode(), this.getFacets());
                    break;
                }
                case 1: {
                    out.writeInt(this.convertInputToInt(object), 2, this.getEncode(), this.getFacets());
                    break;
                }
                case 2: {
                    out.writeInt(this.convertInputToInt(object), this.getSize(), this.getEncode(), this.getFacets());
                    break;
                }
                case 3: {
                    out.writeInt(Float.floatToIntBits(this.convertInputToFloat(object)), 4, this.getEncode(), this.getFacets());
                    this.setSize(4);
                    break;
                }
                case 4: {
                    out.writeString(this.convertInputToString(object), this.getEncode(), this.getFacets());
                    if (!this.getFacets().getb(NULL_TERMINATE, false)) break;
                    out.write(0);
                    break;
                }
                case 5: {
                    if (!this.getName().equals(CKSUM_START_MARKER_NAME)) break;
                    out.setCksumStart(out.size());
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(" ******************** invalid data type conversion *************");
            System.out.println("source object type = " + object.getType());
            switch (this.getDataType().getOrdinal()) {
                case 0: {
                    out.write(-1);
                    break;
                }
                case 1: {
                    out.writeInt(-1, 2, this.getEncode(), this.getFacets());
                    break;
                }
                case 2: {
                    out.writeInt(-1, this.getSize(), this.getEncode(), this.getFacets());
                    break;
                }
                case 3: {
                    out.writeInt(Float.floatToIntBits(Float.NaN), 4, this.getEncode(), this.getFacets());
                    this.setSize(4);
                    break;
                }
                case 4: {
                    out.writeString("Invalid", this.getEncode(), this.getFacets());
                    break;
                }
            }
        }
    }

    @Override
    public int getMarker(String markerName) {
        if (this.getName().equals(markerName)) {
            return this.getOffset();
        }
        return -1;
    }

    public boolean isIndirect() {
        return !this.getSource().equals((Object)BOrd.NULL);
    }

    public String toString(Context cx) {
        return this.getValue().toString(cx);
    }

    public int convertInputToInt(BObject inputObject) {
        try {
            if (inputObject instanceof BString) {
                return BInteger.decode((String)((BString)inputObject).getString());
            }
            if (inputObject instanceof BInteger) {
                return ((BInteger)inputObject).getInt();
            }
            if (inputObject instanceof BFloat) {
                return (int)((BFloat)inputObject).getFloat();
            }
            if (inputObject instanceof BDouble) {
                return (int)((BDouble)inputObject).getDouble();
            }
            if (inputObject instanceof BBoolean) {
                int activeValue = 1;
                int inactiveValue = 0;
                BObject activeFacet = this.getFacets().getFacet(ACTIVE_VALUE);
                try {
                    activeValue = ((BInteger)activeFacet).getInt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                BObject inactiveFacet = this.getFacets().getFacet(INACTIVE_VALUE);
                try {
                    inactiveValue = ((BInteger)inactiveFacet).getInt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (((BBoolean)inputObject).getBoolean()) {
                    return activeValue;
                }
                return inactiveValue;
            }
            if (inputObject instanceof BEnum) {
                return ((BEnum)inputObject).getOrdinal();
            }
            return 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public float convertInputToFloat(BObject inputObject) {
        try {
            if (inputObject instanceof BString) {
                return BFloat.decode((String)((BString)inputObject).getString());
            }
            if (inputObject instanceof BNumber) {
                return ((BNumber)inputObject).getFloat();
            }
        }
        catch (Exception e) {
            return 0.0f;
        }
        return 0.0f;
    }

    public String convertInputToString(BObject inputObject) {
        try {
            String returnString = "";
            if (inputObject instanceof BString) {
                return ((BString)inputObject).getString();
            }
            if (inputObject instanceof BNumber) {
                BNumber inputNumber = (BNumber)inputObject;
                BFacets facets = this.getFacets();
                String decimalFormat = facets.gets(DECIMAL_FORMAT, "");
                int padWith = facets.geti(PAD_WITH, -1);
                int fieldWidth = facets.geti(FIELD_WIDTH, -1);
                float maxValue = facets.getf(MAX, Float.POSITIVE_INFINITY);
                float minValue = facets.getf(MIN, Float.NEGATIVE_INFINITY);
                boolean nullTerminate = facets.getb(NULL_TERMINATE, false);
                double dValue = inputNumber.getNumeric();
                if (dValue > (double)maxValue) {
                    dValue = maxValue;
                } else if (dValue < (double)minValue) {
                    dValue = minValue;
                }
                if (decimalFormat.length() > 0) {
                    if (dValue < 0.0 && decimalFormat.startsWith("0")) {
                        decimalFormat = decimalFormat.substring(1);
                    }
                    DecimalFormat format = new DecimalFormat(decimalFormat);
                    returnString = format.format(dValue);
                } else {
                    returnString = inputNumber.toString((Context)new DataContext(facets));
                }
                if (fieldWidth > 0) {
                    if (nullTerminate) {
                        --fieldWidth;
                    }
                    if (returnString.length() > fieldWidth) {
                        returnString = returnString.substring(0, fieldWidth);
                    }
                }
                return returnString;
            }
            if (inputObject instanceof BBoolean) {
                String activeText = this.getFacets().gets(ACTIVE_TEXT, "1");
                String inactiveText = this.getFacets().gets(INACTIVE_TEXT, "0");
                if (((BBoolean)inputObject).getBoolean()) {
                    return activeText;
                }
                return inactiveText;
            }
            if (inputObject instanceof BEnum) {
                return ((BEnum)inputObject).toString((Context)new DataContext(this.getFacets()));
            }
        }
        catch (Exception e) {
            return "";
        }
        return "";
    }

    public boolean getBooleanValue() {
        if (this.getValue() instanceof BString) {
            String thisValue = ((BString)this.getValue()).getString().trim();
            String trueText = this.getFacets().gets(ACTIVE_TEXT, "");
            String falseText = this.getFacets().gets(INACTIVE_TEXT, "");
            if (trueText.length() > 0) {
                return thisValue.equals(trueText);
            }
            if (falseText.length() > 0) {
                return !thisValue.equals(falseText);
            }
        }
        if (this.getValue() instanceof BNumber) {
            int intValue = ((BNumber)this.getValue()).getInt();
            return intValue != 0;
        }
        return false;
    }

    public String getStringValue() {
        if (this.getValue() instanceof BString) {
            return ((BString)this.getValue()).getString();
        }
        return this.getValue().toString((Context)new DataContext(this.getFacets()));
    }

    public double getDoubleValue() {
        if (this.getValue() instanceof BNumber) {
            return ((BNumber)this.getValue()).getDouble();
        }
        return Double.NaN;
    }

    public BEnum getEnumValue() {
        int ordinal = -1;
        if (this.getValue() instanceof BNumber) {
            ordinal = ((BNumber)this.getValue()).getInt();
        }
        return BDynamicEnum.make((int)ordinal);
    }

    public static boolean isBigEndian(BFacets facets) {
        boolean isBigEndian = false;
        BObject bigEndian = facets.getFacet(BIG_ENDIAN);
        try {
            isBigEndian = ((BBoolean)bigEndian).getBoolean();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isBigEndian;
    }

    public BIcon getIcon() {
        return icon;
    }

    class DataContext
    implements Context {
        BFacets facets;

        public DataContext(BFacets facets) {
            this.facets = facets;
        }

        public Context getBase() {
            return null;
        }

        public BUser getUser() {
            return new BUser();
        }

        public BFacets getFacets() {
            return this.facets;
        }

        public BObject getFacet(String name) {
            return this.getFacets().get(name);
        }

        public String getLanguage() {
            return Sys.getLanguage();
        }
    }
}

