/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.flexSerial;

import com.tridium.basicdriver.comm.Comm;
import com.tridium.basicdriver.serial.BSerialNetwork;
import com.tridium.flexSerial.BFlexSerialDevice;
import com.tridium.flexSerial.BFlexSerialDeviceFolder;
import com.tridium.flexSerial.comm.FlexSerialComm;
import com.tridium.flexSerial.comm.FlexSerialUnsolicitedReceive;
import com.tridium.flexSerial.messages.BFlexMessageBlockFolder;
import com.tridium.flexSerial.messages.BFlexMessageFolder;
import com.tridium.flexSerial.messages.BFlexRequestResponse;
import javax.baja.data.BIDataValue;
import javax.baja.license.Feature;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.Array;
import javax.baja.status.BStatusString;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

public class BFlexSerialNetwork
extends BSerialNetwork {
    public static final Property maxReceiveSilentTime = BFlexSerialNetwork.newProperty((int)0, (int)0, null);
    public static final Property unsolicitedMessage = BFlexSerialNetwork.newProperty((int)3, (BValue)new BStatusString(), null);
    public static final Property unsolicitedByteArray = BFlexSerialNetwork.newProperty((int)2, (BValue)BBlob.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"flexSerial:FlexBlobFE")));
    public static final Property messageBlocks = BFlexSerialNetwork.newProperty((int)0, (BValue)new BFlexMessageBlockFolder(), null);
    public static final Property messages = BFlexSerialNetwork.newProperty((int)0, (BValue)new BFlexMessageFolder(), null);
    public static final Property initMessage = BFlexSerialNetwork.newProperty((int)0, (BValue)new BFlexRequestResponse(), null);
    public static final Topic unsolicitedMessageReceived = BFlexSerialNetwork.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BFlexSerialNetwork.class);
    FlexSerialUnsolicitedReceive unsolicitedReceive;

    public int getMaxReceiveSilentTime() {
        return this.getInt(maxReceiveSilentTime);
    }

    public void setMaxReceiveSilentTime(int v) {
        this.setInt(maxReceiveSilentTime, v, null);
    }

    public BStatusString getUnsolicitedMessage() {
        return (BStatusString)this.get(unsolicitedMessage);
    }

    public void setUnsolicitedMessage(BStatusString v) {
        this.set(unsolicitedMessage, (BValue)v, null);
    }

    public BBlob getUnsolicitedByteArray() {
        return (BBlob)this.get(unsolicitedByteArray);
    }

    public void setUnsolicitedByteArray(BBlob v) {
        this.set(unsolicitedByteArray, (BValue)v, null);
    }

    public BFlexMessageBlockFolder getMessageBlocks() {
        return (BFlexMessageBlockFolder)this.get(messageBlocks);
    }

    public void setMessageBlocks(BFlexMessageBlockFolder v) {
        this.set(messageBlocks, (BValue)v, null);
    }

    public BFlexMessageFolder getMessages() {
        return (BFlexMessageFolder)this.get(messages);
    }

    public void setMessages(BFlexMessageFolder v) {
        this.set(messages, (BValue)v, null);
    }

    public BFlexRequestResponse getInitMessage() {
        return (BFlexRequestResponse)this.get(initMessage);
    }

    public void setInitMessage(BFlexRequestResponse v) {
        this.set(initMessage, (BValue)v, null);
    }

    public void fireUnsolicitedMessageReceived(BValue event) {
        this.fire(unsolicitedMessageReceived, event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "flexSerial");
    }

    public Type getDeviceType() {
        return BFlexSerialDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BFlexSerialDeviceFolder.TYPE;
    }

    protected Comm makeComm() {
        return new FlexSerialComm(this);
    }

    public void started() throws Exception {
        super.started();
        FlexSerialComm comm = (FlexSerialComm)this.getComm();
        this.messageDefChanged();
        comm.setMaxReceiveSilentTime(this.getMaxReceiveSilentTime());
        this.getInitMessage().forceMessage();
        this.unsolicitedReceive = new FlexSerialUnsolicitedReceive(this);
        this.unsolicitedReceive.init();
        comm.registerListener(this.unsolicitedReceive);
        this.unsolicitedReceive.start();
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(maxReceiveSilentTime)) {
            ((FlexSerialComm)this.getComm()).setMaxReceiveSilentTime(this.getMaxReceiveSilentTime());
        }
    }

    public void messageDefChanged() {
        FlexSerialComm comm = (FlexSerialComm)this.getComm();
        comm.setReceiveMessageSetup(this.getMessageBlocks().getFrameStart().getByteArray(), this.getMessageBlocks().getFrameEnd().getByteArray());
    }

    public BINavNode[] getNavChildren() {
        BINavNode[] kids = this.getNavChildren1();
        Array acc = new Array(BINavNode.class);
        for (int i = 0; i < kids.length; ++i) {
            BComponent kid = (BComponent)kids[i];
            if (kid.getPropertyInParent().isFrozen() && !(kid instanceof BFlexMessageBlockFolder) && !(kid instanceof BFlexMessageFolder)) continue;
            acc.add((Object)kid);
        }
        return (BINavNode[])acc.trim();
    }

    public BINavNode[] getNavChildren1() {
        this.loadSlots();
        BComponent[] temp = new BComponent[this.getSlotCount()];
        SlotCursor c = this.getProperties();
        int count = 0;
        while (c.nextComponent()) {
            BComponent kid = (BComponent)c.get();
            if (Flags.isHidden((BComplex)this, (Slot)c.property()) || !kid.isNavChild()) continue;
            temp[count++] = kid;
        }
        BComponent[] result = new BComponent[count];
        System.arraycopy(temp, 0, result, 0, count);
        return result;
    }

    public static BFlexSerialNetwork getParentFlexNetwork(BComplex child) {
        for (BComplex parent = child.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof BFlexSerialNetwork)) continue;
            return (BFlexSerialNetwork)parent;
        }
        return null;
    }
}

