/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.cmds;

import com.tridium.box.json.BsonDecoderPlugin;
import com.tridium.box.json.BsonEncoderPlugin;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import com.tridium.nc.BCloudDevice;
import com.tridium.nc.cmds.BCloudCommandsDeviceExt;
import com.tridium.nc.cmds.ICloudSystemCommand;
import java.util.Map;
import java.util.logging.Logger;
import javax.baja.naming.BOrd;
import javax.baja.security.PermissionException;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.util.Lexicon;

public final class InvokeCommand
implements ICloudSystemCommand {
    private String commandName;
    private BCloudDevice device;
    protected static final Logger log = Logger.getLogger("ncloud.command");
    protected static final Lexicon LEX = Lexicon.make((String)"nCloudDriver");

    public InvokeCommand(BCloudCommandsDeviceExt bCloudCommandsDeviceExt) {
        this.setCommandName("InvokeCommand");
        this.register(bCloudCommandsDeviceExt);
        this.device = (BCloudDevice)bCloudCommandsDeviceExt.getDevice();
    }

    @Override
    public void setCommandName(String cmdName) {
        this.commandName = cmdName;
    }

    @Override
    public String getCommandName() {
        return this.commandName;
    }

    @Override
    public void runCommand(JSONObject commandProperties, Map<String, Object> responseProperties, Context cx) {
        String messageId = (String)responseProperties.get(this.device.getConstant("CORRELATIONID"));
        log.fine(() -> String.format("%s executing %s", this.commandName, messageId));
        JSONObject payload = new JSONObject(JSONUtil.getString((JSONObject)commandProperties, (String)this.device.getConstant("COMMAND_PAYLOAD")));
        BOrd ord = BOrd.make((String)JSONUtil.getString((JSONObject)payload, (String)this.device.getConstant("COMPONENTORD")));
        String commandID = JSONUtil.getString((JSONObject)commandProperties, (String)this.device.getConstant("COMMANDID"));
        responseProperties.put(this.device.getConstant("COMMANDID"), commandID);
        BObject object = null;
        try {
            object = ord.get((BObject)this.device, cx);
        }
        catch (Exception e) {
            log.warning(String.format("Unable to resolve ord: %s: %s %s", ord, e.getMessage(), messageId));
            responseProperties.put(this.device.getConstant("RESPONSE_CODE"), String.valueOf(this.device.getNumericConstant("CMD_ERR_CODE_FORBIDDEN")));
            responseProperties.put(this.device.getConstant("ERROR_MESSAGE"), this.device.getConstant("ERR_ACCESS_NOT_ALLOWED"));
            return;
        }
        if (object instanceof BComponent) {
            BComponent component = (BComponent)object;
            Action action = component.getAction(JSONUtil.getString((JSONObject)payload, (String)this.device.getConstant("ACTION")));
            BValue argument = null;
            if (payload.has(this.device.getConstant("ARGUMENT"))) {
                try {
                    argument = BsonDecoderPlugin.unmarshal((JSONObject)payload.getJSONObject(this.device.getConstant("ARGUMENT")));
                }
                catch (Exception e) {
                    log.warning(String.format("Failed to decode argument: %s %s", e.getMessage(), messageId));
                    responseProperties.put(this.device.getConstant("RESPONSE_CODE"), String.valueOf(this.device.getNumericConstant("CMD_ERR_CODE_GENERAL")));
                    responseProperties.put(this.device.getConstant("ERROR_MESSAGE"), this.device.getConstant("ERR_BAD_REQUEST"));
                    log.fine(() -> String.format("%s complete %s", this.commandName, messageId));
                    return;
                }
            } else {
                argument = component.getActionParameterDefault(action);
            }
            try {
                BValue result = component.invoke(action, argument, cx);
                responseProperties.put(this.device.getConstant("RESPONSE_CODE"), String.valueOf(this.device.getNumericConstant("CMD_RESP_CODE_OK")));
                responseProperties.put(this.device.getConstant("ERROR_MESSAGE"), this.device.getConstant("RESP_OK"));
                if (result != null) {
                    responseProperties.put(this.device.getConstant("RETURNVALUE"), new JSONObject(BsonEncoderPlugin.marshal((BValue)result)));
                }
            }
            catch (PermissionException e) {
                log.warning(String.format("Insufficient permissions to invoke action: %s %s", e.getMessage(), messageId));
                responseProperties.put(this.device.getConstant("RESPONSE_CODE"), String.valueOf(this.device.getNumericConstant("CMD_ERR_CODE_FORBIDDEN")));
                responseProperties.put(this.device.getConstant("ERROR_MESSAGE"), this.device.getConstant("ERR_ACCESS_NOT_ALLOWED"));
            }
            catch (Exception e) {
                log.warning(String.format("Failed to invoke action: %s, %s", e.getMessage(), messageId));
                responseProperties.put(this.device.getConstant("RESPONSE_CODE"), String.valueOf(this.device.getNumericConstant("CMD_ERR_CODE_FAILURE")));
                responseProperties.put(this.device.getConstant("ERROR_MESSAGE"), e.toString());
            }
        } else {
            log.warning(String.format("The provided ord does not resolve to a BComponent: %s %s", ord.toString(), messageId));
            responseProperties.put(this.device.getConstant("RESPONSE_CODE"), String.valueOf(this.device.getNumericConstant("CMD_ERR_CODE_FORBIDDEN")));
            responseProperties.put(this.device.getConstant("ERROR_MESSAGE"), this.device.getConstant("ERR_ACCESS_NOT_ALLOWED"));
        }
        log.fine(() -> String.format("%s complete %s", this.commandName, messageId));
    }
}

