/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.cmds;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import com.tridium.nc.BCloudDevice;
import com.tridium.nc.CloudUtilities;
import com.tridium.nc.cmds.BCloudCommandsDeviceExt;
import com.tridium.nc.cmds.BCloudWriteInfo;
import com.tridium.nc.cmds.CloudPointReadInputsCommand;
import com.tridium.nc.cmds.ICloudSystemCommand;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import javax.baja.control.BControlPoint;
import javax.baja.sys.Context;

public class CloudMultiPointReadInputsCommand
implements ICloudSystemCommand {
    private String commandName;
    private final BCloudDevice device;
    private static final int BATCH_SIZE = 1024;
    private static final Logger log = Logger.getLogger("ncloud.command");

    public CloudMultiPointReadInputsCommand(BCloudCommandsDeviceExt bCloudCommandsDeviceExt) {
        this.setCommandName("CloudMultiPointReadInputsCommand");
        this.register(bCloudCommandsDeviceExt);
        this.device = (BCloudDevice)bCloudCommandsDeviceExt.getDevice();
    }

    @Override
    public void setCommandName(String cmdName) {
        this.commandName = cmdName;
    }

    @Override
    public String getCommandName() {
        return this.commandName;
    }

    @Override
    public void runCommand(JSONObject commandProperties, Map<String, Object> responseProperties, Context cx) {
        int msgTotal;
        Map<String, Object> respProperties;
        String messageId = (String)responseProperties.get(this.device.getConstant("CORRELATIONID"));
        log.fine(() -> String.format("%s executing %s", this.commandName, messageId));
        String commandID = JSONUtil.getString((JSONObject)commandProperties, (String)this.device.getConstant("COMMANDID"));
        if (!this.device.getNiagaraCloudNetwork().getPointReadAllowed()) {
            log.warning(() -> String.format("Attempted to read MultiPoint inputs: access not allowed %s", messageId));
            responseProperties.put(this.device.getConstant("RESPONSE_CODE"), this.device.getNumericConstant("CMD_ERR_CODE_FORBIDDEN"));
            responseProperties.put(this.device.getConstant("ERROR_MESSAGE"), this.device.getConstant("ERR_ACCESS_NOT_ALLOWED"));
            responseProperties.put(this.device.getConstant("COMMANDID"), commandID);
            return;
        }
        JSONObject payload = new JSONObject(JSONUtil.getString((JSONObject)commandProperties, (String)this.device.getConstant("COMMAND_PAYLOAD")));
        JSONArray points = payload.getJSONArray(this.device.getConstant("POINTIDS"));
        if (points.length() <= 1024) {
            respProperties = responseProperties;
            msgTotal = 1;
        } else {
            msgTotal = points.length() / 1024 + (points.length() % 1024 == 0 ? 0 : 1);
            respProperties = new HashMap<String, Object>();
            respProperties.put(this.device.getConstant("CORRELATIONID"), messageId);
        }
        respProperties.put(this.device.getConstant("COMMANDID"), commandID);
        JSONObject pointResults = new JSONObject();
        for (int lcv = 0; lcv < points.length(); ++lcv) {
            String pointString = points.getString(lcv);
            BControlPoint pxPoint = CloudUtilities.getPoint(pointString);
            if (pxPoint != null && CloudUtilities.isPointReadAllowed(this.device.getNiagaraCloudNetwork(), pxPoint, cx)) {
                BCloudWriteInfo[] infos = (BCloudWriteInfo[])pxPoint.getChildren(BCloudWriteInfo.class);
                JSONArray inputs = new JSONArray();
                for (BCloudWriteInfo info : infos) {
                    JSONObject jObj = new JSONObject();
                    jObj.put(this.device.getConstant("SOURCE"), (Object)info.getSource());
                    jObj.put(this.device.getConstant("PRIORITY"), CloudPointReadInputsCommand.getLevel(CloudUtilities.cloudProxy(pxPoint), info));
                    jObj.put(this.device.getConstant("VALUE"), (Object)Objects.toString(info.getValue().valueToString(cx)));
                    jObj.put(this.device.getConstant("EXPIRATION"), (Object)info.getExpiration().encodeToString());
                    inputs.put((Object)jObj);
                }
                pointResults.put(pointString, (Object)inputs);
            } else {
                log.warning(() -> String.format("Attempted to read MultiPoint inputs: access not allowed: %s %s", pointString, messageId));
                pointResults.put(pointString, (Object)new JSONObject().put(this.device.getConstant("SOURCE"), (Object)this.device.getConstant("ERR_ACCESS_NOT_ALLOWED")));
            }
            if (lcv % 1024 != 1023 || lcv == points.length() - 1) continue;
            respProperties.put(this.device.getConstant("RESPONSE_CODE"), this.device.getNumericConstant("CMD_RESP_CODE_OK"));
            respProperties.put(this.device.getConstant("ERROR_MESSAGE"), this.device.getConstant("RESP_OK"));
            respProperties.put("sequenceNum", lcv / 1024);
            respProperties.put("segmentTotal", msgTotal);
            respProperties.put("PointInputs", pointResults);
            this.device.getCommands().sendResponse(respProperties, commandID, this.commandName);
            pointResults = new JSONObject();
            if (points.length() - lcv <= 1024) {
                respProperties = responseProperties;
            } else {
                respProperties = new HashMap<String, Object>();
                respProperties.put(this.device.getConstant("CORRELATIONID"), messageId);
            }
            respProperties.put(this.device.getConstant("COMMANDID"), commandID);
        }
        responseProperties.put(this.device.getConstant("RESPONSE_CODE"), this.device.getNumericConstant("CMD_RESP_CODE_OK"));
        responseProperties.put(this.device.getConstant("ERROR_MESSAGE"), this.device.getConstant("RESP_OK"));
        responseProperties.put("SequenceNum", points.length() / 1024);
        responseProperties.put("segmentTotal", msgTotal);
        responseProperties.put("PointInputs", pointResults);
        log.fine(() -> String.format("%s complete %s", this.commandName, messageId));
    }
}

