/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.migration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.migration.BIBogElementConverter;
import javax.baja.migration.BIPxElementConverter;
import javax.baja.migration.BModuleRemovalConverter;
import javax.baja.migration.BPxRemovalConverter;
import javax.baja.migration.DuplicateConverterException;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BInterface;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.ModuleException;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeException;
import javax.baja.util.BTypeSpec;

public class ConverterRegistry {
    private static boolean initialized = false;
    public static final Logger log = Logger.getLogger("migration.registry");
    private static Map<String, BIBogElementConverter> bogConverters = new HashMap<String, BIBogElementConverter>();
    private static Map<String, BIPxElementConverter> pxConverters = new HashMap<String, BIPxElementConverter>();
    private static Map<String, String> packageConversions = new HashMap<String, String>();

    public static void initialize() {
        TypeInfo[] types = Sys.getRegistry().getConcreteTypes(BIBogElementConverter.TYPE.getTypeInfo());
        ConverterRegistry.setupConvertersMap(types, true);
        TypeInfo[] pxTypes = Sys.getRegistry().getConcreteTypes(BIPxElementConverter.TYPE.getTypeInfo());
        ConverterRegistry.setupConvertersMap(pxTypes, false);
        initialized = true;
    }

    private static void setupConvertersMap(TypeInfo[] types, boolean bogConverter) {
        for (TypeInfo typeInfo : types) {
            List<String> convertTypes;
            Object converter;
            if (bogConverter) {
                converter = (BIBogElementConverter)typeInfo.getInstance();
                convertTypes = converter.getConvertTypes();
            } else {
                converter = (BIPxElementConverter)typeInfo.getInstance();
                convertTypes = ((BIPxElementConverter)converter).getConvertTypeSpecs();
            }
            Type newType = converter.getType();
            for (String convertType : convertTypes) {
                List<String> packageConversions;
                BInterface alreadyThere;
                BInterface bInterface = alreadyThere = bogConverter ? (BInterface)bogConverters.get(convertType) : (BInterface)pxConverters.get(convertType);
                if (alreadyThere != null && !alreadyThere.getType().equals(newType)) {
                    throw new DuplicateConverterException(convertType, newType, alreadyThere.getType(), bogConverter);
                }
                if (bogConverter) {
                    bogConverters.put(convertType, (BIBogElementConverter)converter);
                    packageConversions = ((BIBogElementConverter)converter).getPackageConversions();
                } else {
                    if (convertType.contains(":")) {
                        String[] splitConvertType = convertType.split(":");
                        String moduleType = splitConvertType[0];
                        pxConverters.put(moduleType, (BIPxElementConverter)converter);
                        String typeName = splitConvertType[1];
                        pxConverters.put(typeName, (BIPxElementConverter)converter);
                    }
                    pxConverters.put(convertType, (BIPxElementConverter)converter);
                    packageConversions = ((BIPxElementConverter)converter).getPackageConversions();
                }
                if (packageConversions == null) continue;
                for (String pkg : packageConversions) {
                    String[] a = pkg.split(",");
                    if (a.length != 2) {
                        throw new BajaRuntimeException("Invalid format in " + converter.getClass().getName() + ".getPackageConversions()");
                    }
                    ConverterRegistry.packageConversions.put(a[0], a[1]);
                }
            }
        }
    }

    public static String lookUpPackageConversion(String packageName) {
        String newPkg;
        if (!initialized) {
            ConverterRegistry.initialize();
        }
        return (newPkg = packageConversions.get(packageName)) != null ? newPkg : packageName;
    }

    public static List<BIPxElementConverter> lookupPxConverters(String moduleOrTypeName) {
        return ConverterRegistry.getConverters(moduleOrTypeName, false);
    }

    public static List<BIBogElementConverter> lookupConverters(String moduleOrTypeName) {
        return ConverterRegistry.getConverters(moduleOrTypeName, true);
    }

    private static List<? extends BInterface> getConverters(String moduleOrTypeName, boolean bogConverter) {
        ArrayList<BInterface> list;
        block13: {
            if (!initialized) {
                ConverterRegistry.initialize();
            }
            list = new ArrayList<BInterface>();
            if (moduleOrTypeName != null) {
                BInterface converter;
                BInterface bInterface = converter = bogConverter ? (BInterface)bogConverters.get(moduleOrTypeName) : (BInterface)pxConverters.get(moduleOrTypeName);
                if (converter == null) {
                    int colon = moduleOrTypeName.indexOf(":");
                    try {
                        if (colon < 0) {
                            Sys.getRegistry().getModules(moduleOrTypeName);
                        }
                        Sys.getRegistry().getModules(moduleOrTypeName.substring(0, colon));
                    }
                    catch (ModuleNotFoundException e1) {
                        BObject remover = bogConverter ? new BModuleRemovalConverter(moduleOrTypeName) : new BPxRemovalConverter(moduleOrTypeName);
                        list.add((BInterface)remover);
                        if (log.isLoggable(Level.FINEST)) {
                            log.finest("Returning converter list for " + moduleOrTypeName + ": " + list);
                        }
                        return list;
                    }
                } else {
                    list.add(0, converter);
                }
                if (moduleOrTypeName.indexOf(":") > 0) {
                    BTypeSpec ts = BTypeSpec.make((String)moduleOrTypeName);
                    try {
                        for (Type t = ts.getResolvedType().getSuperType(); t != null; t = t.getSuperType()) {
                            BInterface converter1;
                            BInterface bInterface2 = converter1 = bogConverter ? (BInterface)bogConverters.get(t.getTypeSpec().toString()) : (BInterface)pxConverters.get(t.getTypeSpec().toString());
                            if (converter1 == null) continue;
                            list.add(0, converter1);
                        }
                    }
                    catch (ModuleException | TypeException e) {
                        if (!log.isLoggable(Level.FINE)) break block13;
                        log.fine("No registered type for " + moduleOrTypeName + "; returning only the registered converter " + converter);
                    }
                }
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Returning converter list for " + moduleOrTypeName + ": " + list);
        }
        return list;
    }

    public static void main(String ... args) {
        ConverterRegistry.initialize();
        if (args.length == 0) {
            ConverterRegistry.printConverters(true);
            ConverterRegistry.printConverters(false);
        } else {
            for (String arg : args) {
                try {
                    BTypeSpec typeSpec = BTypeSpec.make((String)arg);
                    Type type = typeSpec.getResolvedType();
                    if (type.is(BIBogElementConverter.TYPE)) {
                        ConverterRegistry.printConvertTypes((BIBogElementConverter)typeSpec.getInstance().as(BIBogElementConverter.class));
                        continue;
                    }
                    if (type.is(BIPxElementConverter.TYPE)) {
                        ConverterRegistry.printConvertTypes((BIPxElementConverter)typeSpec.getInstance().as(BIPxElementConverter.class));
                        continue;
                    }
                    System.out.println("moduleOrTypeName: " + arg + " -> Converters: " + ConverterRegistry.lookupConverters(arg));
                }
                catch (Exception e) {
                    System.out.println("Could not list convertTypes for " + arg + ":" + e);
                }
            }
        }
    }

    private static void printConverters(boolean bogConverter) {
        ArrayList<BInterface> printed = new ArrayList<BInterface>();
        Map<String, Object> converters = bogConverter ? bogConverters : pxConverters;
        for (String key : converters.keySet()) {
            BInterface converter = (BInterface)converters.get(key);
            if (printed.contains(converter)) continue;
            printed.add(converter);
            if (bogConverter) {
                ConverterRegistry.printConvertTypes((BIBogElementConverter)converter);
                continue;
            }
            ConverterRegistry.printConvertTypes((BIPxElementConverter)converter);
        }
    }

    private static void printConvertTypes(BIBogElementConverter converter) {
        System.out.println("Converter: " + converter.getType());
        for (String convertType : converter.getConvertTypes()) {
            System.out.println("\t" + convertType);
        }
    }

    private static void printConvertTypes(BIPxElementConverter converter) {
        System.out.println("Converter: " + converter.getType());
        for (String convertType : converter.getConvertTypeSpecs()) {
            System.out.println("\t" + convertType);
        }
    }
}

