/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.virtual;

import com.tridium.util.EscUtil;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.naming.SyntaxException;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.IllegalNameException;

public final class VirtualPath
extends SlotPath {
    private static final char ESCAPE_CHAR = '~';

    public VirtualPath(String scheme, String body) throws SyntaxException {
        super(scheme, body);
    }

    public VirtualPath(String scheme, String[] names) throws SyntaxException {
        super(scheme, names);
    }

    public VirtualPath(String body) throws SyntaxException {
        super("virtual", body);
    }

    public static VirtualPath convertFromSlotPath(SlotPath slotPath) {
        int i;
        String[] escapedNames = slotPath.getNames();
        int len = escapedNames.length;
        String[] unescapedNames = new String[len];
        for (int i2 = 0; i2 < len; ++i2) {
            unescapedNames[i2] = VirtualPath.toVirtualPathName(escapedNames[i2]);
        }
        if (slotPath.isAbsolute()) {
            return new VirtualPath("virtual", unescapedNames);
        }
        int backup = slotPath.getBackupDepth();
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < backup; ++i) {
            sb.append("../");
        }
        for (i = 0; i < len; ++i) {
            if (i != 0) {
                sb.append('/');
            }
            sb.append(unescapedNames[i]);
        }
        return new VirtualPath(sb.toString());
    }

    @Override
    protected SlotPath makeSlotPath(String scheme, String body) {
        return new VirtualPath(scheme, body);
    }

    @Override
    public OrdQuery makePath(String body) {
        return new VirtualPath(body);
    }

    @Override
    protected boolean isValidPathName(String name) {
        return VirtualPath.isValidName(name);
    }

    public static boolean isValidName(String name) {
        if (name == null) {
            return false;
        }
        int len = name.length();
        if (len < 1) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            switch (c) {
                case '$': 
                case '/': 
                case ':': 
                case '|': {
                    return false;
                }
            }
        }
        return true;
    }

    public static void verifyValidName(String name) {
        if (!VirtualPath.isValidName(name)) {
            throw new IllegalNameException("baja", "IllegalNameException.name", new Object[]{name});
        }
    }

    public static String escape(String s) {
        throw new UnsupportedOperationException("escape() not implemented for VirtualPath. Use toVirtualPathName() instead.");
    }

    public static String unescape(String s) {
        throw new UnsupportedOperationException("unescape() not implemented for VirtualPath. Use toSlotPathName() instead.");
    }

    @Override
    public String toDisplayString() {
        return this.getBody();
    }

    public static String toVirtualPathName(String slotPathName) {
        char[] buf = null;
        int pos = 0;
        int len = slotPathName.length();
        for (int i = 0; i < len; ++i) {
            char c1;
            char c = slotPathName.charAt(i);
            if (c != '$') {
                if (buf == null) continue;
                buf[pos++] = c;
                continue;
            }
            if (buf == null) {
                buf = new char[len];
                slotPathName.getChars(0, i, buf, 0);
                pos = i;
            }
            if ((c1 = slotPathName.charAt(++i)) != 'u') {
                char c2 = slotPathName.charAt(++i);
                char unescapedChar = (char)(TextUtil.hexCharToInt((char)c1) << 4 | TextUtil.hexCharToInt((char)c2));
                switch (unescapedChar) {
                    case '$': 
                    case '/': 
                    case ':': 
                    case '|': 
                    case '~': {
                        buf[pos++] = 126;
                        buf[pos++] = c1;
                        buf[pos++] = c2;
                        break;
                    }
                    default: {
                        buf[pos++] = unescapedChar;
                        break;
                    }
                }
                continue;
            }
            buf[pos++] = (char)(TextUtil.hexCharToInt((char)slotPathName.charAt(++i)) << 12 | TextUtil.hexCharToInt((char)slotPathName.charAt(++i)) << 8 | TextUtil.hexCharToInt((char)slotPathName.charAt(++i)) << 4 | TextUtil.hexCharToInt((char)slotPathName.charAt(++i)));
        }
        return buf == null ? slotPathName : new String(buf, 0, pos);
    }

    public static String toSlotPathName(String virtualPathName) {
        int len = virtualPathName.length();
        if (len == 0) {
            return virtualPathName;
        }
        char[] buf = null;
        int pos = 0;
        int maxLen = len * 6;
        char c = virtualPathName.charAt(0);
        int offset = 0;
        if (c == '~') {
            char unescapedChar = '\u0000';
            try {
                unescapedChar = (char)(TextUtil.hexCharToInt((char)virtualPathName.charAt(++offset)) << 4 | TextUtil.hexCharToInt((char)virtualPathName.charAt(++offset)));
            }
            catch (Exception exception) {
                // empty catch block
            }
            switch (unescapedChar) {
                case 36: 
                case 47: 
                case 58: 
                case 124: 
                case 126: {
                    c = unescapedChar;
                    buf = new char[maxLen];
                    break;
                }
                default: {
                    offset = 0;
                }
            }
        }
        if (!EscUtil.slot.isStart(c)) {
            if (buf == null) {
                buf = new char[maxLen];
            }
            pos = EscUtil.escape(c, buf, pos);
        } else if (buf != null) {
            buf[pos++] = c;
        }
        for (int i = 1 + offset; i < len; ++i) {
            c = virtualPathName.charAt(i);
            if (c == '~') {
                char unescapedChar = '\u0000';
                int idx = i;
                try {
                    unescapedChar = (char)(TextUtil.hexCharToInt((char)virtualPathName.charAt(++idx)) << 4 | TextUtil.hexCharToInt((char)virtualPathName.charAt(++idx)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                switch (unescapedChar) {
                    case '$': 
                    case '/': 
                    case ':': 
                    case '|': 
                    case '~': {
                        c = unescapedChar;
                        if (buf == null) {
                            buf = new char[maxLen];
                            virtualPathName.getChars(0, i, buf, 0);
                            pos = i;
                        }
                        i += 2;
                        break;
                    }
                }
            }
            if (EscUtil.slot.isPart(c)) {
                if (buf == null) continue;
                buf[pos++] = c;
                continue;
            }
            if (buf == null) {
                buf = new char[maxLen];
                virtualPathName.getChars(0, i, buf, 0);
                pos = i;
            }
            pos = EscUtil.escape(c, buf, pos);
        }
        return buf == null ? virtualPathName : new String(buf, 0, pos);
    }
}

