/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.virtual;

import javax.baja.agent.AgentList;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BCategoryService;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.space.BComponentSpace;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.TagDictionaryService;
import javax.baja.virtual.BVirtualGateway;
import javax.baja.virtual.VirtualPath;

public class BVirtualComponent
extends BComponent {
    public static final Type TYPE = Sys.loadType(BVirtualComponent.class);
    private static final BIcon icon = BIcon.make(BIcon.std("object.png"), BIcon.std("badges/ghost.png"));
    long lastActiveTicks = Long.MAX_VALUE;

    @Override
    public Type getType() {
        return TYPE;
    }

    public boolean performAutoRemoval() {
        return true;
    }

    public final long getLastActiveTicks() {
        return this.lastActiveTicks;
    }

    public final void setLastActiveTicks(long ticks) {
        this.lastActiveTicks = ticks;
    }

    public final BVirtualGateway getVirtualGateway() {
        BComponentSpace space = this.getComponentSpace();
        if (space == null) {
            return null;
        }
        BINavNode navParent = space.getNavParent();
        if (navParent instanceof BVirtualGateway) {
            return (BVirtualGateway)navParent;
        }
        return null;
    }

    public BOrd getCategorizableOrd() {
        BOrd navOrd = this.getNavOrd();
        if (navOrd != null) {
            return navOrd.relativizeToSession();
        }
        return null;
    }

    @Override
    public boolean isChildLegal(BComponent child) {
        return child instanceof BVirtualComponent || child instanceof BVector;
    }

    @Override
    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BVirtualComponent;
    }

    @Override
    public final BOrd getNavOrd() {
        BOrd spaceOrd;
        BComponentSpace space = this.getComponentSpace();
        if (space == null) {
            return null;
        }
        BOrd bOrd = spaceOrd = this.getVirtualGateway() == null ? space.getAbsoluteOrd() : space.getNavOrd();
        if (spaceOrd == null) {
            return null;
        }
        SlotPath path = this.getSlotPath();
        if (path == null) {
            return null;
        }
        VirtualPath vPath = VirtualPath.convertFromSlotPath(path);
        return BOrd.make(spaceOrd, vPath).normalize();
    }

    @Override
    public TagDictionaryService getTagDictionaryService() {
        BVirtualGateway vGateway = this.getVirtualGateway();
        if (vGateway != null) {
            return vGateway.getTagDictionaryService();
        }
        return super.getTagDictionaryService();
    }

    @Override
    public BCategoryMask getAppliedCategoryMask() {
        BVirtualGateway gateway;
        BOrd ord = this.getCategorizableOrd();
        if (ord != null && !ord.isNull()) {
            BCategoryService service = null;
            if (this.isRunning()) {
                service = BCategoryService.getService();
            } else {
                service = (BCategoryService)BOrd.make(this.getVirtualGateway().getAbsoluteOrd(), "service:baja:CategoryService").get();
                service.lease(1);
            }
            BCategoryMask mask = service.getOrdMap().getAppliedCategoryMask(ord.relativizeToSession());
            if (mask != null) {
                return mask;
            }
        }
        if ((gateway = this.getVirtualGateway()) != null) {
            return gateway.getAppliedCategoryMask();
        }
        return super.getAppliedCategoryMask();
    }

    @Override
    public BCategoryMask getCategoryMask() {
        BOrd ord = this.getCategorizableOrd();
        if (ord != null && !ord.isNull()) {
            BCategoryService service = null;
            if (this.isRunning() || this.getVirtualGateway() == null) {
                service = BCategoryService.getService();
            } else {
                service = (BCategoryService)BOrd.make(this.getVirtualGateway().getAbsoluteOrd(), "service:baja:CategoryService").get();
                service.lease(1);
            }
            BCategoryMask mask = service.getOrdMap().getCategoryMask(ord.relativizeToSession());
            if (mask != null) {
                return mask;
            }
        }
        return BCategoryMask.NULL;
    }

    @Override
    public AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        list.remove("pxEditor:PxEditor");
        list.remove("wiresheet:WireSheet");
        list.remove("workbench:LinkSheet");
        list.remove("tagdictionary:TagManager");
        return list;
    }

    @Override
    public BIcon getIcon() {
        BValue dynamic = this.get("icon");
        if (dynamic instanceof BIcon) {
            return (BIcon)dynamic;
        }
        return icon;
    }

    @Override
    public void spy(SpyWriter out) throws Exception {
        out.startProps();
        out.trTitle("VirtualComponent", 2);
        out.prop((Object)"performAutoRemoval", this.performAutoRemoval());
        out.prop((Object)"lastActiveTicks", this.getLastActiveTicks() + " (" + BAbsTime.make(this.getLastActiveTicks()).encodeToString() + ")");
        out.prop((Object)"categorizableOrd", this.getCategorizableOrd());
        out.endProps();
        super.spy(out);
    }

    @Override
    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 11: {
                this.updateTicks();
                break;
            }
            case 12: {
                this.updateTicks();
                break;
            }
            case 18: {
                this.updateTicks();
                this.updateSpace(118);
                break;
            }
            case 17: {
                this.updateSpace(117);
            }
        }
        return super.fw(x, a, b, c, d);
    }

    void updateTicks() {
        this.setLastActiveTicks(Clock.ticks());
    }

    private void updateSpace(int fwConstant) {
        BComponentSpace space = this.getComponentSpace();
        if (space != null) {
            space.fw(fwConstant, this, null, null, null);
        }
    }
}

