/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import javax.baja.nre.util.TextUtil;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFloat;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.Queue;

public class Worker {
    boolean isAlive;
    Thread thread;
    ITodo todo;
    int timeout;
    int numProcessed;
    long startTime;
    long startTicks;
    long processingTicks;

    public Worker(ITodo todo) {
        this.todo = todo;
    }

    public ITodo getTodo() {
        return this.todo;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String toString() {
        return TextUtil.getClassName(this.getClass()) + " [" + (this.isAlive ? "Running" : "Stopped") + "]";
    }

    public boolean isRunning() {
        return this.thread != null && this.isAlive;
    }

    public final void start(String threadName) {
        this.start(Thread.currentThread().getThreadGroup(), threadName);
    }

    public void start(ThreadGroup threadGroup, String threadName) {
        if (this.isAlive) {
            return;
        }
        this.isAlive = true;
        this.startTime = Clock.millis();
        this.startTicks = Clock.ticks();
        this.numProcessed = 0;
        this.thread = new Thread(threadGroup, new Processor(), threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void stop() {
        this.isAlive = false;
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    protected void process(Runnable work) throws Exception {
        if (work != null) {
            work.run();
        }
    }

    public void spy(SpyWriter out) throws Exception {
        out.startProps("Worker");
        this.spyImpl(out);
        out.endProps();
    }

    void spyImpl(SpyWriter out) {
        Queue q;
        out.prop((Object)"isAlive", "" + this.isAlive);
        if (this.isAlive) {
            Worker.spy(out, this.startTime, this.startTicks, this.processingTicks, this.numProcessed);
        }
        out.prop((Object)"todo", this.todo.getClass().getName());
        if (this.todo instanceof Queue) {
            q = (Queue)this.todo;
            out.prop((Object)"queue.size", "" + q.size());
            out.prop((Object)"queue.maxSize", "" + q.maxSize());
        }
        if (this.todo instanceof CoalesceQueue) {
            q = (CoalesceQueue)this.todo;
            out.prop((Object)"queue.hashTable", "" + ((CoalesceQueue)q).table.length);
            out.prop((Object)"queue.hashSize", "" + ((CoalesceQueue)q).hashSize);
            out.prop((Object)"queue.threshold", "" + ((CoalesceQueue)q).threshold);
        }
    }

    static void spy(SpyWriter out, long startTime, long startTicks, long processingTicks, int numProcessed) {
        long uptime = Clock.ticks() - startTicks;
        float percent = (float)processingTicks / (float)uptime * 100.0f;
        float avg = (float)processingTicks / (float)numProcessed;
        out.prop((Object)"startTime", BAbsTime.make(startTime));
        out.prop((Object)"upTime", BRelTime.toString(uptime));
        out.prop((Object)"processing", BRelTime.toString(processingTicks));
        out.prop((Object)"numProcessed", "" + numProcessed);
        out.prop((Object)"average", BFloat.toString(avg, null) + "ms/work");
        out.prop((Object)"utilization", "" + (int)percent + "%");
    }

    public static interface ITodo {
        public Runnable todo(int var1) throws InterruptedException;
    }

    class Processor
    implements Runnable {
        Processor() {
        }

        @Override
        public void run() {
            Worker.this.isAlive = true;
            while (Worker.this.isAlive) {
                try {
                    Runnable work = Worker.this.todo.todo(Worker.this.timeout);
                    long t1 = Clock.ticks();
                    Worker.this.process(work);
                    long t2 = Clock.ticks();
                    Worker.this.processingTicks += t2 - t1;
                    ++Worker.this.numProcessed;
                }
                catch (InterruptedException work) {
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

