/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.baja.file.BIFile;
import javax.baja.file.IFileFilter;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IFilter;
import javax.baja.sys.Context;

public class PatternFilter
implements IFilter,
IFileFilter {
    private State start;
    private State accept;
    private String pattern;

    public static PatternFilter[] parseList(String listOfPatterns, String separators) {
        ArrayList<PatternFilter> list = new ArrayList<PatternFilter>();
        StringTokenizer st = new StringTokenizer(listOfPatterns, separators);
        while (st.hasMoreTokens()) {
            list.add(new PatternFilter(st.nextToken()));
        }
        return list.toArray(new PatternFilter[list.size()]);
    }

    public static PatternFilter[] parseList(String listOfPatterns) {
        return PatternFilter.parseList(listOfPatterns, " \t,;");
    }

    public PatternFilter(String pattern) {
        this.pattern = pattern;
        this.parse();
    }

    public String getPattern() {
        return this.pattern;
    }

    @Override
    public String getDescription(Context cx) {
        return this.pattern;
    }

    @Override
    public boolean accept(BIFile file) {
        return this.accept(file.getFileName());
    }

    public boolean accept(Object object) {
        return this.accept(object.toString());
    }

    public boolean accept(String string) {
        Array curStates = new Array(State.class);
        curStates.push((Object)this.start);
        char[] buf = string.toCharArray();
        for (int i = 0; i < buf.length; ++i) {
            Array nextStates = new Array(State.class);
            while (!curStates.isEmpty()) {
                nextStates.addAll((Object[])((State)curStates.pop()).transition(buf[i]));
            }
            if (nextStates.isEmpty()) {
                return false;
            }
            curStates = nextStates;
        }
        return curStates.contains((Object)this.accept);
    }

    public boolean hasWildChars() {
        return this.pattern.indexOf(42) != -1 || this.pattern.indexOf(63) != -1;
    }

    private void parse() {
        State cur = this.start = new State();
        char[] buf = this.pattern.toCharArray();
        for (int i = 0; i < buf.length; ++i) {
            char c = buf[i];
            if (c == '*') {
                if (i > 0 && buf[i - 1] == '*') continue;
                cur.addTransition(Condition.any(), cur);
                continue;
            }
            cur = c == '?' ? cur.addTransition(Condition.any(), new State()) : cur.addTransition(Condition.exact(c), new State());
        }
        this.accept = cur;
    }

    private static abstract class Condition {
        private Condition() {
        }

        public abstract boolean match(char var1);

        public static Condition exact(final char c) {
            return new Condition(){

                @Override
                public boolean match(char test) {
                    return c == test;
                }
            };
        }

        public static Condition any() {
            return new Condition(){

                @Override
                public boolean match(char test) {
                    return true;
                }
            };
        }
    }

    private class State {
        private Map<Condition, State> transitions = new HashMap<Condition, State>();

        private State() {
        }

        public State addTransition(Condition c, State next) {
            this.transitions.put(c, next);
            return next;
        }

        public State[] transition(char c) {
            Array outStates = new Array(State.class);
            for (Condition cond : this.transitions.keySet()) {
                if (!cond.match(c)) continue;
                outStates.add((Object)this.transitions.get(cond));
            }
            return (State[])outStates.trim();
        }
    }
}

