/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import com.tridium.nre.util.NamedThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ExecutorUtil {
    private ExecutorUtil() {
    }

    public static void shutdown(ExecutorService service) {
        service.shutdown();
        try {
            if (!service.awaitTermination(10L, TimeUnit.SECONDS)) {
                service.shutdownNow();
                service.awaitTermination(10L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException e) {
            service.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public static ExecutorService newSingleThreadBackgroundExecutor(String threadName, long keepAliveTime, TimeUnit keepAliveUnits) {
        return new ThreadPoolExecutor(0, 1, keepAliveTime, keepAliveUnits, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory(threadName));
    }

    public static ScheduledExecutorService newSingleThreadBackgroundScheduledExecutor(String threadName, long keepAliveTime, TimeUnit keepAliveUnits) {
        ScheduledThreadPoolExecutor service = new ScheduledThreadPoolExecutor(0, (ThreadFactory)new NamedThreadFactory(threadName));
        service.setMaximumPoolSize(1);
        service.setKeepAliveTime(keepAliveTime, keepAliveUnits);
        return service;
    }
}

