/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.baja.io.BajaIOException;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BWsAnnotation
extends BSimple {
    public static final BWsAnnotation DEFAULT = new BWsAnnotation(0, 0, 8, 0);
    public static final Type TYPE = Sys.loadType(BWsAnnotation.class);
    public static final String PROPERTY_NAME = "wsAnnotation";
    public final int p;
    public final int q;
    public final int wixelWidth;
    public final int wixelHeight;
    private String string;

    public static BWsAnnotation make(int p, int q) {
        return new BWsAnnotation(p, q, BWsAnnotation.DEFAULT.wixelWidth, BWsAnnotation.DEFAULT.wixelHeight);
    }

    public static BWsAnnotation make(int p, int q, int wixelWidth) {
        return new BWsAnnotation(p, q, wixelWidth, BWsAnnotation.DEFAULT.wixelHeight);
    }

    public static BWsAnnotation make(int p, int q, int wixelWidth, int wixelHeight) {
        return new BWsAnnotation(p, q, wixelWidth, wixelHeight);
    }

    public static BWsAnnotation merge(BWsAnnotation a1, BWsAnnotation a2) {
        if (a1 == null && a2 == null) {
            return DEFAULT;
        }
        if (a1 == null) {
            return a2;
        }
        if (a2 == null) {
            return a1;
        }
        int w = Math.max(a1.wixelWidth, a2.wixelWidth);
        int h = Math.max(a1.wixelHeight, a2.wixelHeight);
        return new BWsAnnotation(a2.p, a2.q, w, h);
    }

    private BWsAnnotation(int p, int q, int wixelWidth, int wixelHeight) {
        this.p = p;
        this.q = q;
        this.wixelWidth = wixelWidth;
        this.wixelHeight = wixelHeight;
        StringBuffer s = new StringBuffer();
        s.append(p).append(',').append(q).append(',').append(wixelWidth);
        if (wixelHeight != 0) {
            s.append(',').append(wixelHeight);
        }
        this.string = s.toString();
    }

    private BWsAnnotation(String s) throws Exception {
        StringTokenizer blocks = new StringTokenizer(s, "|");
        StringTokenizer st = new StringTokenizer(blocks.nextToken(), ",");
        this.p = Integer.parseInt(st.nextToken());
        this.q = Integer.parseInt(st.nextToken());
        this.wixelWidth = Integer.parseInt(st.nextToken());
        this.wixelHeight = st.hasMoreTokens() ? Integer.parseInt(st.nextToken()) : 0;
        this.string = s;
    }

    public BWsAnnotation translate(int pTrans, int qTrans) {
        return new BWsAnnotation(this.p + pTrans, this.q + qTrans, this.wixelWidth, this.wixelHeight);
    }

    @Override
    public int hashCode() {
        return this.p ^ this.q ^ this.wixelWidth ^ this.wixelHeight;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BWsAnnotation) {
            BWsAnnotation x = (BWsAnnotation)obj;
            if (this.p != x.p) {
                return false;
            }
            if (this.q != x.q) {
                return false;
            }
            if (this.wixelWidth != x.wixelWidth) {
                return false;
            }
            return this.wixelHeight == x.wixelHeight;
        }
        return false;
    }

    @Override
    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.string);
    }

    @Override
    public BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    @Override
    public String encodeToString() throws IOException {
        return this.string;
    }

    @Override
    public BObject decodeFromString(String s) throws IOException {
        try {
            return new BWsAnnotation(s);
        }
        catch (Exception e) {
            throw new BajaIOException(s, e);
        }
    }

    @Override
    public Type getType() {
        return TYPE;
    }
}

