/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Worker;

public abstract class BWorker
extends BComponent {
    public static final Type TYPE = Sys.loadType(BWorker.class);
    private static final BIcon icon = BIcon.std("gears.png");

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        super.started();
        if (!this.isSteadyStateWorker()) {
            this.startWorker();
        }
    }

    @Override
    public void atSteadyState() throws Exception {
        super.atSteadyState();
        if (this.isSteadyStateWorker()) {
            this.startWorker();
        }
    }

    @Override
    public void stopped() throws Exception {
        super.stopped();
        this.stopWorker();
    }

    public abstract Worker getWorker();

    protected void startWorker() {
        this.getWorker().start(this.getWorkerThreadName());
    }

    protected void stopWorker() {
        this.getWorker().stop();
    }

    protected boolean isSteadyStateWorker() {
        return false;
    }

    protected String getWorkerThreadName() {
        return this.toPathString();
    }

    @Override
    public void spy(SpyWriter out) throws Exception {
        Worker w = this.getWorker();
        if (w != null) {
            w.spy(out);
        } else {
            out.startProps("No Worker");
            out.endProps();
        }
        super.spy(out);
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }
}

