/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import javax.baja.sys.BAbsTime;
import javax.baja.sys.BStruct;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BTimeRange
extends BStruct {
    public static final Property startTime = BTimeRange.newProperty(0, BTime.make(0, 0, 0, 0), null);
    public static final Property endTime = BTimeRange.newProperty(0, BTime.make(0, 0, 0, 0), null);
    public static final Type TYPE = Sys.loadType(BTimeRange.class);

    public BTime getStartTime() {
        return (BTime)this.get(startTime);
    }

    public void setStartTime(BTime v) {
        this.set(startTime, (BValue)v, null);
    }

    public BTime getEndTime() {
        return (BTime)this.get(endTime);
    }

    public void setEndTime(BTime v) {
        this.set(endTime, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BTimeRange() {
    }

    public BTimeRange(BTime start, BTime end) {
        this.setStartTime(start);
        this.setEndTime(end);
    }

    public boolean includes(BAbsTime time) {
        return this.test(time.getTimeOfDayMillis());
    }

    public boolean includes(BTime time) {
        return this.test(time.getTimeOfDayMillis());
    }

    public boolean isAllDay() {
        return this.getStartTime().equals(this.getEndTime());
    }

    @Override
    public String toString(Context ctx) {
        return this.getStartTime().toString(ctx) + " - " + this.getEndTime().toString(ctx);
    }

    private boolean test(long time) {
        long start = this.getStartTime().getTimeOfDayMillis();
        long end = this.getEndTime().getTimeOfDayMillis();
        if (end == 0L) {
            end = 86400000L;
        }
        if (start < end) {
            return time >= start && time <= end;
        }
        return time >= start || time <= end;
    }
}

