/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import com.tridium.util.ComponentTreeCursor;
import com.tridium.util.ObjectUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInterface;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalChildException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BServiceContainer;

public interface BIRestrictedComponent
extends BInterface {
    public static final Type TYPE = Sys.loadType(BIRestrictedComponent.class);

    default public void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkParentForRestrictedComponent(parent, this);
    }

    public static void checkParentForRestrictedComponent(BComponent parent, BIRestrictedComponent child) {
        BIRestrictedComponent.checkParentIsServiceContainer(parent, child);
        BIRestrictedComponent.checkForDuplicates(parent, child, false);
    }

    public static void checkParentIsServiceContainer(BComponent parent, BIRestrictedComponent child) {
        if (!parent.getType().is(BServiceContainer.TYPE)) {
            throw new IllegalChildException("baja", "RestrictedToServiceContainer", new Object[]{parent.getType(), child.getType()});
        }
    }

    public static void checkForDuplicates(BComponent parent, BIRestrictedComponent child, boolean allowNonExactTypes) {
        BStation station = ObjectUtil.getStation(parent.getComponentSpace());
        if (station == null) {
            return;
        }
        BServiceContainer services = station.getServices();
        ComponentTreeCursor c = new ComponentTreeCursor(services, null);
        while (c.next()) {
            BValue value = c.get();
            if (value == child || !value.getType().is(TYPE) || !(allowNonExactTypes ? child.getType().equals(value.getType()) : value.getType().is(child.getType()) || child.getType().is(value.getType()))) continue;
            throw new IllegalChildException("baja", "DuplicateRestrictedComponent", new Object[]{parent.getType(), child.getType()});
        }
    }

    public static void checkContextForSuperUser(BIRestrictedComponent component, Context cx) {
        if (cx != null && cx.getUser() != null && !cx.getUser().getPermissions().isSuperUser()) {
            throw new IllegalChildException("baja", "RestrictedServiceException", new Object[]{component.getType()});
        }
    }
}

