/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import javax.baja.nre.util.Array;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BFacetsMap
extends BSimple {
    public static final BFacetsMap NULL;
    public static final BFacetsMap DEFAULT;
    public static final Type TYPE;
    private String string;
    private HashMap<String, BFacets> map;
    private int hashCode = -1;

    public static BFacetsMap make(HashMap<String, BFacets> map) {
        if (map.isEmpty()) {
            return NULL;
        }
        return (BFacetsMap)new BFacetsMap((HashMap)map.clone()).intern();
    }

    public static BFacetsMap make(BFacetsMap orig, String name, String value) throws IOException {
        return BFacetsMap.make(orig, name, BFacets.make(value));
    }

    public static BFacetsMap make(BFacetsMap orig, String name, BFacets value) {
        HashMap map = (HashMap)orig.map.clone();
        map.put(name, value);
        return (BFacetsMap)new BFacetsMap(map).intern();
    }

    public static BFacetsMap make(BFacetsMap orig, BFacetsMap other) {
        String[] otherKeys;
        HashMap map = (HashMap)orig.map.clone();
        for (String otherKey : otherKeys = other.list()) {
            map.put(otherKey, other.get(otherKey));
        }
        return (BFacetsMap)new BFacetsMap(map).intern();
    }

    public static BFacetsMap remove(BFacetsMap orig, String name) {
        HashMap map = (HashMap)orig.map.clone();
        map.remove(name);
        return (BFacetsMap)new BFacetsMap(map).intern();
    }

    private BFacetsMap(HashMap<String, BFacets> map) {
        this.map = map;
    }

    public String[] list() {
        return this.map.keySet().toArray(new String[this.map.size()]);
    }

    public BFacets get(String name) {
        BFacets result = this.map.get(name);
        return result == null ? BFacets.NULL : result;
    }

    @Override
    public boolean isNull() {
        return this.map.isEmpty();
    }

    @Override
    public int hashCode() {
        try {
            if (this.hashCode == -1) {
                this.hashCode = this.encodeToString().hashCode();
            }
            return this.hashCode;
        }
        catch (Exception e) {
            return System.identityHashCode(this);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BFacetsMap) {
            BFacetsMap x = (BFacetsMap)obj;
            if (this.map.size() != x.map.size()) {
                return false;
            }
            for (String key : this.map.keySet()) {
                BFacets val = this.map.get(key);
                if (val.equals(x.map.get(key))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String toString(Context context) {
        try {
            return this.encodeToString();
        }
        catch (IOException e) {
            throw new BajaRuntimeException(e);
        }
    }

    @Override
    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    @Override
    public BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    @Override
    public String encodeToString() throws IOException {
        if (this.string == null) {
            StringBuffer s = new StringBuffer();
            s.append('{');
            for (String key : this.map.keySet()) {
                BFacets val = this.map.get(key);
                this.escape(s, key);
                s.append('=');
                this.escape(s, val.encodeToString());
                s.append(';');
            }
            s.append('}');
            this.string = s.toString();
        }
        return this.string;
    }

    @Override
    public BObject decodeFromString(String s) throws IOException {
        try {
            int start = s.indexOf(123);
            int end = s.lastIndexOf(125);
            if (start + 1 == end) {
                return NULL;
            }
            String body = s.substring(start + 1, end);
            Array acc = new Array(String.class);
            int len = body.length();
            StringBuilder buf = new StringBuilder();
            int n = -1;
            for (int i = 0; i < len; ++i) {
                char c;
                char c2 = body.charAt(i);
                if (c2 == '\\') {
                    buf.append(body.charAt(++i));
                    continue;
                }
                if (c2 != '=' && c2 != ';') {
                    buf.append(c2);
                    continue;
                }
                if (c2 == c) {
                    throw new Exception();
                }
                c = c2;
                acc.add((Object)buf.toString());
                buf.setLength(0);
            }
            HashMap<String, BFacets> map = new HashMap<String, BFacets>();
            for (int i = 0; i < acc.size(); i += 2) {
                String key = (String)acc.get(i);
                BFacets val = BFacets.make((String)acc.get(i + 1));
                map.put(key, val);
            }
            BFacetsMap x = (BFacetsMap)new BFacetsMap(map).intern();
            x.string = s;
            return x;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Invalid BFacetsMap: " + s);
        }
    }

    private void escape(StringBuffer buf, String s) {
        int len = s.length();
        block7: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    buf.append("\\\\");
                    continue block7;
                }
                case '{': {
                    buf.append("\\{");
                    continue block7;
                }
                case '}': {
                    buf.append("\\}");
                    continue block7;
                }
                case '=': {
                    buf.append("\\=");
                    continue block7;
                }
                case ';': {
                    buf.append("\\;");
                    continue block7;
                }
                default: {
                    buf.append(c);
                }
            }
        }
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    static {
        DEFAULT = NULL = new BFacetsMap(new HashMap<String, BFacets>());
        TYPE = Sys.loadType(BFacetsMap.class);
    }
}

