/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import com.tridium.util.ArrayUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BEnumSet
extends BSimple {
    public static final BEnumSet NULL;
    public static final BEnumSet DEFAULT;
    public static final Type TYPE;
    private int[] ordinals;
    private BEnumRange range;
    private int hashCode = -1;

    public static BEnumSet make(int[] ordinal, BEnumRange range) {
        if (range == null) {
            range = BEnumRange.NULL;
        }
        return (BEnumSet)new BEnumSet(ordinal, range).intern();
    }

    public static BEnumSet make(int[] ordinals) {
        return BEnumSet.make(ordinals, BEnumRange.NULL);
    }

    private BEnumSet(int[] ordinals, BEnumRange range) {
        ordinals = (int[])ordinals.clone();
        ArrayUtil.sort(ordinals);
        this.ordinals = ordinals;
        this.range = range;
    }

    public int[] getOrdinals() {
        return (int[])this.ordinals.clone();
    }

    public boolean contains(int ordinal) {
        return ArrayUtil.binarySearch(this.ordinals, ordinal) != -1;
    }

    public BEnumRange getRange() {
        return this.range;
    }

    @Override
    public boolean isNull() {
        return this.ordinals.length == 0;
    }

    @Override
    public int hashCode() {
        try {
            if (this.hashCode == -1) {
                this.hashCode = this.encodeToString().hashCode();
            }
            return this.hashCode;
        }
        catch (Exception e) {
            return System.identityHashCode(this);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BEnumSet) {
            BEnumSet x = (BEnumSet)obj;
            if (this.ordinals.length != x.ordinals.length) {
                return false;
            }
            for (int i = 0; i < this.ordinals.length; ++i) {
                if (this.ordinals[i] == x.ordinals[i]) continue;
                return false;
            }
            return this.range.equals(x.range);
        }
        return false;
    }

    @Override
    public String toString(Context context) {
        BEnumRange r;
        BEnumRange range = this.range;
        if (context != null && (r = (BEnumRange)context.getFacet("range")) != null) {
            range = r;
        }
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < this.ordinals.length; ++i) {
            if (i > 0) {
                s.append(',');
            }
            s.append(range.getDisplayTag(this.ordinals[i], context));
        }
        return s.toString();
    }

    @Override
    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    @Override
    public BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    @Override
    public String encodeToString() throws IOException {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < this.ordinals.length; ++i) {
            if (i > 0) {
                s.append(',');
            }
            s.append(this.ordinals[i]);
        }
        if (!this.range.isNull()) {
            s.append('@').append(this.range.encodeToString());
        }
        return s.toString();
    }

    @Override
    public BObject decodeFromString(String s) throws IOException {
        BEnumRange range = null;
        int at = s.indexOf(64);
        if (at > 0) {
            range = (BEnumRange)BEnumRange.DEFAULT.decodeFromString(s.substring(at + 1));
            s = s.substring(0, at);
        }
        int[] temp = new int[s.length() / 2 + 1];
        int n = 0;
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreTokens()) {
            temp[n++] = Integer.parseInt(st.nextToken());
        }
        int[] ordinals = new int[n];
        System.arraycopy(temp, 0, ordinals, 0, n);
        return BEnumSet.make(ordinals, range);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    static {
        DEFAULT = NULL = BEnumSet.make(new int[0], BEnumRange.NULL);
        TYPE = Sys.loadType(BEnumSet.class);
    }
}

