/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.user;

import com.tridium.authn.BAuthenticationService;
import com.tridium.authn.LoginFailureCause;
import com.tridium.nre.util.NreLicenseUtil;
import com.tridium.nre.util.SecurityManagerUtil;
import com.tridium.session.NiagaraSuperSession;
import com.tridium.session.SessionManager;
import com.tridium.sys.NreLib;
import com.tridium.sys.schema.ComponentSlotMap;
import com.tridium.user.AutoLogoffSettingsTransferUtil;
import com.tridium.user.BUserPasswordConfiguration;
import com.tridium.util.CompUtil;
import java.security.AccessController;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.category.BCategoryMask;
import javax.baja.license.Feature;
import javax.baja.license.LicenseException;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BNavFileNode;
import javax.baja.nav.NavFileDecoder;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.role.BIRole;
import javax.baja.role.BIRoleService;
import javax.baja.role.BRoleService;
import javax.baja.security.BAbstractAuthenticator;
import javax.baja.security.BIProtected;
import javax.baja.security.BPasswordAuthenticator;
import javax.baja.security.BPermissions;
import javax.baja.security.BPermissionsMap;
import javax.baja.security.PermissionException;
import javax.baja.space.BComponentSpace;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIUnlinkableSlotsContainer;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.Validatable;
import javax.baja.user.BAutoLogoffSettings;
import javax.baja.user.BUserPrototype;
import javax.baja.user.BUserPrototypeProperty;
import javax.baja.user.BUserService;
import javax.baja.user.PermissionsManager;
import javax.baja.util.BNotification;
import javax.baja.util.BServiceContainer;
import javax.baja.util.Lexicon;
import javax.baja.util.Queue;
import javax.security.auth.Subject;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="fullName", type="String", defaultValue=""), @NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="expiration", type="BAbsTime", defaultValue="BAbsTime.NULL", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"wbutil:ExpirationFE\"), BFacets.UX_FIELD_EDITOR, BString.make(\"webEditors:ExpirationEditor\"))")}), @NiagaraProperty(name="lockOut", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="permissions", type="BPermissionsMap", defaultValue="BPermissionsMap.DEFAULT", flags=7), @NiagaraProperty(name="language", type="String", defaultValue="", facets={@Facet(value="BFacets.make(BFacets.FIELD_WIDTH, BInteger.make(6))")}), @NiagaraProperty(name="email", type="String", defaultValue="", flags=256), @NiagaraProperty(name="authenticator", type="BAbstractAuthenticator", defaultValue="new BPasswordAuthenticator()", flags=256), @NiagaraProperty(name="facets", type="BFacets", defaultValue="BFacets.NULL", flags=256, facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"wbutil:UserFacetsFE\"), BFacets.UX_FIELD_EDITOR, BString.make(\"webEditors:UserFacetsEditor\"))")}), @NiagaraProperty(name="navFile", type="BOrd", defaultValue="BOrd.NULL"), @NiagaraProperty(name="prototypeName", type="String", defaultValue="", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"workbench:UserPrototypeFE\"), BFacets.UX_FIELD_EDITOR, BString.make(\"webEditors:UserPrototypeEditor\"))")}), @NiagaraProperty(name="networkUser", type="boolean", defaultValue="false", facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"wbutil:NetworkUserFE\"")}), @NiagaraProperty(name="version", type="String", defaultValue="", flags=5), @NiagaraProperty(name="prototypeVersion", type="String", defaultValue="", flags=5), @NiagaraProperty(name="cellPhoneNumber", type="String", defaultValue="", flags=256), @NiagaraProperty(name="authenticationSchemeName", type="String", defaultValue="DigestScheme", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"wbutil:AuthenticationSchemeFE\"), BFacets.UX_FIELD_EDITOR, BString.make(\"webEditors:AuthenticationSchemeEditor\"), BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="roles", type="String", defaultValue="", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"wbutil:RoleFE\"), BFacets.UX_FIELD_EDITOR, BString.make(\"webEditors:RolesEditor\"), BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="allowConcurrentSessions", type="boolean", defaultValue="true", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="autoLogoffSettings", type="BAutoLogoffSettings", defaultValue="new BAutoLogoffSettings()", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="typeVersion", type="int", defaultValue="0", flags=5)})
@NiagaraActions(value={@NiagaraAction(name="clearLockOut"), @NiagaraAction(name="setModified")})
public class BUser
extends BComponent
implements BIUnlinkableSlotsContainer,
BIStatus,
Context,
Principal {
    public static final Property fullName = BUser.newProperty(0, "", null);
    public static final Property enabled = BUser.newProperty(0, true, null);
    public static final Property expiration = BUser.newProperty(0, BAbsTime.NULL, BFacets.make("fieldEditor", BString.make("wbutil:ExpirationFE"), "uxFieldEditor", BString.make("webEditors:ExpirationEditor")));
    public static final Property lockOut = BUser.newProperty(1, false, null);
    public static final Property permissions = BUser.newProperty(7, BPermissionsMap.DEFAULT, null);
    public static final Property language = BUser.newProperty(0, "", BFacets.make("fieldWidth", BInteger.make(6)));
    public static final Property email = BUser.newProperty(256, "", null);
    public static final Property authenticator = BUser.newProperty(256, new BPasswordAuthenticator(), null);
    public static final Property facets = BUser.newProperty(256, BFacets.NULL, BFacets.make("fieldEditor", BString.make("wbutil:UserFacetsFE"), "uxFieldEditor", BString.make("webEditors:UserFacetsEditor")));
    public static final Property navFile = BUser.newProperty(0, BOrd.NULL, null);
    public static final Property prototypeName = BUser.newProperty(0, "", BFacets.make("fieldEditor", BString.make("workbench:UserPrototypeFE"), "uxFieldEditor", BString.make("webEditors:UserPrototypeEditor")));
    public static final Property networkUser = BUser.newProperty(0, false, BFacets.make("fieldEditor", "wbutil:NetworkUserFE"));
    public static final Property version = BUser.newProperty(5, "", null);
    public static final Property prototypeVersion = BUser.newProperty(5, "", null);
    public static final Property cellPhoneNumber = BUser.newProperty(256, "", null);
    public static final Property authenticationSchemeName = BUser.newProperty(0, "DigestScheme", BFacets.make("fieldEditor", BString.make("wbutil:AuthenticationSchemeFE"), "uxFieldEditor", BString.make("webEditors:AuthenticationSchemeEditor"), "security", BBoolean.TRUE));
    public static final Property roles = BUser.newProperty(0, "", BFacets.make("fieldEditor", BString.make("wbutil:RoleFE"), "uxFieldEditor", BString.make("webEditors:RolesEditor"), "security", BBoolean.TRUE));
    public static final Property allowConcurrentSessions = BUser.newProperty(0, true, BFacets.make("security", BBoolean.TRUE));
    public static final Property autoLogoffSettings = BUser.newProperty(0, new BAutoLogoffSettings(), BFacets.make("security", BBoolean.TRUE));
    public static final Property typeVersion = BUser.newProperty(5, 0, null);
    public static final Action clearLockOut = BUser.newAction(0, null);
    public static final Action setModified = BUser.newAction(0, null);
    public static final Type TYPE = Sys.loadType(BUser.class);
    private static final BIcon icon = BIcon.std("user.png");
    private static final Set<Slot> UNLINKABLE_SLOTS = Collections.singleton(roles);
    private boolean pushNotification = false;
    private Clock.Ticket lockoutTicket;
    static final Logger log = Logger.getLogger("sys.service");
    static final BOrd DEFAULT_HOME_PAGE = BOrd.make("station:|slot:/");
    private static volatile boolean checkLicense = true;
    private static boolean guestLicensed;
    private static final Context authSchemeChanged;
    private final Object ROLE_LOCK = new Object();
    public static final String ROLE_DELIMITER = ",";
    Queue authFailTimes = new Queue();

    public String getFullName() {
        return this.getString(fullName);
    }

    public void setFullName(String v) {
        this.setString(fullName, v, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BAbsTime getExpiration() {
        return (BAbsTime)this.get(expiration);
    }

    public void setExpiration(BAbsTime v) {
        this.set(expiration, (BValue)v, null);
    }

    public boolean getLockOut() {
        return this.getBoolean(lockOut);
    }

    public void setLockOut(boolean v) {
        this.setBoolean(lockOut, v, null);
    }

    public BPermissionsMap getPermissions() {
        return (BPermissionsMap)this.get(permissions);
    }

    public void setPermissions(BPermissionsMap v) {
        this.set(permissions, (BValue)v, null);
    }

    @Override
    public String getLanguage() {
        return this.getString(language);
    }

    public void setLanguage(String v) {
        this.setString(language, v, null);
    }

    public String getEmail() {
        return this.getString(email);
    }

    public void setEmail(String v) {
        this.setString(email, v, null);
    }

    public BAbstractAuthenticator getAuthenticator() {
        return (BAbstractAuthenticator)this.get(authenticator);
    }

    public void setAuthenticator(BAbstractAuthenticator v) {
        this.set(authenticator, (BValue)v, null);
    }

    @Override
    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public BOrd getNavFile() {
        return (BOrd)this.get(navFile);
    }

    public void setNavFile(BOrd v) {
        this.set(navFile, (BValue)v, null);
    }

    public String getPrototypeName() {
        return this.getString(prototypeName);
    }

    public void setPrototypeName(String v) {
        this.setString(prototypeName, v, null);
    }

    public boolean getNetworkUser() {
        return this.getBoolean(networkUser);
    }

    public void setNetworkUser(boolean v) {
        this.setBoolean(networkUser, v, null);
    }

    public String getVersion() {
        return this.getString(version);
    }

    public void setVersion(String v) {
        this.setString(version, v, null);
    }

    public String getPrototypeVersion() {
        return this.getString(prototypeVersion);
    }

    public void setPrototypeVersion(String v) {
        this.setString(prototypeVersion, v, null);
    }

    public String getCellPhoneNumber() {
        return this.getString(cellPhoneNumber);
    }

    public void setCellPhoneNumber(String v) {
        this.setString(cellPhoneNumber, v, null);
    }

    public String getAuthenticationSchemeName() {
        return this.getString(authenticationSchemeName);
    }

    public void setAuthenticationSchemeName(String v) {
        this.setString(authenticationSchemeName, v, null);
    }

    public String getRoles() {
        return this.getString(roles);
    }

    public void setRoles(String v) {
        this.setString(roles, v, null);
    }

    public boolean getAllowConcurrentSessions() {
        return this.getBoolean(allowConcurrentSessions);
    }

    public void setAllowConcurrentSessions(boolean v) {
        this.setBoolean(allowConcurrentSessions, v, null);
    }

    public BAutoLogoffSettings getAutoLogoffSettings() {
        return (BAutoLogoffSettings)this.get(autoLogoffSettings);
    }

    public void setAutoLogoffSettings(BAutoLogoffSettings v) {
        this.set(autoLogoffSettings, (BValue)v, null);
    }

    public int getTypeVersion() {
        return this.getInt(typeVersion);
    }

    public void setTypeVersion(int v) {
        this.setInt(typeVersion, v, null);
    }

    public void clearLockOut() {
        this.invoke(clearLockOut, null, null);
    }

    public void setModified() {
        this.invoke(setModified, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    static BUser makeGuest() {
        BUser u = new BUser();
        u.setEnabled(false);
        u.checkGuest();
        return u;
    }

    private void checkGuest() {
        BComplex userService;
        if (!this.isRunning()) {
            return;
        }
        if (checkLicense) {
            try {
                Feature stationFeature = Sys.getLicenseManager().getFeature("tridium", NreLicenseUtil.getStationLicenseFeature((String)NreLib.getHostId()));
                guestLicensed = stationFeature.getb("guestEnabled", false);
            }
            catch (LicenseException e) {
                guestLicensed = false;
            }
            checkLicense = false;
            if (!guestLicensed && log.isLoggable(Level.FINE)) {
                log.fine("Guest user account not licensed. Guest user is disabled.");
            }
        }
        if (guestLicensed) {
            userService = this.getParent();
            Property prop = this.getPropertyInParent();
            if (userService != null && prop != null) {
                int flags = userService.getFlags(prop);
                if ((flags & 4) != 0) {
                    flags &= 0xFFFFFFFB;
                }
                if ((flags & 1) != 0) {
                    flags &= 0xFFFFFFFE;
                }
                userService.setFlags(prop, flags);
                Flags.setAllReadonly(this, false, null);
            }
        } else {
            if (this.getEnabled()) {
                this.setEnabled(false);
            }
            userService = this.getParent();
            Property prop = this.getPropertyInParent();
            if (userService != null && prop != null) {
                int flags = userService.getFlags(prop);
                if ((flags & 4) == 0) {
                    flags |= 4;
                }
                if ((flags & 1) == 0) {
                    flags |= 1;
                }
                userService.setFlags(prop, flags);
                Flags.setAllReadonly(this, true, null);
            }
        }
    }

    public String getUsername() {
        String name = this.getName();
        if (name == null) {
            return "";
        }
        return SlotPath.unescape(name);
    }

    public boolean isExpired() {
        return BUser.isExpired(this.getExpiration());
    }

    public static boolean isExpired(BAbsTime expiration) {
        if (expiration.isNull()) {
            return false;
        }
        return expiration.getMillis() < Clock.millis();
    }

    public BOrd getHomePage() {
        try {
            BOrd navFile = this.getNavFile();
            if (!navFile.isNull()) {
                BNavFileNode root = NavFileDecoder.load(navFile).getRootNode();
                return root.getOrdInSession();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return DEFAULT_HOME_PAGE;
    }

    @Override
    public final Context getBase() {
        return null;
    }

    @Override
    public final BUser getUser() {
        return this;
    }

    @Override
    public final BObject getFacet(String name) {
        return this.getFacets().get(name);
    }

    @Override
    public BStatus getStatus() {
        int bits = 0;
        if (!this.getEnabled()) {
            bits |= 1;
        }
        if (this.isExpired()) {
            bits |= 2;
        }
        if (this.getLockOut()) {
            bits |= 8;
        }
        return BStatus.make(bits);
    }

    public BAuthenticationScheme getAuthenticationScheme() {
        BAuthenticationService authnService;
        block4: {
            authnService = null;
            try {
                authnService = (BAuthenticationService)Sys.getService(BAuthenticationService.TYPE);
            }
            catch (ServiceNotFoundException e) {
                BComplex parent;
                for (parent = this.getParent(); parent != null && !(parent instanceof BServiceContainer); parent = parent.getParent()) {
                }
                if (parent == null) break block4;
                BServiceContainer serviceContainer = (BServiceContainer)parent;
                serviceContainer.lease(3);
                BAuthenticationService[] services = serviceContainer.getChildren(BAuthenticationService.class);
                if (services.length <= 0) break block4;
                authnService = services[0];
            }
        }
        if (authnService == null) {
            return null;
        }
        authnService.lease(3);
        return authnService.getAuthenticationScheme(this.getAuthenticationSchemeName());
    }

    public void authenticateOk(BUserService service) {
        this.authFailTimes.clear();
    }

    public void authenticateFailed(BUserService service) {
        if (!service.getLockOutEnabled()) {
            return;
        }
        BAbsTime now = BAbsTime.now();
        this.authFailTimes.enqueue(now);
        BAbsTime startOfWindow = now.subtract(service.getLockOutWindow());
        while (((BAbsTime)this.authFailTimes.peek()).isBefore(startOfWindow)) {
            this.authFailTimes.dequeue();
        }
        if (this.authFailTimes.size() >= service.getMaxBadLoginsBeforeLockOut()) {
            this.setLockOut(true);
            this.authenticateOk(service);
            if (this.lockoutTicket != null) {
                this.lockoutTicket.cancel();
            }
            this.lockoutTicket = Clock.schedule((BComponent)this, service.getLockOutPeriod(), clearLockOut, null);
        }
    }

    public void doClearLockOut() {
        this.setLockOut(false);
    }

    public boolean hasRole(String roleId) {
        return this.getRoleIds().contains(roleId);
    }

    public Set<BIRole> getRoleSet() {
        try {
            return this.getRoleSet(BRoleService.getService());
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            return Collections.emptySet();
        }
    }

    private Set<BIRole> getRoleSet(BIRoleService service) {
        String[] roles;
        TreeSet<BIRole> set = new TreeSet<BIRole>();
        for (String role : roles = this.getRoles().split(ROLE_DELIMITER)) {
            BIRole r = service.getRole(role);
            if (r == null) continue;
            set.add(r);
        }
        return set;
    }

    public Set<String> getRoleIds() {
        return BUser.splitRoles(this.getRoles());
    }

    public static Set<String> splitRoles(String roles) {
        String[] roleArray = roles.split(ROLE_DELIMITER);
        if (roleArray.length > 0) {
            TreeSet<String> set = new TreeSet<String>();
            for (String role : roleArray) {
                if (role == null || role.isEmpty()) continue;
                set.add(SlotPath.unescape(role));
            }
            return set;
        }
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRole(String roleIdentifier, Context cx) {
        Object object = this.ROLE_LOCK;
        synchronized (object) {
            Set<String> set = this.getRoleIds();
            set.add(roleIdentifier);
            this.setRoles(BUser.delimitRoles(set, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRole(BIRoleService source, String roleIdentifier, Context cx) {
        Object object = this.ROLE_LOCK;
        synchronized (object) {
            Set<String> set = this.getRoleIds();
            set.remove(roleIdentifier);
            this.setRoles(BUser.delimitRoles(set, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameRole(BIRoleService source, String oldIdentifier, String newIdentifier, Context cx) {
        Object object = this.ROLE_LOCK;
        synchronized (object) {
            Set<String> set = this.getRoleIds();
            set.remove(oldIdentifier);
            set.add(newIdentifier);
            this.setRoles(BUser.delimitRoles(set, true));
        }
    }

    @Override
    public IPropertyValidator getPropertyValidator(Property property, Context context) {
        if (property == roles) {
            return new IPropertyValidator(){

                @Override
                public void validateSet(Validatable validatable, Context context) {
                    if (context != null && context.getUser() != null) {
                        String oldRoles = ((BString)validatable.getExistingValue(roles)).getString();
                        String newRoles = ((BString)validatable.getProposedValue(roles)).getString();
                        BUser.checkRoleChange(context.getUser(), oldRoles, newRoles);
                    }
                }
            };
        }
        return null;
    }

    public static void checkRoleChange(BUser user, String oldRoles, String newRoles) {
        if (user.getPermissions().isSuperUser()) {
            return;
        }
        Set<String> allowedRoles = BUser.splitRoles(user.getRoles());
        allowedRoles.addAll(BUser.splitRoles(oldRoles));
        if (!allowedRoles.containsAll(BUser.splitRoles(newRoles))) {
            throw new RuntimeException("cannot set role");
        }
    }

    public void changedRole(BIRoleService source, String roleIdentifier, Context cx) {
        if (this.hasRole(roleIdentifier)) {
            this.updatePermissions();
        }
    }

    public static String delimitRoles(Set<String> roles) {
        return BUser.delimitRoles(roles, false);
    }

    private static String delimitRoles(Set<String> roles, boolean escape) {
        StringJoiner roleString = new StringJoiner(ROLE_DELIMITER);
        for (String role : roles) {
            if (role == null) continue;
            roleString.add(escape ? SlotPath.escape(role) : role);
        }
        return roleString.toString();
    }

    protected void updatePermissions() {
        if (this.isRunning()) {
            this.setPermissions(this.getRoleBasedPermissions());
        }
    }

    public BPermissionsMap getRoleBasedPermissions() {
        try {
            BRoleService service = BRoleService.getService();
            if (service != null) {
                return this.getPermissions(service);
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
        return BPermissionsMap.DEFAULT;
    }

    public BPermissionsMap getPermissions(BIRoleService service) {
        BPermissionsMap rbac = BPermissionsMap.DEFAULT;
        for (BIRole role : this.getRoleSet(service)) {
            if (!role.getEnabled()) continue;
            BPermissionsMap pMap = role.getPermissions();
            if (pMap.isSuperUser()) {
                return BPermissionsMap.SUPER_USER;
            }
            rbac = rbac.or(pMap);
        }
        return rbac;
    }

    private BPermissionsMap getPermissionsMap(BIProtected target) {
        if (this.getParent() instanceof BUserService) {
            PermissionsManager[] pmgrs;
            BUserService service = (BUserService)this.getParent();
            for (PermissionsManager pmgr : pmgrs = AccessController.doPrivileged(() -> service.getPermissionsManagers())) {
                BPermissionsMap altMap = pmgr.getPermissionsMap(this, target);
                if (altMap == null) continue;
                return altMap;
            }
        }
        return this.getPermissions();
    }

    @Override
    public BPermissions getPermissions(Context cx) {
        BPermissions permissions = super.getPermissions(cx);
        BUser user = null;
        if (cx != null) {
            user = cx.getUser();
        }
        if (user == null) {
            return permissions;
        }
        if (user != this) {
            if (!permissions.hasAdminRead()) {
                return BPermissions.none;
            }
            if (!permissions.hasAdminWrite()) {
                permissions = BPermissions.make(permissions.getMask() & 0xFFFFFFFD);
            } else if (this.getPermissions().isSuperUser() && !user.getPermissions().isSuperUser()) {
                permissions = BPermissions.make(permissions.getMask() & 0xFFFFFFDF);
                permissions = BPermissions.make(permissions.getMask() & 0xFFFFFFFD);
            }
        }
        return permissions;
    }

    public BPermissions getPermissionsFor(BIProtected target) {
        BAbstractAuthenticator authenticator;
        Optional<BUser> user;
        BComponent comp;
        BCategoryMask deepOrCat;
        BPermissions deepOrPerm;
        BPermissions permissions;
        BCategoryMask categoryMask = target.getAppliedCategoryMask();
        if (target instanceof BComponent && !((BComponent)target).isMounted() && categoryMask.isNull()) {
            return BPermissions.all;
        }
        BPermissionsMap pmap = this.getPermissions();
        if (!pmap.isSuperUser()) {
            pmap = this.getPermissionsMap(target);
        }
        if (!(permissions = pmap.getCategoryPermissions(categoryMask)).hasOperatorRead() && (target instanceof BComponent || target instanceof BComponentSpace) && (deepOrPerm = pmap.getCategoryPermissions(deepOrCat = ((ComponentSlotMap)(comp = target instanceof BComponent ? (BComponent)target : ((BComponentSpace)target).getRootComponent()).fw(1)).getDeepOrCategoryMask())).getMask() != 0) {
            permissions = BPermissions.operatorRead;
        }
        if (target instanceof BComplex && (user = CompUtil.closestAncestor((BComplex)((Object)target), BUser.class)).isPresent()) {
            target = user.get();
        }
        if (target instanceof BUser && target != this && !pmap.isSuperUser() && ((BUser)target).getPermissions().isSuperUser()) {
            permissions = BPermissions.make(permissions.getMask() & 0xFFFFFFDF);
            permissions = BPermissions.make(permissions.getMask() & 0xFFFFFFFD);
        }
        if ((authenticator = this.getAuthenticator()) instanceof BPasswordAuthenticator && ((BPasswordAuthenticator)authenticator).getPasswordConfig().getForceResetAtNextLogin()) {
            permissions = target == this.getComponentSpace() ? BPermissions.make(permissions.getMask() & 1) : BPermissions.none;
        }
        return permissions;
    }

    public void check(BIProtected target, BPermissions required) throws PermissionException {
        BPermissions actual = this.getPermissionsFor(target);
        if (!actual.has(required)) {
            throw new PermissionException(actual + " < " + required);
        }
    }

    public void checkRead(BComponent target, Slot slot) {
        if (Flags.isOperator(target, slot)) {
            this.check(target, BPermissions.operatorRead);
        } else {
            this.check(target, BPermissions.adminRead);
        }
    }

    public void checkWrite(BComponent target, Slot slot) {
        if (target instanceof BUser && target.isMounted() && ((BUser)target).getPermissions().isSuperUser() && !this.getPermissions().isSuperUser()) {
            throw new PermissionException("SuperUser required");
        }
        if (Flags.isOperator(target, slot)) {
            this.check(target, BPermissions.operatorWrite);
        } else {
            this.check(target, BPermissions.adminWrite);
        }
    }

    public void checkInvoke(BComponent target, Slot slot) {
        if (Flags.isOperator(target, slot)) {
            this.check(target, BPermissions.operatorInvoke);
        } else {
            this.check(target, BPermissions.adminInvoke);
        }
    }

    @Override
    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 11: {
                this.fwStarted();
                break;
            }
            case 13: {
                this.fwDescendantsStarted();
                break;
            }
            case 2: {
                BComponentSpace space = this.getComponentSpace();
                if (space != null && !space.fireDirectCallbacks()) break;
                this.fwChanged((Property)a, (Context)b);
                break;
            }
            case 23: {
                this.fwStationStarted();
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private void fwStarted() {
        BComplex parent = this.getParent();
        if (parent instanceof BUserService) {
            if (this.getName().equals("guest")) {
                this.checkGuest();
            }
            if (this.getLockOut()) {
                Clock.schedule((BComponent)this, ((BUserService)parent).getLockOutPeriod(), clearLockOut, null);
            }
        } else if (this.getLockOut()) {
            this.setLockOut(false);
        }
        if (this.getVersion().isEmpty()) {
            this.updateVersion();
        }
        this.updatePermissions();
        if (this.pushNotification) {
            this.doPushNotification(this.getName());
            this.pushNotification = false;
        }
    }

    private void fwChanged(Property prop, Context cx) {
        BComplex parent = this.getParent();
        if (parent instanceof BUserService && "guest".equals(this.getName())) {
            this.checkGuest();
        }
        if (this.isRunning()) {
            this.updatePermissions();
            if (prop.equals(prototypeName)) {
                this.setPrototypeVersion("");
            }
        }
    }

    @Override
    public void changed(Property property, Context context) {
        BComplex parent;
        super.changed(property, context);
        if (property.equals(authenticationSchemeName) && Sys.isStationStarted()) {
            BAbstractAuthenticator auth = this.getAuthenticationScheme().getDefaultAuthenticator();
            if (!this.getAuthenticator().getType().getTypeSpec().equals(auth.getType().getTypeSpec())) {
                BAbstractAuthenticator oldAuth = this.getAuthenticator();
                if (auth instanceof BPasswordAuthenticator && oldAuth instanceof BPasswordAuthenticator) {
                    ((BPasswordAuthenticator)auth).setPassword(((BPasswordAuthenticator)oldAuth).getPassword());
                    ((BPasswordAuthenticator)auth).setPasswordConfig((BUserPasswordConfiguration)((BPasswordAuthenticator)oldAuth).getPasswordConfig().newCopy(true));
                }
                this.set(authenticator, (BValue)auth, authSchemeChanged);
                if (this.isRunning()) {
                    this.doPushNotification(this.getName());
                } else if (context == Context.decoding) {
                    this.pushNotification = true;
                }
            }
        }
        if (Sys.isStationStarted() && this.isMounted()) {
            BAbstractAuthenticator authenticator;
            if (property.equals(enabled) && !this.getEnabled() || property.equals(expiration) && this.isExpired()) {
                AccessController.doPrivileged(() -> {
                    SessionManager.invalidateSuperSessions(this);
                    return null;
                });
            }
            if (property.equals(BUser.authenticator) && (authenticator = this.getAuthenticator()) instanceof BPasswordAuthenticator && ((BPasswordAuthenticator)authenticator).getPasswordConfig().getForceResetAtNextLogin()) {
                AccessController.doPrivileged(() -> {
                    SessionManager.invalidateSuperSessions(this, LoginFailureCause.PASSWORD_RESET_REQUIRED);
                    return null;
                });
            }
            if (property.equals(allowConcurrentSessions) && !this.getAllowConcurrentSessions() || property.equals(authenticationSchemeName)) {
                HashSet<String> excludedIds = new HashSet<String>();
                NiagaraSuperSession currentSession = SessionManager.getCurrentNiagaraSuperSession();
                if (currentSession != null) {
                    excludedIds.add(currentSession.getId());
                }
                AccessController.doPrivileged(() -> {
                    SessionManager.invalidateSuperSessions(this, excludedIds);
                    return null;
                });
            }
            if (property.equals(autoLogoffSettings)) {
                SessionManager.updateSessionTimeout(this);
            }
        }
        if ((parent = this.getParent()) instanceof BUserService) {
            BValue prop;
            String prototypeName = this.getPrototypeName();
            BValue prototype = ((BUserService)parent).getUserPrototypes().get(prototypeName);
            if (prototype instanceof BUserPrototype && (prop = ((BUserPrototype)prototype).get(property.getName())) instanceof BUserPrototypeProperty && ((BUserPrototypeProperty)prop).getOverridable()) {
                this.setFlags(property, this.getFlags(property) | 0x10000000);
            }
        }
    }

    private void fwDescendantsStarted() {
    }

    private void fwStationStarted() {
        if (this.getTypeVersion() == 0) {
            AutoLogoffSettingsTransferUtil.transferAutoLogoffSettings(this);
            this.setTypeVersion(1);
        }
    }

    @Override
    public String toString(Context cx) {
        return this.getUsername();
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }

    public void doSetModified() {
        BComponent parent = (BComponent)this.getParent();
        if (parent instanceof BUserService) {
            ((BUserService)parent).setModified(this);
        } else {
            this.updateVersion();
        }
    }

    public void updateVersion() {
        String station = "";
        if (Sys.getStation() != null) {
            station = Sys.getStation().getStationName();
        }
        this.setVersion(station + ':' + System.currentTimeMillis());
    }

    public static BUser getUserFromSubject(Subject subject) {
        if (subject != null) {
            Set<BUser> principals = subject.getPrincipals(BUser.class);
            for (BUser user : principals) {
                if (user == null) continue;
                return user;
            }
        }
        return null;
    }

    public static BUser getCurrentAuthenticatedUser() {
        Subject subject = SecurityManagerUtil.getCurrentAuthenticatedSubject();
        if (subject != null) {
            return BUser.getUserFromSubject(subject);
        }
        return null;
    }

    private void doPushNotification(String name) {
        BNotification notify = new BNotification();
        String title = Lexicon.make("baja").getText("user.authenticationScheme.changed.title");
        notify.add("title", BString.make(title));
        String message = Lexicon.make("baja").getText("user.authenticationScheme.changed.text", name);
        notify.add("message", BString.make(message));
        notify.raise(false);
    }

    @Override
    public final Set<Slot> getUnlinkableSourceSlots(Context context) {
        return UNLINKABLE_SLOTS;
    }

    @Override
    public final Set<Slot> getUnlinkableTargetSlots(Context context) {
        return UNLINKABLE_SLOTS;
    }

    static {
        authSchemeChanged = new BasicContext(){

            public boolean equals(Object obj) {
                return this == obj;
            }

            public int hashCode() {
                return this.toString().hashCode();
            }

            @Override
            public String toString() {
                return "Context.authSchemeChanged";
            }
        };
    }
}

