/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.user;

import com.tridium.nre.security.PasswordStrength;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.baja.sync.BProxyComponentSpace;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaException;
import javax.baja.sys.Context;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.Localizable;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.Validatable;
import javax.baja.util.LexiconText;

public class BPasswordStrength
extends BStruct
implements IPropertyValidator {
    public static final Property minimumLength = BPasswordStrength.newProperty(0, 10, BFacets.make("min", 0));
    public static final Property minimumLowerCase = BPasswordStrength.newProperty(0, 1, BFacets.make("min", 0));
    public static final Property minimumUpperCase = BPasswordStrength.newProperty(0, 1, BFacets.make("min", 0));
    public static final Property minimumDigits = BPasswordStrength.newProperty(0, 1, BFacets.make("min", 0));
    public static final Property minimumSpecial = BPasswordStrength.newProperty(0, 0, BFacets.make("min", 0));
    public static final Type TYPE = Sys.loadType(BPasswordStrength.class);
    public static final BPasswordStrength DEFAULT = new BPasswordStrength(PasswordStrength.DEFAULT);
    public static final BPasswordStrength FIPS_1 = new BPasswordStrength(PasswordStrength.FIPS_1);
    public static final BPasswordStrength STRONG = DEFAULT;
    public static final BPasswordStrength OFF = new BPasswordStrength(0, 0, 0, 0, 0);

    public int getMinimumLength() {
        return this.getInt(minimumLength);
    }

    public void setMinimumLength(int v) {
        this.setInt(minimumLength, v, null);
    }

    public int getMinimumLowerCase() {
        return this.getInt(minimumLowerCase);
    }

    public void setMinimumLowerCase(int v) {
        this.setInt(minimumLowerCase, v, null);
    }

    public int getMinimumUpperCase() {
        return this.getInt(minimumUpperCase);
    }

    public void setMinimumUpperCase(int v) {
        this.setInt(minimumUpperCase, v, null);
    }

    public int getMinimumDigits() {
        return this.getInt(minimumDigits);
    }

    public void setMinimumDigits(int v) {
        this.setInt(minimumDigits, v, null);
    }

    public int getMinimumSpecial() {
        return this.getInt(minimumSpecial);
    }

    public void setMinimumSpecial(int v) {
        this.setInt(minimumSpecial, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BPasswordStrength() {
    }

    public BPasswordStrength(int len, int lower, int upper, int digits, int special) {
        this.setMinimumLength(len);
        this.setMinimumLowerCase(lower);
        this.setMinimumUpperCase(upper);
        this.setMinimumDigits(digits);
        this.setMinimumSpecial(special);
    }

    public BPasswordStrength(PasswordStrength passwordStrength) {
        this.setMinimumLength(passwordStrength.getMinimumLength());
        this.setMinimumLowerCase(passwordStrength.getMinimumLowerCase());
        this.setMinimumUpperCase(passwordStrength.getMinimumUpperCase());
        this.setMinimumDigits(passwordStrength.getMinimumDigits());
        this.setMinimumSpecial(passwordStrength.getMinimumSpecial());
    }

    public boolean isPasswordValid(char[] password, Consumer<Localizable> messageConsumer) {
        if (messageConsumer == null) {
            messageConsumer = context -> {};
        }
        int lowerCase = 0;
        int upperCase = 0;
        int digits = 0;
        int special = 0;
        int len = password.length;
        for (char character : password) {
            if (Character.isLetter(character)) {
                if (Character.isUpperCase(character)) {
                    ++upperCase;
                    continue;
                }
                ++lowerCase;
                continue;
            }
            if (Character.isDigit(character)) {
                ++digits;
                continue;
            }
            ++special;
        }
        if (len < this.getMinimumLength() || digits < this.getMinimumDigits() || lowerCase < this.getMinimumLowerCase() || upperCase < this.getMinimumUpperCase() || special < this.getMinimumSpecial()) {
            ArrayList<Localizable> errors = new ArrayList<Localizable>();
            errors.add(LexiconText.toLocalizable("baja", "user.password.notStrong", new Object[0]));
            errors.addAll(this.getLocalizableRequirements());
            messageConsumer.accept(Localizable.concatenate("\n- ", errors));
            return false;
        }
        return true;
    }

    public void isPasswordValid(String password) throws Exception {
        AtomicReference messageRef = new AtomicReference();
        if (!this.isPasswordValid(password.toCharArray(), messageRef::set)) {
            throw new BajaException(((Localizable)messageRef.get()).toString(null));
        }
    }

    @Override
    public void validateSet(Validatable validatable, Context context) {
        BInteger existingMinimumLength;
        BInteger proposedMinimumLength;
        BComponent parent = this.getParentComponent();
        if (parent != null && !(parent.getSpace() instanceof BProxyComponentSpace) && !(proposedMinimumLength = (BInteger)validatable.getProposedValue(minimumLength)).equals(existingMinimumLength = (BInteger)validatable.getExistingValue(minimumLength)) && proposedMinimumLength.getNumeric() < (double)PasswordStrength.MINIMUM_ALLOWED_LENGTH) {
            throw new LocalizableRuntimeException("baja", "passwordStrength.notEnoughCharacters", new Object[]{PasswordStrength.MINIMUM_ALLOWED_LENGTH});
        }
    }

    @Override
    public void validateSet(BComplex instance, Property property, BValue newValue, Context context) {
        BComponent parent = this.getParentComponent();
        if (parent != null && !(parent.getSpace() instanceof BProxyComponentSpace)) {
            BInteger proposedMinimumLength = (BInteger)newValue;
            if (minimumLength.equals(property) && proposedMinimumLength.getNumeric() < (double)PasswordStrength.MINIMUM_ALLOWED_LENGTH) {
                throw new LocalizableRuntimeException("baja", "passwordStrength.notEnoughCharacters", new Object[]{PasswordStrength.MINIMUM_ALLOWED_LENGTH});
            }
        }
    }

    @Override
    public IPropertyValidator getPropertyValidator(Property[] properties, Context context) {
        return this;
    }

    @Override
    public IPropertyValidator getPropertyValidator(Property property, Context context) {
        return this;
    }

    public List<Localizable> getLocalizableRequirements() {
        ArrayList<Localizable> requirements = new ArrayList<Localizable>();
        if (this.getMinimumLength() > 0) {
            requirements.add(LexiconText.toLocalizable("baja", "user.password.notLongEnough", this.getMinimumLength()));
        }
        if (this.getMinimumDigits() > 0) {
            requirements.add(LexiconText.toLocalizable("baja", "user.password.notEnoughDigits", this.getMinimumDigits()));
        }
        if (this.getMinimumLowerCase() > 0) {
            requirements.add(LexiconText.toLocalizable("baja", "user.password.notEnoughLowerCase", this.getMinimumLowerCase()));
        }
        if (this.getMinimumUpperCase() > 0) {
            requirements.add(LexiconText.toLocalizable("baja", "user.password.notEnoughUpperCase", this.getMinimumUpperCase()));
        }
        if (this.getMinimumSpecial() > 0) {
            requirements.add(LexiconText.toLocalizable("baja", "user.password.notEnoughSpecial", this.getMinimumSpecial()));
        }
        return requirements;
    }
}

