/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.units;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BDimension
extends BSimple {
    private static final HashMap<BDimension, BDimension> cache = new HashMap();
    public static final BDimension DEFAULT;
    public static final BDimension NULL;
    public static final Type TYPE;
    private int exp0;
    private int exp1;
    private String string;

    public static BDimension make(int meter, int kilogram, int second, int ampere, int kelvin, int mole, int candela) {
        return BDimension.make(meter, kilogram, second, ampere, kelvin, mole, candela, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BDimension make(int meter, int kilogram, int second, int ampere, int kelvin, int mole, int candela, int dollar) {
        BDimension dim = new BDimension();
        dim.exp0 = (meter & 0xFF) << 24 | (kilogram & 0xFF) << 16 | (second & 0xFF) << 8 | (ampere & 0xFF) << 0;
        dim.exp1 = (kelvin & 0xFF) << 24 | (mole & 0xFF) << 16 | (candela & 0xFF) << 8 | (dollar & 0xFF) << 0;
        HashMap<BDimension, BDimension> hashMap = cache;
        synchronized (hashMap) {
            BDimension dup = cache.get(dim);
            if (dup != null) {
                return dup;
            }
            cache.put(dim, dim);
            return dim;
        }
    }

    private BDimension() {
    }

    public final int getMeter() {
        return (byte)(this.exp0 >> 24 & 0xFF);
    }

    public final int getKilogram() {
        return (byte)(this.exp0 >> 16 & 0xFF);
    }

    public final int getSecond() {
        return (byte)(this.exp0 >> 8 & 0xFF);
    }

    public final int getAmpere() {
        return (byte)(this.exp0 >> 0 & 0xFF);
    }

    public final int getKelvin() {
        return (byte)(this.exp1 >> 24 & 0xFF);
    }

    public final int getMole() {
        return (byte)(this.exp1 >> 16 & 0xFF);
    }

    public final int getCandela() {
        return (byte)(this.exp1 >> 8 & 0xFF);
    }

    public final int getDollar() {
        return (byte)(this.exp1 >> 0 & 0xFF);
    }

    @Override
    public String toString(Context cx) {
        StringBuffer s = new StringBuffer();
        BDimension.append(s, "m", this.getMeter());
        BDimension.append(s, "kg", this.getKilogram());
        BDimension.append(s, "s", this.getSecond());
        BDimension.append(s, "A", this.getAmpere());
        BDimension.append(s, "K", this.getKelvin());
        BDimension.append(s, "mol", this.getMole());
        BDimension.append(s, "cd", this.getCandela());
        BDimension.append(s, "$", this.getDollar());
        return s.toString();
    }

    private static void append(StringBuffer s, String sym, int n) {
        if (n == 0) {
            return;
        }
        if (s.length() > 0) {
            s.append('\u00b7');
        }
        s.append(sym);
        if (n > 1) {
            if (n == 2) {
                s.append('\u00b2');
            } else if (n == 3) {
                s.append('\u00b3');
            } else {
                s.append(n);
            }
        } else if (n < 0) {
            s.append(n);
        }
    }

    @Override
    public final int hashCode() {
        return this.exp0 ^ this.exp1 << 1;
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj instanceof BDimension) {
            BDimension x = (BDimension)obj;
            return this.exp0 == x.exp0 && this.exp1 == x.exp1;
        }
        return false;
    }

    @Override
    public final void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    @Override
    public final BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    @Override
    public final String encodeToString() {
        if (this.string == null) {
            int dol;
            int cd;
            int mol;
            int K;
            int A;
            int sec;
            int kg;
            StringBuilder s = new StringBuilder();
            int m = this.getMeter();
            if (m != 0) {
                s.append('(').append('m');
                if (m != 1) {
                    s.append(m);
                }
                s.append(')');
            }
            if ((kg = this.getKilogram()) != 0) {
                s.append('(').append('k').append('g');
                if (kg != 1) {
                    s.append(kg);
                }
                s.append(')');
            }
            if ((sec = this.getSecond()) != 0) {
                s.append('(').append('s');
                if (sec != 1) {
                    s.append(sec);
                }
                s.append(')');
            }
            if ((A = this.getAmpere()) != 0) {
                s.append('(').append('A');
                if (A != 1) {
                    s.append(A);
                }
                s.append(')');
            }
            if ((K = this.getKelvin()) != 0) {
                s.append('(').append('K');
                if (K != 1) {
                    s.append(K);
                }
                s.append(')');
            }
            if ((mol = this.getMole()) != 0) {
                s.append('(').append("Mol");
                if (mol != 1) {
                    s.append(mol);
                }
                s.append(')');
            }
            if ((cd = this.getCandela()) != 0) {
                s.append('(').append("cd");
                if (cd != 1) {
                    s.append(cd);
                }
                s.append(')');
            }
            if ((dol = this.getDollar()) != 0) {
                s.append('(').append('$');
                if (dol != 1) {
                    s.append(dol);
                }
                s.append(')');
            }
            this.string = s.toString();
        }
        return this.string;
    }

    @Override
    public final BObject decodeFromString(String s) throws IOException {
        try {
            int m = 0;
            int kg = 0;
            int sec = 0;
            int A = 0;
            int K = 0;
            int mol = 0;
            int cd = 0;
            int dol = 0;
            int[] xRet = new int[1];
            int x = 0;
            int len = s.length();
            while (x < len) {
                if (s.charAt(x++) != '(') {
                    throw new Exception();
                }
                char c = s.charAt(x++);
                switch (c) {
                    case '$': {
                        dol = this.parseExp(s, x, xRet);
                        break;
                    }
                    case 'c': {
                        cd = this.parseExp(s, ++x, xRet);
                        break;
                    }
                    case 'm': {
                        m = this.parseExp(s, x, xRet);
                        break;
                    }
                    case 'k': {
                        kg = this.parseExp(s, ++x, xRet);
                        break;
                    }
                    case 's': {
                        sec = this.parseExp(s, x, xRet);
                        break;
                    }
                    case 'A': {
                        A = this.parseExp(s, x, xRet);
                        break;
                    }
                    case 'K': {
                        K = this.parseExp(s, x, xRet);
                        break;
                    }
                    case 'M': {
                        mol = this.parseExp(s, x += 2, xRet);
                        break;
                    }
                    default: {
                        throw new Exception();
                    }
                }
                x = xRet[0];
                if (s.charAt(x++) == ')') continue;
                throw new Exception();
            }
            return BDimension.make(m, kg, sec, A, K, mol, cd, dol);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new IOException(s);
        }
    }

    private int parseExp(String s, int x, int[] xRet) {
        boolean neg = false;
        char c = s.charAt(x);
        if (c == ')') {
            xRet[0] = x;
            return 1;
        }
        if (c == '-') {
            neg = true;
            ++x;
        }
        int exp = 0;
        while ((c = s.charAt(x)) != ')') {
            if (c < '0' || c > '9') {
                throw new IllegalArgumentException("not number: " + c);
            }
            exp = exp * 10 + (c - 48);
            ++x;
        }
        xRet[0] = x;
        if (neg) {
            return -exp;
        }
        return exp;
    }

    @Override
    public boolean isNull() {
        return this.equals(NULL);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    static {
        NULL = DEFAULT = BDimension.make(0, 0, 0, 0, 0, 0, 0);
        TYPE = Sys.loadType(BDimension.class);
    }
}

