/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.timezone;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.zone.ZoneOffsetTransition;
import java.time.zone.ZoneOffsetTransitionRule;
import java.time.zone.ZoneRules;
import java.time.zone.ZoneRulesException;
import java.time.zone.ZoneRulesProvider;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.sys.BTime;
import javax.baja.sys.BWeekday;
import javax.baja.timezone.BTimeZone;
import javax.baja.timezone.TimeZoneException;

public final class DstRule {
    public static final int UNDEFINED = -1;
    public static final short WALL_TIME = 0;
    public static final short STANDARD_TIME = 1;
    public static final short UTC_TIME = 2;
    public static final int WEEKDAY = -1;
    public static final short EXACT = 0;
    public static final short ON_OR_AFTER = 1;
    public static final short ON_OR_BEFORE = 2;
    public static final short FIRST = 0;
    public static final short SECOND = 1;
    public static final short THIRD = 2;
    public static final short FOURTH = 3;
    public static final short FIFTH = 4;
    public static final short LAST = 5;
    public static final int START = 0;
    public static final int END = 1;
    private int cacheYear = -1;
    private int cacheBoundary = -1;
    private BTimeZone cacheTimeZone;
    private BAbsTime cachedTime;
    private BTime timeOfDay;
    private int timeMode;
    private BMonth month;
    private int day;
    private int dayMode;
    private BWeekday weekday;
    private int week;
    private static final Map<String, List<ZoneOffsetTransition>> LRU_RULE_TRANSITIONS_CACHE = Collections.synchronizedMap(new LinkedHashMap<String, List<ZoneOffsetTransition>>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, List<ZoneOffsetTransition>> eldest) {
            return this.size() > 10;
        }
    });
    private static final int MAX_RULES_CACHE = 10;

    private DstRule() {
    }

    public static Object fw(int cmd, Object a, Object b, Object c, Object d) {
        if (cmd == 1104 && a != null && b != null) {
            return DstRule.makeFromJavaTimeZone((TimeZone)a, (Boolean)b);
        }
        return null;
    }

    private static final DstRule makeFromJavaTimeZone(TimeZone javaTimeZone, boolean start) {
        Month month;
        ZoneRules javaRules = null;
        ZoneOffsetTransition targetTransition = null;
        ZoneOffsetTransitionRule targetTransitionRule = null;
        LocalDateTime targetTransitionOccurs = null;
        try {
            javaRules = ZoneRulesProvider.getRules(javaTimeZone.getID(), true);
            if (javaRules == null) {
                return null;
            }
        }
        catch (ZoneRulesException zre) {
            return null;
        }
        LocalDateTime nowInTarget = LocalDateTime.now(ZoneId.of(javaTimeZone.getID()));
        List<ZoneOffsetTransition> fixedTransitions = LRU_RULE_TRANSITIONS_CACHE.get(javaTimeZone.getID());
        if (fixedTransitions == null) {
            fixedTransitions = javaRules.getTransitions();
            LRU_RULE_TRANSITIONS_CACHE.put(javaTimeZone.getID(), fixedTransitions);
        }
        for (ZoneOffsetTransition currentTransition : fixedTransitions) {
            LocalDateTime beforeTransition = currentTransition.getDateTimeBefore();
            int transitionYear = beforeTransition.getYear();
            if (transitionYear == nowInTarget.getYear()) {
                if (start) {
                    if (!currentTransition.isGap()) continue;
                    targetTransition = currentTransition;
                    break;
                }
                if (!currentTransition.isOverlap()) continue;
                targetTransition = currentTransition;
                break;
            }
            if (transitionYear <= nowInTarget.getYear()) continue;
            return null;
        }
        if (targetTransition == null) {
            ZoneOffsetTransitionRule candidate;
            if (javaRules.getTransitionRules() == null || javaRules.getTransitionRules().size() == 0) {
                return null;
            }
            targetTransitionRule = start ? ((candidate = javaRules.getTransitionRules().get(0)).getStandardOffset().equals(candidate.getOffsetBefore()) ? candidate : javaRules.getTransitionRules().get(1)) : ((candidate = javaRules.getTransitionRules().get(1)).getStandardOffset().equals(candidate.getOffsetAfter()) ? candidate : javaRules.getTransitionRules().get(0));
        }
        if (targetTransition == null && targetTransitionRule == null) {
            return null;
        }
        if (targetTransition != null) {
            targetTransitionOccurs = targetTransition.getDateTimeBefore();
        }
        if (targetTransition != null) {
            month = targetTransitionOccurs.getMonth();
            int day = targetTransitionOccurs.getDayOfMonth();
            BTime time = BTime.make(targetTransitionOccurs.getHour(), targetTransitionOccurs.getMinute(), targetTransitionOccurs.getSecond());
            try {
                return DstRule.makeExact(time, 0, DstRule.convertJavaMonthToNiagaraMonth(month), day);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        if (targetTransitionRule != null) {
            try {
                month = targetTransitionRule.getMonth();
                int day = targetTransitionRule.getDayOfMonthIndicator();
                DayOfWeek dayOfWeek = targetTransitionRule.getDayOfWeek();
                LocalTime localTime = targetTransitionRule.getLocalTime();
                ZoneOffsetTransitionRule.TimeDefinition timeMode = targetTransitionRule.getTimeDefinition();
                boolean isMidnightEndOfDay = targetTransitionRule.isMidnightEndOfDay();
                BTime time = BTime.make(localTime.getHour(), localTime.getMinute(), localTime.getSecond());
                if (dayOfWeek == null) {
                    return DstRule.makeExact(time, DstRule.convertJavaTimeModeToNiagaraTimeMode(timeMode), DstRule.convertJavaMonthToNiagaraMonth(month), day);
                }
                if (day > 0) {
                    return DstRule.makeOnOrAfter(time, DstRule.convertJavaTimeModeToNiagaraTimeMode(timeMode), DstRule.convertJavaMonthToNiagaraMonth(month), day, DstRule.convertJavaWeekdayToNiagaraWeekday(dayOfWeek));
                }
                if (day < 0) {
                    int daysInMonth = BAbsTime.getDaysInMonth(nowInTarget.getYear(), DstRule.convertJavaMonthToNiagaraMonth(month));
                    day = daysInMonth + (day + 1);
                    return DstRule.makeOnOrAfter(time, DstRule.convertJavaTimeModeToNiagaraTimeMode(timeMode), DstRule.convertJavaMonthToNiagaraMonth(month), day, DstRule.convertJavaWeekdayToNiagaraWeekday(dayOfWeek));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            return null;
        }
        return null;
    }

    private static BWeekday convertJavaWeekdayToNiagaraWeekday(DayOfWeek dayOfWeek) throws Exception {
        switch (dayOfWeek) {
            case SUNDAY: {
                return BWeekday.sunday;
            }
            case MONDAY: {
                return BWeekday.monday;
            }
            case TUESDAY: {
                return BWeekday.tuesday;
            }
            case WEDNESDAY: {
                return BWeekday.wednesday;
            }
            case THURSDAY: {
                return BWeekday.thursday;
            }
            case FRIDAY: {
                return BWeekday.friday;
            }
            case SATURDAY: {
                return BWeekday.saturday;
            }
        }
        throw new Exception("Could not convert day of week");
    }

    private static int convertJavaTimeModeToNiagaraTimeMode(int mode) throws Exception {
        switch (mode) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 0: {
                return 0;
            }
        }
        throw new Exception("Could not convert mode");
    }

    private static int convertJavaTimeModeToNiagaraTimeMode(ZoneOffsetTransitionRule.TimeDefinition mode) throws Exception {
        switch (mode) {
            case STANDARD: {
                return 1;
            }
            case UTC: {
                return 2;
            }
            case WALL: {
                return 0;
            }
        }
        throw new Exception("Could not convert mode");
    }

    private static BMonth convertJavaMonthToNiagaraMonth(Month month) throws Exception {
        switch (month) {
            case JANUARY: {
                return BMonth.january;
            }
            case FEBRUARY: {
                return BMonth.february;
            }
            case MARCH: {
                return BMonth.march;
            }
            case APRIL: {
                return BMonth.april;
            }
            case MAY: {
                return BMonth.may;
            }
            case JUNE: {
                return BMonth.june;
            }
            case JULY: {
                return BMonth.july;
            }
            case AUGUST: {
                return BMonth.august;
            }
            case SEPTEMBER: {
                return BMonth.september;
            }
            case OCTOBER: {
                return BMonth.october;
            }
            case NOVEMBER: {
                return BMonth.november;
            }
            case DECEMBER: {
                return BMonth.december;
            }
        }
        throw new Exception("Could not convert month");
    }

    public static DstRule makeExact(BTime timeOfDay, BMonth month, int day) {
        return DstRule.makeExact(timeOfDay, 0, month, day);
    }

    public static DstRule makeExact(BTime timeOfDay, int timeMode, BMonth month, int day) {
        DstRule rule = new DstRule();
        rule.timeOfDay = timeOfDay;
        rule.timeMode = timeMode;
        rule.month = month;
        rule.day = day;
        rule.dayMode = 0;
        rule.weekday = null;
        rule.week = -1;
        return rule;
    }

    public static DstRule makeWeekday(BTime timeOfDay, int week, BWeekday weekday, BMonth month) {
        return DstRule.makeWeekday(timeOfDay, 0, week, weekday, month);
    }

    public static DstRule makeWeekday(BTime timeOfDay, int timeMode, int week, BWeekday weekday, BMonth month) {
        if (timeMode != 0 && timeMode != 1 && timeMode != 2) {
            throw new IllegalArgumentException("Invalid time mode: " + timeMode);
        }
        DstRule rule = new DstRule();
        rule.timeOfDay = timeOfDay;
        rule.timeMode = timeMode;
        rule.month = month;
        rule.weekday = weekday;
        rule.week = week;
        rule.day = 0;
        rule.dayMode = -1;
        return rule;
    }

    public static DstRule makeOnOrAfter(BTime timeOfDay, BMonth month, int day, BWeekday weekday) {
        return DstRule.makeOnOrAfter(timeOfDay, 0, month, day, weekday);
    }

    public static DstRule makeOnOrAfter(BTime timeOfDay, int timeMode, BMonth month, int day, BWeekday weekday) {
        if (timeMode != 0 && timeMode != 1 && timeMode != 2) {
            throw new IllegalArgumentException("Invalid time mode: " + timeMode);
        }
        DstRule rule = new DstRule();
        rule.timeOfDay = timeOfDay;
        rule.timeMode = timeMode;
        rule.month = month;
        rule.day = day;
        rule.dayMode = 1;
        rule.weekday = weekday;
        rule.week = -1;
        return rule;
    }

    public static DstRule makeOnOrBefore(BTime timeOfDay, BMonth month, int day, BWeekday weekday) {
        return DstRule.makeOnOrBefore(timeOfDay, 0, month, day, weekday);
    }

    public static DstRule makeOnOrBefore(BTime timeOfDay, int timeMode, BMonth month, int day, BWeekday weekday) {
        if (timeMode != 0 && timeMode != 1 && timeMode != 2) {
            throw new IllegalArgumentException("Invalid time mode: " + timeMode);
        }
        DstRule rule = new DstRule();
        rule.timeOfDay = timeOfDay;
        rule.timeMode = timeMode;
        rule.month = month;
        rule.day = day;
        rule.dayMode = 2;
        rule.weekday = weekday;
        rule.week = -1;
        return rule;
    }

    public BTime getTime() {
        return this.timeOfDay;
    }

    public int getTimeMode() {
        return this.timeMode;
    }

    public int getWeek() {
        return this.week;
    }

    public BWeekday getWeekday() {
        return this.weekday;
    }

    public BMonth getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getDayMode() {
        return this.dayMode;
    }

    public static int getUtcDayOfMonth(int year, DstRule rule) {
        if (rule.getDayMode() == -1) {
            GregorianCalendar dateCal = new GregorianCalendar(BTimeZone.getJavaUTCInstance());
            dateCal.set(1, year);
            dateCal.set(2, rule.getMonth().getOrdinal());
            if (rule.getWeek() == 5 || rule.getWeek() == 4) {
                dateCal.set(5, BAbsTime.getDaysInMonth(year, rule.getMonth()));
                dateCal.setLenient(false);
                while (dateCal.get(7) != rule.getWeekday().getOrdinal() + 1) {
                    ((Calendar)dateCal).add(5, -1);
                }
            } else {
                int d;
                if (rule.getWeek() == 0) {
                    d = 1;
                } else if (rule.getWeek() == 1) {
                    d = 8;
                } else if (rule.getWeek() == 2) {
                    d = 15;
                } else if (rule.getWeek() == 3) {
                    d = 22;
                } else {
                    throw new IllegalArgumentException("Invalid week: " + rule.getWeek());
                }
                dateCal.set(5, d);
                dateCal.setLenient(false);
                while (dateCal.get(7) != rule.getWeekday().getOrdinal() + 1) {
                    ((Calendar)dateCal).add(5, 1);
                }
            }
            return dateCal.get(5);
        }
        if (rule.getDayMode() == 0) {
            return rule.getDay();
        }
        if (rule.getDayMode() == 1 || rule.getDayMode() == 2) {
            GregorianCalendar dateCal = new GregorianCalendar(BTimeZone.getJavaUTCInstance());
            dateCal.set(year, rule.getMonth().getOrdinal(), rule.getDay());
            dateCal.setLenient(false);
            while (dateCal.get(7) != rule.getWeekday().getOrdinal() + 1) {
                if (rule.getDayMode() == 2) {
                    ((Calendar)dateCal).add(5, -1);
                    continue;
                }
                ((Calendar)dateCal).add(5, 1);
            }
            return dateCal.get(5);
        }
        throw new IllegalArgumentException("");
    }

    public final synchronized BAbsTime getTime(int year, BTimeZone timeZone, int boundary) {
        if (boundary != 0 && boundary != 1) {
            throw new IllegalArgumentException("Invalid boundary: " + boundary);
        }
        if (this.cacheYear == year && timeZone.equals(this.cacheTimeZone) && this.cacheBoundary == boundary) {
            return this.cachedTime;
        }
        this.cacheYear = year;
        this.cacheTimeZone = timeZone;
        this.cacheBoundary = boundary;
        this.cachedTime = this.calculateTime(year, timeZone, boundary);
        return this.cachedTime;
    }

    private BAbsTime calculateTime(int year, BTimeZone timeZone, int boundary) {
        GregorianCalendar newCal = new GregorianCalendar(BTimeZone.getJavaUTCInstance());
        newCal.clear();
        newCal.set(1, year);
        newCal.set(2, this.month.getOrdinal());
        if (this.dayMode == -1) {
            if (this.week == 5 || this.week == 4) {
                newCal.set(5, BAbsTime.getDaysInMonth(year, this.month));
                newCal.setLenient(false);
                while (newCal.get(7) != this.weekday.getOrdinal() + 1) {
                    ((Calendar)newCal).add(5, -1);
                }
            } else {
                int d;
                if (this.week == 0) {
                    d = 1;
                } else if (this.week == 1) {
                    d = 8;
                } else if (this.week == 2) {
                    d = 15;
                } else if (this.week == 3) {
                    d = 22;
                } else {
                    throw new IllegalArgumentException("Invalid week: " + this.week);
                }
                newCal.set(5, d);
                newCal.setLenient(false);
                while (newCal.get(7) != this.weekday.getOrdinal() + 1) {
                    ((Calendar)newCal).add(5, 1);
                }
            }
        } else if (this.dayMode == 0) {
            newCal.set(5, this.day);
        } else if (this.dayMode == 1 || this.dayMode == 2) {
            newCal.set(5, this.day);
            newCal.setLenient(false);
            while (newCal.get(7) != this.weekday.getOrdinal() + 1) {
                if (this.dayMode == 1) {
                    ((Calendar)newCal).add(5, 1);
                    continue;
                }
                ((Calendar)newCal).add(5, -1);
            }
        } else {
            throw new IllegalStateException("Cannot compute dst rule time.");
        }
        newCal.set(11, this.timeOfDay.getHour());
        newCal.set(12, this.timeOfDay.getMinute());
        newCal.set(13, this.timeOfDay.getSecond());
        newCal.set(14, this.timeOfDay.getSecond());
        if (this.timeMode == 2) {
            return BAbsTime.make(newCal.getTimeInMillis(), timeZone);
        }
        if (this.timeMode == 1) {
            return BAbsTime.make(newCal.getTimeInMillis() - (long)timeZone.getUtcOffset(), timeZone);
        }
        if (this.timeMode == 0) {
            long millis = newCal.getTimeInMillis() - (long)timeZone.getUtcOffset();
            if (boundary == 1) {
                millis -= (long)timeZone.getDaylightAdjustment();
            }
            return BAbsTime.make(millis, timeZone);
        }
        throw new IllegalArgumentException("Invalid time mode: " + this.timeMode);
    }

    public static DstRule getWallTimeRule(DstRule rule, int boundary, BTimeZone tz) {
        return rule == null ? null : rule.asWallTimeRule(boundary, tz);
    }

    private TimeZone getJavaTimeZone(long utcOffsetMillis) {
        if (utcOffsetMillis == 0L) {
            return BTimeZone.getJavaUTCInstance();
        }
        StringBuilder id = new StringBuilder("GMT");
        if (utcOffsetMillis > 0L) {
            id.append('+');
        }
        id.append(String.valueOf(utcOffsetMillis / 3600000L));
        id.append(":00");
        TimeZone result = TimeZone.getTimeZone(id.toString());
        if (result == null) {
            return new SimpleTimeZone((int)utcOffsetMillis, id.toString());
        }
        return result;
    }

    public DstRule asWallTimeRule(int boundary, BTimeZone tz) {
        if (this.getTimeMode() == 0) {
            return this;
        }
        if (this.getTimeMode() == 1 && boundary == 0) {
            DstRule result = new DstRule();
            result.timeOfDay = this.timeOfDay;
            result.timeMode = 0;
            result.month = this.month;
            result.day = this.day;
            result.dayMode = this.dayMode;
            result.weekday = this.weekday;
            result.week = this.week;
            return result;
        }
        GregorianCalendar cal = this.getTimeMode() == 2 ? new GregorianCalendar(BTimeZone.getJavaUTCInstance()) : new GregorianCalendar(this.getJavaTimeZone(tz.getUtcOffset()));
        int year = cal.get(1);
        cal.clear();
        cal.set(1, year);
        cal.set(2, this.getMonth().getOrdinal());
        cal.setLenient(false);
        if (this.getDayMode() == -1) {
            switch (this.getWeek()) {
                case 0: {
                    cal.set(5, 1);
                    while (cal.get(7) != this.getWeekday().getOrdinal() + 1) {
                        ((Calendar)cal).add(5, 1);
                    }
                    break;
                }
                case 1: {
                    cal.set(5, 8);
                    while (cal.get(7) != this.getWeekday().getOrdinal() + 1) {
                        ((Calendar)cal).add(5, 1);
                    }
                    break;
                }
                case 2: {
                    cal.set(5, 15);
                    while (cal.get(7) != this.getWeekday().getOrdinal() + 1) {
                        ((Calendar)cal).add(5, 1);
                    }
                    break;
                }
                case 3: {
                    cal.set(5, 22);
                    while (cal.get(7) != this.getWeekday().getOrdinal() + 1) {
                        ((Calendar)cal).add(5, 1);
                    }
                    break;
                }
                case 4: 
                case 5: {
                    cal.set(5, ((Calendar)cal).getActualMaximum(5));
                    while (cal.get(7) != this.getWeekday().getOrdinal() + 1) {
                        ((Calendar)cal).add(5, -1);
                    }
                    break;
                }
            }
        } else {
            switch (this.getDayMode()) {
                case 0: {
                    cal.set(5, this.getDay());
                    break;
                }
                case 1: {
                    cal.set(5, this.getDay());
                    while (cal.get(7) != this.getWeekday().getOrdinal() + 1) {
                        ((Calendar)cal).add(5, 1);
                    }
                    break;
                }
                case 2: {
                    cal.set(5, this.getDay());
                    while (cal.get(7) != this.getWeekday().getOrdinal() + 1) {
                        ((Calendar)cal).add(5, -1);
                    }
                    break;
                }
            }
        }
        cal.set(11, this.getTime().getHour());
        cal.set(12, this.getTime().getMinute());
        cal.set(13, this.getTime().getSecond());
        cal.set(14, this.getTime().getMillisecond());
        int oldDay = cal.get(5);
        int oldWeek = 0;
        if (1 <= oldDay && oldDay < 8) {
            oldWeek = 0;
        } else if (8 <= oldDay && oldDay < 15) {
            oldWeek = 1;
        } else if (15 <= oldDay && oldDay < 22) {
            oldWeek = 2;
        } else if (22 <= oldDay && oldDay < 29) {
            if (this.getWeek() != -1) {
                if (this.getWeek() == 5) {
                    oldWeek = 5;
                } else if (this.getWeek() == 3) {
                    oldWeek = 3;
                }
            } else {
                oldWeek = ((Calendar)cal).getActualMaximum(5) <= 28 ? 5 : (oldDay + 7 > ((Calendar)cal).getActualMaximum(5) ? 5 : 3);
            }
        } else if (29 <= oldDay && oldDay < 32) {
            oldWeek = 5;
        }
        BMonth oldMonth = BMonth.make(cal.get(2));
        long wallMillis = 0L;
        if (this.getTimeMode() == 1) {
            wallMillis = cal.getTime().getTime() + (long)tz.getDaylightAdjustment();
        } else {
            wallMillis = cal.getTime().getTime() + (long)tz.getUtcOffset();
            if (boundary == 1) {
                wallMillis += (long)tz.getDaylightAdjustment();
            }
        }
        cal.setTimeInMillis(wallMillis);
        int newDay = cal.get(5);
        BWeekday newWd = BWeekday.make(cal.get(7) - 1);
        int newWeek = 0;
        if (1 <= newDay && newDay < 8) {
            newWeek = 0;
        } else if (8 <= newDay && newDay < 15) {
            newWeek = 1;
        } else if (15 <= newDay && newDay < 22) {
            newWeek = 2;
        } else if (22 <= newDay && newDay < 29) {
            newWeek = ((Calendar)cal).getActualMaximum(5) <= 28 ? 5 : (newDay + 7 > ((Calendar)cal).getActualMaximum(5) ? 5 : 3);
        } else if (29 <= newDay && newDay < 32) {
            newWeek = 5;
        }
        BMonth newMonth = BMonth.make(cal.get(2));
        if (oldDay != newDay) {
            if (!oldMonth.equals(newMonth)) {
                return null;
            }
            if (this.getDayMode() != 0) {
                if (this.getDayMode() == 1) {
                    return null;
                }
                if (this.getDayMode() == 2) {
                    return null;
                }
                if (newWeek != oldWeek) {
                    return null;
                }
                return null;
            }
        }
        if (this.getDayMode() == -1) {
            return DstRule.makeWeekday(BTime.make(cal.get(11), cal.get(12), cal.get(13), cal.get(14)), 0, newWeek, newWd, newMonth);
        }
        if (this.getDayMode() == 0) {
            return DstRule.makeExact(BTime.make(cal.get(11), cal.get(12), cal.get(13), cal.get(14)), 0, newMonth, newDay);
        }
        if (this.getDayMode() == 2) {
            return DstRule.makeOnOrBefore(BTime.make(cal.get(11), cal.get(12), cal.get(13), cal.get(14)), 0, this.month, this.day, this.weekday);
        }
        return DstRule.makeOnOrAfter(BTime.make(cal.get(11), cal.get(12), cal.get(13), cal.get(14)), 0, this.month, this.day, this.weekday);
    }

    public static DstRule asWeekdayRule(DstRule rule) throws TimeZoneException {
        if (rule == null) {
            return rule;
        }
        if (rule.getDayMode() == -1) {
            return rule;
        }
        if (rule.getDayMode() == 0) {
            throw new TimeZoneException("Can't convert rule from exact to nth weekday");
        }
        int day = rule.getDay();
        int week = 0;
        if (rule.getDayMode() == 1) {
            switch (day) {
                case 1: {
                    week = 0;
                    break;
                }
                case 8: {
                    week = 1;
                    break;
                }
                case 15: {
                    week = 2;
                    break;
                }
                case 22: {
                    week = 3;
                    break;
                }
                case 29: {
                    week = 5;
                    break;
                }
                default: {
                    throw new TimeZoneException("Day = " + day + ". Can not accurately convert from ON_OR_AFTER to NTH day");
                }
            }
        }
        if (rule.getDayMode() == 2) {
            switch (day) {
                case 7: {
                    week = 0;
                    break;
                }
                case 14: {
                    week = 1;
                    break;
                }
                case 21: {
                    week = 2;
                    break;
                }
                case 28: {
                    week = 3;
                    break;
                }
                default: {
                    throw new TimeZoneException("Day = " + day + ". Can not accurately convert from ON_OR_BEFORE to NTH day");
                }
            }
        }
        return DstRule.makeWeekday(rule.getTime(), rule.getTimeMode(), week, rule.getWeekday(), rule.getMonth());
    }

    public static boolean equals(DstRule r1, DstRule r2) {
        if (r1 == null) {
            return r2 == null;
        }
        if (r1 == r2) {
            return true;
        }
        if (r2 == null) {
            return false;
        }
        return r1.timeOfDay.equals(r2.timeOfDay) && r1.timeMode == r2.timeMode && r1.month.equals(r2.month) && r1.day == r2.day && r1.dayMode == r2.dayMode && r1.weekday == r2.weekday && r1.week == r2.week;
    }

    public static boolean isEquivalent(DstRule r1, DstRule r2, BTimeZone tz, int boundary) {
        if (r1 == null) {
            return r2 == null;
        }
        if (r1 == r2) {
            return true;
        }
        if (r2 == null) {
            return false;
        }
        DstRule w1 = null;
        DstRule w2 = null;
        try {
            w1 = DstRule.asWeekdayRule(r1);
        }
        catch (TimeZoneException e) {
            w1 = r1;
        }
        try {
            w2 = DstRule.asWeekdayRule(r2);
        }
        catch (TimeZoneException e) {
            w2 = r2;
        }
        int week1 = w1.week;
        int week2 = w2.week;
        if (week1 == 4) {
            week1 = 5;
        }
        if (week2 == 4) {
            week2 = 5;
        }
        if (w1.month.equals(w2.month) && w1.day == w2.day && w1.dayMode == w2.dayMode && w1.weekday == w2.weekday && week1 == week2) {
            if (w1.timeMode == w2.timeMode && w1.timeOfDay.equals(w2.timeOfDay)) {
                return true;
            }
            w1 = w1.asWallTimeRule(boundary, tz);
            w2 = w2.asWallTimeRule(boundary, tz);
            return w1 != null && w2 != null && w1.timeOfDay.equals(w2.timeOfDay);
        }
        return false;
    }

    public boolean equals(Object o) {
        return o instanceof DstRule && DstRule.equals(this, (DstRule)o);
    }

    public int hashCode() {
        return Objects.hash(this.timeOfDay, this.timeMode, this.month, this.day, this.dayMode, this.weekday, this.week);
    }

    public boolean isEquivalent(DstRule o, BTimeZone tz, int boundary) {
        return DstRule.isEquivalent(this, o, tz, boundary);
    }

    public void encode(DataOutput out) throws IOException {
        this.timeOfDay.encode(out);
        out.writeInt(this.timeMode);
        this.month.encode(out);
        out.writeInt(this.day);
        out.writeInt(this.dayMode);
        out.writeBoolean(this.weekday != null);
        if (this.weekday != null) {
            this.weekday.encode(out);
        }
        out.writeInt(this.week);
    }

    public static DstRule decode(DataInput in) throws IOException {
        DstRule rule = new DstRule();
        rule.timeOfDay = (BTime)BTime.DEFAULT.decode(in);
        rule.timeMode = in.readInt();
        rule.month = (BMonth)BMonth.january.decode(in);
        rule.day = in.readInt();
        rule.dayMode = in.readInt();
        if (in.readBoolean()) {
            rule.weekday = (BWeekday)BWeekday.sunday.decode(in);
        }
        rule.week = in.readInt();
        return rule;
    }

    public String encodeToString() throws IOException {
        StringBuilder s = new StringBuilder(128);
        s.append(this.timeOfDay.encodeToString());
        s.append(',');
        s.append(DstRule.encodeTimeMode(this.timeMode));
        s.append(',');
        s.append(this.month.encodeToString());
        s.append(',');
        s.append(this.day);
        s.append(',');
        s.append(DstRule.encodeDayMode(this.dayMode));
        s.append(',');
        s.append(this.weekday == null ? "null" : this.weekday.encodeToString());
        s.append(',');
        s.append(DstRule.encodeWeek(this.week));
        return s.toString();
    }

    public static DstRule decodeFromString(String s) throws IOException {
        StringTokenizer tokens = new StringTokenizer(s, ",");
        DstRule rule = new DstRule();
        rule.timeOfDay = (BTime)BTime.DEFAULT.decodeFromString(tokens.nextToken());
        rule.timeMode = DstRule.decodeTimeMode(tokens.nextToken());
        rule.month = (BMonth)BMonth.january.decodeFromString(tokens.nextToken());
        rule.day = Integer.parseInt(tokens.nextToken());
        rule.dayMode = DstRule.decodeDayMode(tokens.nextToken());
        String weekday = tokens.nextToken();
        if (!weekday.equals("null")) {
            rule.weekday = (BWeekday)BWeekday.sunday.decodeFromString(weekday);
        }
        rule.week = DstRule.decodeWeek(tokens.nextToken());
        return rule;
    }

    public static String encodeDayMode(int dayMode) {
        switch (dayMode) {
            case -1: {
                return "undefined";
            }
            case 0: {
                return "exact";
            }
            case 2: {
                return "on or before";
            }
            case 1: {
                return "on or after";
            }
        }
        return "invalid: " + dayMode;
    }

    public static int decodeDayMode(String txt) {
        if (txt.equals("undefined")) {
            return -1;
        }
        if (txt.equals("exact")) {
            return 0;
        }
        if (txt.equals("on or before")) {
            return 2;
        }
        if (txt.equals("on or after")) {
            return 1;
        }
        return -1;
    }

    public static String encodeWeek(int week) {
        switch (week) {
            case 0: {
                return "first";
            }
            case 1: {
                return "second";
            }
            case 2: {
                return "third";
            }
            case 3: {
                return "fourth";
            }
            case 4: {
                return "fifth";
            }
            case 5: {
                return "last";
            }
            case -1: {
                return "undefined";
            }
        }
        throw new IllegalArgumentException("Invalid week specification: " + week);
    }

    public static int decodeWeek(String txt) {
        if (txt.equals("first")) {
            return 0;
        }
        if (txt.equals("second")) {
            return 1;
        }
        if (txt.equals("third")) {
            return 2;
        }
        if (txt.equals("fourth")) {
            return 3;
        }
        if (txt.equals("fifth")) {
            return 4;
        }
        if (txt.equals("last")) {
            return 5;
        }
        if (txt.equals("undefined")) {
            return -1;
        }
        throw new IllegalArgumentException("Invalid week specification: " + txt);
    }

    public static String encodeTimeMode(int timeMode) {
        switch (timeMode) {
            case 0: {
                return "wall";
            }
            case 1: {
                return "standard";
            }
            case 2: {
                return "utc";
            }
        }
        return "invalid: " + timeMode;
    }

    public static int decodeTimeMode(String txt) {
        if (txt.equals("wall")) {
            return 0;
        }
        if (txt.equals("standard")) {
            return 1;
        }
        if (txt.equals("utc")) {
            return 2;
        }
        return -1;
    }
}

