/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import com.tridium.sys.schema.ComponentSlotMap;
import com.tridium.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.baja.naming.BOrd;
import javax.baja.naming.BatchResolve;
import javax.baja.space.BComponentSpace;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BComponentEventMask;
import javax.baja.sys.Context;

public abstract class Subscriber {
    private HashMap<BComponent, BComponent> subscriptions = new HashMap();
    private BComponentEventMask mask = BComponentEventMask.PROPERTY_EVENTS;

    public static final Subscriber make(final Consumer<BComponentEvent> eventHandler) {
        Objects.requireNonNull(eventHandler);
        return new Subscriber(){

            @Override
            public void event(BComponentEvent event) {
                eventHandler.accept(event);
            }
        };
    }

    public static final Subscriber make(final Consumer<BComponentEvent> eventHandler, final BiConsumer<BComponent, Context> subscribedHandler, final BiConsumer<BComponent, Context> unsubscribedHandler) {
        Objects.requireNonNull(eventHandler);
        Objects.requireNonNull(subscribedHandler);
        Objects.requireNonNull(unsubscribedHandler);
        return new Subscriber(){

            @Override
            public void event(BComponentEvent event) {
                eventHandler.accept(event);
            }

            @Override
            protected void subscribed(BComponent c, Context cx) {
                subscribedHandler.accept(c, cx);
            }

            @Override
            protected void unsubscribed(BComponent c, Context cx) {
                unsubscribedHandler.accept(c, cx);
            }
        };
    }

    public final synchronized boolean isSubscribed(BComponent c) {
        return this.subscriptions.get(c) != null;
    }

    public final synchronized boolean isSubscribed(BComponent[] c) {
        for (int i = 0; i < c.length; ++i) {
            if (this.subscriptions.get(c[i]) != null) continue;
            return false;
        }
        return true;
    }

    public final int getSubscriptionCount() {
        return this.subscriptions.size();
    }

    public final synchronized BComponent[] getSubscriptions() {
        Collection<BComponent> values = this.subscriptions.values();
        return values.toArray(new BComponent[values.size()]);
    }

    public final synchronized void subscribe(BComponent c) {
        this.subscribe(c, 0, null);
    }

    public final synchronized void subscribe(BComponent c, int depth) {
        this.subscribe(c, depth, null);
    }

    public final synchronized void subscribe(BComponent c, int depth, Context cx) {
        this.subscribe(new BComponent[]{c}, depth, cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void subscribe(BComponent[] c, int depth, Context cx) {
        int i;
        if (c.length == 0) {
            return;
        }
        try {
            for (i = 0; i < c.length; ++i) {
                if (this.subscriptions.get(c[i]) != null) continue;
                ((ComponentSlotMap)c[i].getSlotMap()).setPendingSubscribe(this);
            }
            this.updateSpaceSubscription(c, true, depth);
            this.doSubscribe(c, depth, cx);
        }
        finally {
            for (i = 0; i < c.length; ++i) {
                ((ComponentSlotMap)c[i].getSlotMap()).clearPendingSubscribe(this);
            }
        }
    }

    public final BComponent[] subscribe(BComponentSpace space, BOrd[] ords, int depth, Context cx) {
        BatchResolve r = new BatchResolve(ords).resolve(space, cx);
        BComponent[] components = new BComponent[ords.length];
        for (int i = 0; i < components.length; ++i) {
            components[i] = (BComponent)r.get(i);
        }
        this.subscribe(components, depth, cx);
        return components;
    }

    private void doSubscribe(BComponent[] c, int depth, Context cx) {
        for (int i = 0; i < c.length; ++i) {
            this.doSubscribe(c[i], depth, cx);
        }
    }

    private void doSubscribe(BComponent c, int depth, Context cx) {
        if (this.subscriptions.get(c) == null) {
            this.subscriptions.put(c, c);
            ((ComponentSlotMap)c.getSlotMap()).subscribe(this);
        }
        try {
            this.subscribed(c, cx);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (depth > 0) {
            c.loadSlots();
            for (BComponent kid : c.getChildComponents()) {
                this.doSubscribe(kid, depth - 1, cx);
            }
        }
    }

    public final synchronized void unsubscribe(BComponent c) {
        this.unsubscribe(c, null);
    }

    public final synchronized void unsubscribe(BComponent c, Context cx) {
        this.unsubscribe(new BComponent[]{c}, cx);
    }

    public final synchronized void unsubscribe(BComponent[] c, Context cx) {
        if (c.length == 0) {
            return;
        }
        this.doUnsubscribe(c, cx);
    }

    public final synchronized void unsubscribeAll() {
        this.unsubscribe(this.getSubscriptions(), null);
    }

    private void doUnsubscribe(BComponent[] c, Context cx) {
        int i;
        for (i = 0; i < c.length; ++i) {
            if (!this.isSubscribed(c[i])) continue;
            this.subscriptions.remove(c[i]);
            ((ComponentSlotMap)c[i].getSlotMap()).unsubscribe(this);
        }
        this.updateSpaceSubscription(c, false, 0);
        for (i = 0; i < c.length; ++i) {
            try {
                this.unsubscribed(c[i], cx);
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private void updateSpaceSubscription(BComponent[] c, boolean subscribe, int depth) {
        HashMap<BComponentSpace, ArrayList<BComponent>> bySpace = new HashMap<BComponentSpace, ArrayList<BComponent>>();
        for (int i = 0; i < c.length; ++i) {
            BComponent comp = c[i];
            if (!subscribe && comp.isSubscribed()) continue;
            BComponentSpace space = comp.getComponentSpace();
            ArrayList<BComponent> bucket = (ArrayList<BComponent>)bySpace.get(space);
            if (bucket == null) {
                bucket = new ArrayList<BComponent>();
                bySpace.put(space, bucket);
            }
            bucket.add(comp);
        }
        for (BComponentSpace space : bySpace.keySet()) {
            if (space == null) continue;
            List bucket = (List)bySpace.get(space);
            BComponent[] bucketArray = bucket.toArray(new BComponent[bucket.size()]);
            if (subscribe) {
                space.getSubscribeCallbacks().subscribe(bucketArray, depth);
                continue;
            }
            space.getSubscribeCallbacks().unsubscribe(bucketArray);
        }
    }

    public final BComponentEventMask getMask() {
        return this.mask;
    }

    public final void setMask(BComponentEventMask mask) {
        this.mask = mask;
    }

    public abstract void event(BComponentEvent var1);

    protected void subscribed(BComponent c, Context cx) {
    }

    protected void unsubscribed(BComponent c, Context cx) {
    }

    public synchronized void gc() {
        int n = 0;
        BComponent[] c = this.getSubscriptions();
        for (int i = 0; i < c.length; ++i) {
            if (c[i].isMounted()) continue;
            this.unsubscribe(c[i], null);
            ++n;
        }
    }

    public void spy(SpyWriter out) {
        out.startTable(true);
        BComponent[] c = this.getSubscriptions();
        out.trTitle("Subscriptions (" + c.length + " Components)", 1);
        for (int i = 0; i < c.length; ++i) {
            out.tr().td().a(String.valueOf(ObjectUtil.toSpyRelative(c[i])), c[i].toPathString()).endTd().endTr();
        }
        out.endTable();
    }
}

