/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BIComparable;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BString
extends BSimple
implements BIComparable,
BIDataValue {
    public static final BString DEFAULT = new BString("");
    public static final Type TYPE = Sys.loadType(BString.class);
    private String value;

    public static BString make(String s) {
        if (s.equals("")) {
            return DEFAULT;
        }
        return new BString(s);
    }

    private BString(String value) {
        this.value = value;
    }

    public String getString() {
        return this.value;
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    public static boolean equals(String a, String b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return a.equals(b);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BString) {
            return this.value.equals(((BString)obj).value);
        }
        return false;
    }

    @Override
    public int compareTo(Object obj) {
        return this.value.compareTo(((BString)obj).getString());
    }

    @Override
    public String toString(Context context) {
        return this.value;
    }

    @Override
    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.value);
    }

    @Override
    public BObject decode(DataInput in) throws IOException {
        String s = in.readUTF();
        return BString.make(s);
    }

    @Override
    public String encodeToString() throws IOException {
        return this.value;
    }

    @Override
    public BObject decodeFromString(String s) throws IOException {
        return BString.make(s);
    }

    @Override
    public BIDataValue toDataValue() {
        return this;
    }

    @Override
    public Type getType() {
        return TYPE;
    }
}

