/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIComparable;
import javax.baja.sys.BLong;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconModule;

public final class BRelTime
extends BSimple
implements BIDataValue,
BIComparable {
    public static final BRelTime DEFAULT = new BRelTime(0L);
    public static final Type TYPE = Sys.loadType(BRelTime.class);
    public static final long MILLIS_IN_SECOND = 1000L;
    public static final long MILLIS_IN_MINUTE = 60000L;
    public static final long MILLIS_IN_HOUR = 3600000L;
    public static final long MILLIS_IN_DAY = 86400000L;
    public static final long MILLIS_IN_WEEK = 604800000L;
    private static final long DAYS_IN_MONTH = 30L;
    private static final long DAYS_IN_YEAR = 365L;
    private static final long MILLIS_IN_MONTH = 2592000000L;
    private static final long MILLIS_IN_YEAR = 31536000000L;
    public static final BRelTime SECOND = BRelTime.make(1000L);
    public static final BRelTime MINUTE = BRelTime.make(60000L);
    public static final BRelTime HOUR = BRelTime.make(3600000L);
    public static final BRelTime DAY = BRelTime.make(86400000L);
    public static final BRelTime WEEK = BRelTime.make(604800000L);
    public static final String SHOW_DAYS = "showDays";
    public static final String SHOW_HOURS = "showHours";
    public static final String SHOW_MINUTES = "showMinutes";
    private static final LexiconModule LEX = LexiconModule.make(TYPE);
    private final long ms;

    public static BRelTime make(long ms) {
        if (ms == 0L) {
            return DEFAULT;
        }
        return (BRelTime)new BRelTime(ms).intern();
    }

    public static BRelTime make(String s) throws IOException {
        return (BRelTime)DEFAULT.decodeFromString(s);
    }

    public static BRelTime makeDays(int days) {
        return BRelTime.make(86400000L * (long)days);
    }

    public static BRelTime makeHours(int hours) {
        return BRelTime.make(3600000L * (long)hours);
    }

    public static BRelTime makeMinutes(int minutes) {
        return BRelTime.make(60000L * (long)minutes);
    }

    public static BRelTime makeSeconds(int seconds) {
        return BRelTime.make(1000L * (long)seconds);
    }

    public static BRelTime make(int days, int hours, int minutes, int seconds) {
        return BRelTime.make(86400000L * (long)days + 3600000L * (long)hours + 60000L * (long)minutes + 1000L * (long)seconds);
    }

    private BRelTime(long ms) {
        this.ms = ms;
    }

    public long getMillis() {
        return this.ms;
    }

    public int getSeconds() {
        return (int)(this.ms / 1000L);
    }

    public int getMinutes() {
        return (int)(this.ms / 60000L);
    }

    public int getHours() {
        return (int)(this.ms / 3600000L);
    }

    public int getDays() {
        return (int)(this.ms / 86400000L);
    }

    public long getMillisPart() {
        return this.ms % 1000L;
    }

    public int getSecondsPart() {
        return (int)((this.ms - this.getMillisPart()) % 60000L / 1000L);
    }

    public int getMinutesPart() {
        return (int)((this.ms - 1000L * (long)this.getSecondsPart()) % 3600000L / 60000L);
    }

    public int getHoursPart() {
        return (int)((this.ms - 60000L * (long)this.getMinutesPart()) % 86400000L / 3600000L);
    }

    public int getDaysPart() {
        return (int)((this.ms - 3600000L * (long)this.getHoursPart()) / 86400000L);
    }

    public BRelTime abs() {
        if (this.ms >= 0L) {
            return this;
        }
        return BRelTime.make(Math.abs(this.ms));
    }

    @Override
    public int hashCode() {
        return (int)(this.ms ^ this.ms >> 32);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BRelTime) {
            return ((BRelTime)obj).ms == this.ms;
        }
        return false;
    }

    @Override
    public int compareTo(Object o) {
        BRelTime t = (BRelTime)o;
        long delta = this.getMillis() - t.getMillis();
        if (delta == 0L) {
            return 0;
        }
        if (delta < 0L) {
            return -1;
        }
        return 1;
    }

    public Duration toDuration() {
        return Duration.ofMillis(this.ms);
    }

    public static String toString(long ms) {
        return BRelTime.toString(ms, null);
    }

    public static String toString(long ms, Context cx) {
        BBoolean x;
        BBoolean x2;
        BBoolean x3;
        BBoolean x4;
        BBoolean x5;
        ArrayList<String> fields = new ArrayList<String>();
        Context numberCx = BRelTime.toNumberLocalizationContext(cx);
        String prefix = "";
        boolean showMillis = true;
        if (cx != null && (x5 = (BBoolean)cx.getFacet("showMilliseconds")) != null) {
            showMillis = x5.getBoolean();
        }
        boolean showSeconds = true;
        if (cx != null && (x4 = (BBoolean)cx.getFacet("showSeconds")) != null) {
            showSeconds = x4.getBoolean();
        }
        boolean showMinutes = true;
        if (cx != null && (x3 = (BBoolean)cx.getFacet(SHOW_MINUTES)) != null) {
            showMinutes = x3.getBoolean();
        }
        boolean showHours = true;
        if (cx != null && (x2 = (BBoolean)cx.getFacet(SHOW_HOURS)) != null) {
            showHours = x2.getBoolean();
        }
        boolean showDays = true;
        if (cx != null && (x = (BBoolean)cx.getFacet(SHOW_DAYS)) != null) {
            showDays = x.getBoolean();
        }
        if (ms < 0L) {
            prefix = "-";
            ms = -ms;
        }
        if (ms < 1000L) {
            if (showSeconds) {
                if (showMillis) {
                    return prefix + BRelTime.getText("ms", cx, ms);
                }
                return prefix + BRelTime.getText("seconds", cx, 0);
            }
            if (showMinutes) {
                return prefix + BRelTime.getText("minutes", cx, 0);
            }
            if (showHours) {
                return prefix + BRelTime.getText("hours", cx, 0);
            }
            if (showDays) {
                return prefix + BRelTime.getText("days", cx, 0);
            }
        }
        if (ms >= 86400000L && showDays) {
            long days = ms / 86400000L;
            ms %= 86400000L;
            fields.add(BRelTime.getText(days == 1L ? "day" : "days", cx, BLong.make(days).toString(numberCx)));
        }
        if (ms >= 3600000L && showHours) {
            long hours = ms / 3600000L;
            ms %= 3600000L;
            fields.add(BRelTime.getText(hours == 1L ? "hour" : "hours", cx, BLong.make(hours).toString(numberCx)));
        }
        if (ms >= 60000L && showMinutes) {
            long mins = ms / 60000L;
            ms %= 60000L;
            fields.add(BRelTime.getText(mins == 1L ? "minute" : "minutes", cx, BLong.make(mins).toString(numberCx)));
        }
        if (ms > 0L && showSeconds) {
            String suffix;
            long secs = ms / 1000L;
            long millisPart = ms % 1000L;
            String string = suffix = secs != 1L || millisPart != 0L ? "seconds" : "second";
            if (showMillis && millisPart > 0L) {
                BasicContext triplePrecision = new BasicContext(numberCx, BFacets.make("precision", 3));
                fields.add(BRelTime.getText(suffix, cx, BDouble.make((double)ms / 1000.0).toString(triplePrecision)));
            } else {
                fields.add(BRelTime.getText(suffix, cx, BLong.make(secs).toString(numberCx)));
            }
        }
        return prefix + String.join((CharSequence)(LEX.get("relTime.separator", cx, ",") + ' '), fields);
    }

    @Override
    public String toString(Context context) {
        return BRelTime.toString(this.ms, context);
    }

    public String toFriendlyString(Context cx) {
        long duration = Math.abs(this.getMillis());
        if (duration == 0L) {
            return LEX.get("relTime.friendly.rightNow", cx);
        }
        String durationText = duration < 60000L ? BRelTime.getFriendlyText("aFewSeconds", cx, new Object[0]) : (duration < 120000L ? BRelTime.getFriendlyText("minute", cx, new Object[0]) : (duration < 3600000L ? BRelTime.getFriendlyText("minutes", cx, Math.abs(this.getMinutes())) : (duration < 0x6DDD00L ? BRelTime.getFriendlyText("hour", cx, new Object[0]) : (duration < 86400000L ? BRelTime.getFriendlyText("hours", cx, Math.abs(this.getHours())) : (duration < 172800000L ? BRelTime.getFriendlyText("day", cx, new Object[0]) : (duration < 2592000000L ? BRelTime.getFriendlyText("days", cx, Math.abs(this.getDays())) : (duration < 5184000000L ? BRelTime.getFriendlyText("month", cx, new Object[0]) : (duration < 31536000000L ? BRelTime.getFriendlyText("months", cx, (long)Math.abs(this.getDays()) / 30L) : (duration < 63072000000L ? BRelTime.getFriendlyText("year", cx, new Object[0]) : BRelTime.getFriendlyText("years", cx, (long)Math.abs(this.getDays()) / 365L))))))))));
        return BRelTime.getFriendlyText(this.getMillis() < 0L ? "inThePast" : "inTheFuture", cx, durationText);
    }

    private static String getText(String suffix, Context cx, Object ... args) {
        return LEX.getText("relTime." + suffix, cx, args);
    }

    private static String getFriendlyText(String suffix, Context cx, Object ... args) {
        return LEX.getText("relTime.friendly." + suffix, cx, args);
    }

    private static Context toNumberLocalizationContext(Context cx) {
        if (cx == null) {
            return null;
        }
        BasicContext languageCx = new BasicContext(null, cx.getLanguage());
        BObject showSeparators = cx.getFacet("showSeparators");
        if (showSeparators instanceof BBoolean) {
            return new BasicContext(languageCx, BFacets.make("showSeparators", (BBoolean)showSeparators));
        }
        return languageCx;
    }

    @Override
    public void encode(DataOutput out) throws IOException {
        out.writeLong(this.ms);
    }

    @Override
    public BObject decode(DataInput in) throws IOException {
        return BRelTime.make(in.readLong());
    }

    @Override
    public String encodeToString() {
        return String.valueOf(this.ms);
    }

    @Override
    public BObject decodeFromString(String s) throws IOException {
        if (s.equals("0")) {
            return DEFAULT;
        }
        return new BRelTime(new Long(s)).intern();
    }

    @Override
    public BIDataValue toDataValue() {
        return this;
    }

    @Override
    public Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x == 116) {
            if (Math.abs(this.ms) > 1000L && this.getMillisPart() != 0L) {
                return Boolean.TRUE;
            }
            return null;
        }
        return super.fw(x, a, b, c, d);
    }

    @Override
    public Type getType() {
        return TYPE;
    }
}

