/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import javax.baja.data.BIDataValue;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BIComparable;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BNumber
extends BSimple
implements BIComparable,
BINumeric,
BIDataValue {
    public static final Type TYPE = Sys.loadType(BNumber.class);

    BNumber() {
    }

    public abstract int getInt();

    public abstract long getLong();

    public abstract float getFloat();

    public abstract double getDouble();

    @Override
    public final double getNumeric() {
        return this.getDouble();
    }

    @Override
    public final BFacets getNumericFacets() {
        return BFacets.NULL;
    }

    @Override
    public final BIDataValue toDataValue() {
        return this;
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public static BNumber cast(BNumber number, Type type) {
        return BNumber.cast(number.getNumeric(), type);
    }

    public static BNumber cast(double number, Type type) {
        switch (type.getDataTypeSymbol()) {
            case 'i': {
                return BInteger.make((int)number);
            }
            case 'l': {
                return BLong.make((long)number);
            }
            case 'f': {
                return BFloat.make((float)number);
            }
            case 'd': {
                return BDouble.make(number);
            }
        }
        throw new IllegalArgumentException("Invalid type to cast to BNumber: " + type);
    }
}

